/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.BasicTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.IdentifiableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelImpl
implements Metamodel {
    protected DatabaseSession session;
    protected Map<Class, EntityTypeImpl<?>> entities;
    protected Map<Class, EmbeddableTypeImpl<?>> embeddables;
    protected Map<Class, ManagedTypeImpl<?>> managedTypes;
    private Map<Class, TypeImpl<?>> types;
    private Set<MappedSuperclassTypeImpl<?>> mappedSuperclasses;

    public MetamodelImpl(DatabaseSession session) {
        this.session = session;
        this.initialize();
    }

    public MetamodelImpl(EntityManagerFactory emf) {
        this((DatabaseSession)JpaHelper.getServerSession(emf));
    }

    public MetamodelImpl(EntityManager em) {
        this((DatabaseSession)JpaHelper.getEntityManager(em).getServerSession());
    }

    public DatabaseSession getSession() {
        return this.session;
    }

    public <X> EmbeddableType<X> embeddable(Class<X> clazz) {
        return this.embeddables.get(clazz);
    }

    public <X> EntityType<X> entity(Class<X> clazz) {
        return this.entities.get(clazz);
    }

    public <X> ManagedType<X> type(Class<X> clazz) {
        return this.managedTypes.get(clazz);
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return new LinkedHashSet(this.embeddables.values());
    }

    public Set<EntityType<?>> getEntities() {
        return new LinkedHashSet(this.entities.values());
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return new LinkedHashSet(this.managedTypes.values());
    }

    private void initialize() {
        this.types = new LinkedHashMap();
        this.entities = new LinkedHashMap();
        this.embeddables = new LinkedHashMap();
        this.managedTypes = new LinkedHashMap();
        this.mappedSuperclasses = new HashSet();
        for (RelationalDescriptor descriptor : this.getSession().getDescriptors().values()) {
            ManagedTypeImpl<?> managedType = ManagedTypeImpl.create(this, descriptor);
            this.types.put(managedType.getJavaType(), managedType);
            this.managedTypes.put(managedType.getJavaType(), managedType);
            if (managedType.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                this.entities.put(managedType.getJavaType(), (EntityTypeImpl)managedType);
            }
            if (!managedType.getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) continue;
            this.embeddables.put(managedType.getJavaType(), (EmbeddableTypeImpl)managedType);
        }
        try {
            Project project = this.getSession().getProject();
            Map descriptors = project.getMappedSuperclassDescriptors();
            for (RelationalDescriptor descriptor : descriptors.values()) {
                ClassLoader classLoader = this.getSession().getActiveSession().getClass().getClassLoader();
                descriptor.convertClassNamesToClasses(classLoader);
                MappedSuperclassTypeImpl mappedSuperclassType = new MappedSuperclassTypeImpl(this, descriptor);
                this.mappedSuperclasses.add(mappedSuperclassType);
                this.managedTypes.put(mappedSuperclassType.getJavaType(), mappedSuperclassType);
                this.types.put(mappedSuperclassType.getJavaType(), mappedSuperclassType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList aTypeList = new ArrayList(this.types.values());
        for (int index = 0; index < aTypeList.size(); ++index) {
            TypeImpl aType = (TypeImpl)aTypeList.get(index);
            if (!aType.isManagedType()) continue;
            ((ManagedTypeImpl)aType).initialize();
        }
        for (ManagedTypeImpl<?> potentialIdentifiableType : this.managedTypes.values()) {
            Class aClass = potentialIdentifiableType.getJavaType();
            Class superclass = aClass.getSuperclass();
            if (!potentialIdentifiableType.isIdentifiableType() || superclass == ClassConstants.OBJECT) continue;
            IdentifiableType identifiableTypeSuperclass = (IdentifiableType)this.managedTypes.get(superclass);
            ((IdentifiableTypeImpl)potentialIdentifiableType).setSupertype(identifiableTypeSuperclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> TypeImpl<X> getType(Class<X> javaClass) {
        TypeImpl<?> type = this.types.get(javaClass);
        if (null == type) {
            Map<Class, TypeImpl<?>> map = this.types;
            synchronized (map) {
                type = this.types.get(javaClass);
                if (null == type) {
                    type = new BasicTypeImpl(javaClass);
                    this.types.put(javaClass, type);
                }
            }
        }
        return type;
    }

    public Set<MappedSuperclassTypeImpl<?>> getMappedSuperclasses() {
        return this.mappedSuperclasses;
    }
}

