/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.Server;
import org.glassfish.ejb.embedded.EJBContainerImpl;
import org.glassfish.ejb.embedded.EjbBuilder;
import org.glassfish.ejb.embedded.EmbeddedEjbContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerProviderImpl
implements EJBContainerProvider {
    private static final String GF_PROVIDER_NAME = EJBContainerProviderImpl.class.getName();
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private static final StringManager localStrings = StringManager.getManager(EJBContainerProviderImpl.class);
    private static final Object lock = new Object();
    private static EJBContainerImpl container;
    private static Server server;

    @Override
    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        if (properties == null || properties.get("javax.ejb.embeddable.provider") == null || properties.get("javax.ejb.embeddable.provider").equals(GF_PROVIDER_NAME)) {
            this.init(properties);
            if (container.isOpen()) {
                throw new EJBException(localStrings.getString("ejb.embedded.exception_exists_container"));
            }
            try {
                HashSet<File> modules = new HashSet<File>();
                this.addEJBModules(modules, properties);
                if (modules.isEmpty()) {
                    _logger.log(Level.SEVERE, "No EJB modules found");
                }
                container.deploy(properties, modules);
                return container;
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "ejb.embedded.exception_instantiating", t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Map<?, ?> properties) throws EJBException {
        Object object = lock;
        synchronized (object) {
            if (container == null) {
                Server.Builder builder = new Server.Builder("GFEJBContainerProviderImpl");
                File installed_root = null;
                File domain_file = null;
                if (properties != null) {
                    String gf_root = (String)properties.get("glassfish.ejb.embedded.glassfish.installation");
                    System.err.println("+++ gf_root : " + gf_root);
                    if (gf_root != null) {
                        installed_root = new File(gf_root);
                        if (!installed_root.exists()) {
                            _logger.log(Level.SEVERE, "ejb.embedded.location_not_exists", gf_root);
                            installed_root = null;
                        } else {
                            String domain_root = gf_root + File.separatorChar + "domains" + File.separatorChar + "domain1" + File.separatorChar + "config" + File.separatorChar + "domain.xml";
                            System.err.println("+++ domain_root : " + domain_root);
                            domain_file = new File(domain_root);
                            if (!domain_file.exists()) {
                                _logger.log(Level.SEVERE, "ejb.embedded.location_not_exists", domain_root);
                                installed_root = null;
                            }
                        }
                    }
                }
                System.err.println("+++ installed_root: " + installed_root);
                System.err.println("+++ domain_file: " + domain_file);
                if (installed_root == null) {
                    server = builder.build();
                } else {
                    EmbeddedFileSystem.Builder efsb = new EmbeddedFileSystem.Builder();
                    efsb.setInstallRoot(installed_root);
                    efsb.setConfigurationFile(domain_file);
                    builder.setEmbeddedFileSystem(efsb.build());
                    server = builder.build();
                }
                EjbBuilder ejb = (EjbBuilder)server.createConfig(EjbBuilder.class);
                EmbeddedEjbContainer ejbContainer = (EmbeddedEjbContainer)server.addContainer((ContainerBuilder)ejb);
                server.addContainer(ContainerBuilder.Type.jpa);
                EmbeddedDeployer deployer = server.getDeployer();
                container = new EJBContainerImpl(server, ejbContainer, deployer);
            }
        }
    }

    private void addEJBModules(Set<File> modules, Map<?, ?> properties) {
        Object obj = properties == null ? null : properties.get("javax.ejb.embeddable.modules");
        HashSet<File> expected = new HashSet<File>();
        if (obj != null) {
            if (obj instanceof File) {
                expected.add(obj);
            } else if (obj instanceof File[]) {
                File[] arr;
                for (File f : arr = (File[])obj) {
                    expected.add(f);
                }
            }
        }
        Set<File> files = this.getFromClassPath();
        boolean fromClassPath = true;
        if (files.isEmpty()) {
            files = expected;
            fromClassPath = false;
        }
        for (File f : files) {
            if (!f.exists()) continue;
            System.err.println("Found.... " + f.getName());
            if (fromClassPath && !expected.isEmpty() && !expected.contains(f)) continue;
            modules.add(f);
            System.err.println("...Added.... ");
        }
    }

    private Set<File> getFromClassPath() {
        HashSet<File> result = new HashSet<File>();
        return result;
    }
}

