/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.util;

import com.sun.mojarra.scales.util.ScalesUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class StaticResourcePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    protected static final Map<String, String> mimeTypes;
    protected final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final List<String> attachmentTypes;
    private static String STATIC_RESOURCE_IDENTIFIER;
    private static final BitSet DONT_ENCODE_SET;
    private static final String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    private static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    private static final char[] AMP_CHARS;

    public StaticResourcePhaseListener() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void afterPhase(PhaseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforePhase(PhaseEvent e) {
        block13: {
            if (e.getPhaseId() == PhaseId.RESTORE_VIEW) {
                FacesContext context = e.getFacesContext();
                if (!(context.getExternalContext().getRequest() instanceof HttpServletRequest)) {
                    return;
                }
                HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
                HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                String uri = request.getRequestURI();
                if (this.isThisMyFile(uri)) {
                    String fileName = this.buildFileName(request);
                    Boolean isDownloadComponent = Boolean.parseBoolean(request.getParameter("appResource"));
                    if (fileName != null && !"".equals(fileName.trim())) {
                        try {
                            if (!isDownloadComponent.booleanValue()) {
                                response.setHeader("Expires", this.format.format(System.currentTimeMillis() + 1471228928L));
                                File file = new File(fileName);
                                if (!this.hasBeenModified(context, file)) {
                                    String mimeType = this.getMimeType(context, fileName);
                                    response.setContentType(mimeType);
                                    SimpleDateFormat simpleDateFormat = this.format;
                                    synchronized (simpleDateFormat) {
                                        response.setHeader("Last-Modified", this.format.format(file.lastModified()));
                                    }
                                    this.processFile(context, fileName, response, mimeType);
                                }
                                context.responseComplete();
                                break block13;
                            }
                            this.processDownloadComponent(context, fileName.substring(1), response);
                        }
                        catch (IOException ioe) {
                            try {
                                response.sendError(404, "Could not find " + fileName);
                            }
                            catch (Exception exc) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }

    protected void processDownloadComponent(FacesContext facesContext, String componentId, HttpServletResponse response) throws IOException {
        Map downloadData = (Map)facesContext.getExternalContext().getSessionMap().get("HtmlDownload-" + componentId);
        InputStream in = null;
        String fileName = null;
        String mimeType = "text/plain";
        if (downloadData != null) {
            Object value;
            fileName = (String)downloadData.get("filename");
            String extension = null;
            if (fileName != null && !"".equals(fileName)) {
                extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            }
            if ((value = downloadData.get("data")) != null) {
                String method;
                mimeType = (String)downloadData.get("mimetype");
                if (mimeType == null && extension != null) {
                    mimeType = this.getMimeType(facesContext, extension);
                }
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                if ("download".equals(method = (String)downloadData.get("method"))) {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                } else {
                    response.setHeader("Content-Disposition", "inline");
                }
                if (value instanceof byte[]) {
                    in = new ByteArrayInputStream((byte[])value);
                } else if (value instanceof ByteArrayOutputStream) {
                    in = new ByteArrayInputStream(((ByteArrayOutputStream)value).toByteArray());
                } else if (value instanceof InputStream) {
                    in = (InputStream)value;
                } else {
                    try {
                        in = new ByteArrayInputStream(value.toString().getBytes());
                    }
                    catch (Exception e) {
                        throw new FacesException("HtmlDownload:  an unsupported data type was found:  " + value.getClass().getName());
                    }
                }
            }
            ((HttpServletRequest)facesContext.getExternalContext().getRequest()).setAttribute("HtmlDownload-" + componentId, null);
        } else {
            response.setHeader("Content-type", "text/plain");
            response.setHeader("Content-Disposition", "inline");
            in = new ByteArrayInputStream("The item requested was either not found or has been previously accessed and cleared from the session.".getBytes());
        }
        this.processFile(facesContext, in, fileName, response, mimeType);
    }

    protected boolean isThisMyFile(String uri) {
        return uri != null && uri.indexOf(STATIC_RESOURCE_IDENTIFIER) > -1;
    }

    protected String buildFileName(HttpServletRequest req) {
        String fileName = req.getParameter("file");
        if (fileName == null) {
            fileName = req.getRequestURI();
            int index = fileName.indexOf(STATIC_RESOURCE_IDENTIFIER) + STATIC_RESOURCE_IDENTIFIER.length();
            fileName = fileName.substring(index);
            String mapping = ScalesUtil.getFacesMapping(FacesContext.getCurrentInstance());
            if (!ScalesUtil.isPrefixMapped(mapping)) {
                fileName = fileName.substring(0, fileName.length() - mapping.length());
            }
        }
        fileName = this.handleRelativePath((fileName.startsWith("/") ? "" : "/") + fileName);
        return fileName;
    }

    private String handleRelativePath(String path) {
        if (path.indexOf("..") > 1) {
            File file = new File(path);
            try {
                path = file.getCanonicalPath();
                if (path.indexOf(":") > -1) {
                    path = path.substring(path.indexOf(":") + 1).replaceAll("\\\\", "/");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public static String createResourceUrl(FacesContext context, String path) {
        StringBuilder sb = new StringBuilder(64);
        String mapping = ScalesUtil.getFacesMapping(context);
        if (mapping.charAt(0) == '/') {
            sb.append(mapping).append(STATIC_RESOURCE_IDENTIFIER);
        } else {
            sb.append(STATIC_RESOURCE_IDENTIFIER).append(mapping);
        }
        sb.append("?file=").append(path);
        String url = null;
        try {
            String contentType;
            String encoding;
            ResponseWriter writer = context.getResponseWriter();
            if (writer != null) {
                encoding = writer.getCharacterEncoding();
                contentType = writer.getContentType();
            } else {
                ExternalContext ec = context.getExternalContext();
                encoding = ec.getRequestCharacterEncoding();
                contentType = ec.getRequestContentType();
            }
            url = StaticResourcePhaseListener.writeURL(sb.toString(), encoding, contentType);
        }
        catch (IOException ex) {
            Logger.getLogger(StaticResourcePhaseListener.class.getName()).log(Level.SEVERE, null, ex);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(FacesContext context, InputStream inputStream, String fileName, HttpServletResponse response, String mimeType) throws IOException {
        if (inputStream != null) {
            try {
                ServletOutputStream os = response.getOutputStream();
                response.setHeader("Content-Type", mimeType);
                if (attachmentTypes.indexOf(mimeType) > -1) {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                }
                this.streamContent(inputStream, (OutputStream)os);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
        response.sendError(404, "Could not find " + fileName);
        context.responseComplete();
    }

    protected void processFile(FacesContext context, String fileName, HttpServletResponse response, String mimeType) throws IOException {
        this.processFile(context, this.getClass().getResourceAsStream(fileName), fileName, response, mimeType);
    }

    protected boolean hasBeenModified(FacesContext context, File file) throws IOException {
        HttpServletRequest req;
        long lastModified;
        Object obj = context.getExternalContext().getRequest();
        if (obj instanceof HttpServletRequest && (lastModified = (req = (HttpServletRequest)obj).getDateHeader("If-Modified-Since")) > -1L && file.lastModified() > lastModified) {
            HttpServletResponse resp = (HttpServletResponse)context.getExternalContext().getResponse();
            resp.sendError(304);
            return true;
        }
        return false;
    }

    protected void streamContent(InputStream is, OutputStream os) throws IOException {
        int count = 0;
        byte[] buffer = new byte[4096];
        while ((count = is.read(buffer)) != -1) {
            if (count <= 0) continue;
            os.write(buffer, 0, count);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    protected String getMimeType(FacesContext context, String fileName) {
        String extension;
        ServletContext sc = (ServletContext)context.getExternalContext().getContext();
        String mimeType = sc.getMimeType(extension = fileName.substring(fileName.lastIndexOf(".") + 1));
        if (mimeType == null) {
            mimeType = mimeTypes.get(extension);
        }
        return mimeType;
    }

    private static String writeURL(String text, String queryEncoding, String contentType) throws IOException {
        StringBuilder sb = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '!' || ch > '~') {
                if (ch == ' ') {
                    sb.append('+');
                    continue;
                }
                if (ch == ':') continue;
                sb.append('%');
                sb.append(StaticResourcePhaseListener.intToHex((i >> 4) % 16));
                sb.append(StaticResourcePhaseListener.intToHex(i % 16));
                continue;
            }
            if (ch == '\"') {
                sb.append("%22");
                continue;
            }
            if (ch == '?') {
                sb.append('?');
                StaticResourcePhaseListener.encodeURIString(sb, text, queryEncoding, StaticResourcePhaseListener.isXml(contentType), i + 1);
                break;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static char intToHex(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(65 + (i - 10));
    }

    private static boolean isXml(String contentType) {
        return XHTML_CONTENT_TYPE.equals(contentType) || APPLICATION_XML_CONTENT_TYPE.equals(contentType) || TEXT_XML_CONTENT_TYPE.equals(contentType);
    }

    private static boolean isAmpEscaped(String text, int idx) {
        int i = 1;
        int ix = idx;
        while (i < AMP_CHARS.length) {
            if (text.charAt(ix) != AMP_CHARS[i]) {
                return false;
            }
            ++i;
            ++ix;
        }
        return true;
    }

    private static void encodeURIString(StringBuilder out, String text, String encoding, boolean isXml, int start) throws IOException {
        StringBuilder buf = new StringBuilder();
        int length = text.length();
        for (int i = start; i < length; ++i) {
            char ch = text.charAt(i);
            if (DONT_ENCODE_SET.get(ch)) {
                if (isXml && ch == '&') {
                    if (i + 1 < length && StaticResourcePhaseListener.isAmpEscaped(text, i + 1)) {
                        out.append(ch);
                        continue;
                    }
                    out.append(AMP_CHARS);
                    continue;
                }
                out.append(ch);
                continue;
            }
            buf.append(ch);
            int size = buf.length();
            for (int j = 0; j < size; ++j) {
                out.append('%');
                out.append(StaticResourcePhaseListener.intToHex((buf.charAt(j) + 256 >> 4) % 16));
                out.append(StaticResourcePhaseListener.intToHex(buf.charAt(j) + '\u0000'));
            }
            buf = new StringBuilder();
        }
    }

    static {
        int i;
        mimeTypes = new HashMap<String, String>();
        attachmentTypes = new ArrayList<String>();
        STATIC_RESOURCE_IDENTIFIER = "/scales_static_resource";
        DONT_ENCODE_SET = new BitSet(256);
        AMP_CHARS = "&amp;".toCharArray();
        for (i = 97; i <= 122; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        DONT_ENCODE_SET.set(37);
        DONT_ENCODE_SET.set(43);
        DONT_ENCODE_SET.set(35);
        DONT_ENCODE_SET.set(38);
        DONT_ENCODE_SET.set(61);
        DONT_ENCODE_SET.set(45);
        DONT_ENCODE_SET.set(95);
        DONT_ENCODE_SET.set(46);
        DONT_ENCODE_SET.set(42);
        DONT_ENCODE_SET.set(126);
        DONT_ENCODE_SET.set(47);
        DONT_ENCODE_SET.set(39);
        DONT_ENCODE_SET.set(33);
        DONT_ENCODE_SET.set(40);
        DONT_ENCODE_SET.set(41);
        DONT_ENCODE_SET.set(59);
        DONT_ENCODE_SET.set(58);
        mimeTypes.put("abs", "audio/x-mpeg");
        mimeTypes.put("ai", "application/postscript");
        mimeTypes.put("aif", "audio/x-aiff");
        mimeTypes.put("aifc", "audio/x-aiff");
        mimeTypes.put("aiff", "audio/x-aiff");
        mimeTypes.put("aim", "application/x-aim");
        mimeTypes.put("art", "image/x-jg");
        mimeTypes.put("asf", "video/x-ms-asf");
        mimeTypes.put("asx", "video/x-ms-asf");
        mimeTypes.put("au", "audio/basic");
        mimeTypes.put("avi", "video/x-msvideo");
        mimeTypes.put("avx", "video/x-rad-screenplay");
        mimeTypes.put("bcpio", "application/x-bcpio");
        mimeTypes.put("bin", "application/octet-stream");
        mimeTypes.put("bmp", "image/bmp");
        mimeTypes.put("body", "text/html");
        mimeTypes.put("cdf", "application/x-cdf");
        mimeTypes.put("cer", "application/x-x509-ca-cert");
        mimeTypes.put("class", "application/java");
        mimeTypes.put("cpio", "application/x-cpio");
        mimeTypes.put("csh", "application/x-csh");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("dib", "image/bmp");
        mimeTypes.put("doc", "application/msword");
        mimeTypes.put("dtd", "application/xml-dtd");
        mimeTypes.put("dv", "video/x-dv");
        mimeTypes.put("dvi", "application/x-dvi");
        mimeTypes.put("eps", "application/postscript");
        mimeTypes.put("etx", "text/x-setext");
        mimeTypes.put("exe", "application/octet-stream");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("gk", "application/octet-stream");
        mimeTypes.put("gtar", "application/x-gtar");
        mimeTypes.put("gz", "application/x-gzip");
        mimeTypes.put("hdf", "application/x-hdf");
        mimeTypes.put("hqx", "application/mac-binhex40");
        mimeTypes.put("htc", "text/x-component");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("hqx", "application/mac-binhex40");
        mimeTypes.put("ief", "image/ief");
        mimeTypes.put("jad", "text/vnd.sun.j2me.app-descriptor");
        mimeTypes.put("jar", "application/java-archive");
        mimeTypes.put("java", "text/plain");
        mimeTypes.put("jnlp", "application/x-java-jnlp-file");
        mimeTypes.put("jpe", "image/jpeg");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("js", "text/javascript");
        mimeTypes.put("kar", "audio/x-midi");
        mimeTypes.put("latex", "application/x-latex");
        mimeTypes.put("m3u", "audio/x-mpegurl");
        mimeTypes.put("mac", "image/x-macpaint");
        mimeTypes.put("man", "application/x-troff-man");
        mimeTypes.put("mathml", "application/mathml+xml");
        mimeTypes.put("me", "application/x-troff-me");
        mimeTypes.put("mid", "audio/x-midi");
        mimeTypes.put("midi", "audio/x-midi");
        mimeTypes.put("mif", "application/x-mif");
        mimeTypes.put("mov", "video/quicktime");
        mimeTypes.put("movie", "video/x-sgi-movie");
        mimeTypes.put("mp1", "audio/x-mpeg");
        mimeTypes.put("mp2", "audio/x-mpeg");
        mimeTypes.put("mp3", "audio/x-mpeg");
        mimeTypes.put("mpa", "audio/x-mpeg");
        mimeTypes.put("mpe", "video/mpeg");
        mimeTypes.put("mpeg", "video/mpeg");
        mimeTypes.put("mpega", "audio/x-mpeg");
        mimeTypes.put("mpg", "video/mpeg");
        mimeTypes.put("mpv2", "video/mpeg2");
        mimeTypes.put("ms", "application/x-wais-source");
        mimeTypes.put("nc", "application/x-netcdf");
        mimeTypes.put("oda", "application/oda");
        mimeTypes.put("ogg", "application/ogg");
        mimeTypes.put("pbm", "image/x-portable-bitmap");
        mimeTypes.put("pct", "image/pict");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("pgm", "image/x-portable-graymap");
        mimeTypes.put("pic", "image/pict");
        mimeTypes.put("pict", "image/pict");
        mimeTypes.put("pls", "audio/x-scpls");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("pnm", "image/x-portable-anymap");
        mimeTypes.put("pnt", "image/x-macpaint");
        mimeTypes.put("ppm", "image/x-portable-pixmap");
        mimeTypes.put("ppt", "application/powerpoint");
        mimeTypes.put("ps", "application/postscript");
        mimeTypes.put("psd", "image/x-photoshop");
        mimeTypes.put("qt", "video/quicktime");
        mimeTypes.put("qti", "image/x-quicktime");
        mimeTypes.put("qtif", "image/x-quicktime");
        mimeTypes.put("ras", "image/x-cmu-raster");
        mimeTypes.put("rdf", "application/rdf+xml");
        mimeTypes.put("rgb", "image/x-rgb");
        mimeTypes.put("rm", "application/vnd.rn-realmedia");
        mimeTypes.put("roff", "application/x-troff");
        mimeTypes.put("rtf", "application/rtf");
        mimeTypes.put("rtx", "text/richtext");
        mimeTypes.put("sh", "application/x-sh");
        mimeTypes.put("shar", "application/x-shar");
        mimeTypes.put("sit", "application/x-stuffit");
        mimeTypes.put("smf", "audio/x-midi");
        mimeTypes.put("snd", "audio/basic");
        mimeTypes.put("src", "application/x-wais-source");
        mimeTypes.put("sv4cpio", "application/x-sv4cpio");
        mimeTypes.put("sv4crc", "application/x-sv4crc");
        mimeTypes.put("svg", "image/svg+xml");
        mimeTypes.put("svgz", "image/svg+xml");
        mimeTypes.put("swf", "application/x-shockwave-flash");
        mimeTypes.put("t", "application/x-troff");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("tcl", "application/x-tcl");
        mimeTypes.put("tex", "application/x-tex");
        mimeTypes.put("texi", "application/x-texinfo");
        mimeTypes.put("texinfo", "application/x-texinfo");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("tr", "application/x-troff");
        mimeTypes.put("tsv", "text/tab-separated-values");
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("ulw", "audio/basic");
        mimeTypes.put("ustar", "application/x-ustar");
        mimeTypes.put("xbm", "image/x-xbitmap");
        mimeTypes.put("xml", APPLICATION_XML_CONTENT_TYPE);
        mimeTypes.put("xpm", "image/x-xpixmap");
        mimeTypes.put("xsl", APPLICATION_XML_CONTENT_TYPE);
        mimeTypes.put("xslt", "application/xslt+xml");
        mimeTypes.put("xwd", "image/x-xwindowdump");
        mimeTypes.put("vsd", "application/x-visio");
        mimeTypes.put("vxml", "application/voicexml+xml");
        mimeTypes.put("wav", "audio/x-wav");
        mimeTypes.put("wbmp", "image/vnd.wap.wbmp");
        mimeTypes.put("wml", "text/vnd.wap.wml");
        mimeTypes.put("wmlc", "application/vnd.wap.wmlc");
        mimeTypes.put("wmls", "text/vnd.wap.wmls");
        mimeTypes.put("wmlscriptc", "application/vnd.wap.wmlscriptc");
        mimeTypes.put("wrl", "x-world/x-vrml");
        mimeTypes.put("xht", XHTML_CONTENT_TYPE);
        mimeTypes.put("xhtml", XHTML_CONTENT_TYPE);
        mimeTypes.put("xls", "application/vnd.ms-excel");
        mimeTypes.put("xul", "application/vnd.mozilla.xul+xml");
        mimeTypes.put("Z", "application/x-compress");
        mimeTypes.put("z", "application/x-compress");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("odp", "application/x-vnd.oasis.opendocument.presentation");
        mimeTypes.put("odt", "application/x-vnd.oasis.opendocument.text");
        mimeTypes.put("ods", "application/x-vnd.oasis.opendocument.spreadsheet");
        mimeTypes.put("odg", "application/x-vnd.oasis.opendocument.graphics");
        attachmentTypes.add("application/x-java-applet");
    }
}

