/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.WebPipeline;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;

public class PESessionLockingStandardPipeline
extends WebPipeline {
    protected static final Logger _logger = LogDomains.getLogger(PESessionLockingStandardPipeline.class, (String)"javax.enterprise.system.container.web");

    public PESessionLockingStandardPipeline(Container container) {
        super(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Session sess = this.lockSession(request);
        try {
            super.invoke(request, response);
            Object var5_4 = null;
            this.unlockSession(request);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlockSession(request);
            throw throwable;
        }
    }

    protected Session lockSession(Request request) {
        Session sess = request.getSessionInternal(false);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN LOCK_SESSION: sess =" + sess);
        }
        if (sess != null) {
            long pollTime = 200L;
            int maxNumberOfRetries = 7;
            int tryNumber = 0;
            boolean keepTrying = true;
            boolean lockResult = false;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("locking session: sess =" + sess);
            }
            StandardSession haSess = (StandardSession)sess;
            while (keepTrying) {
                lockResult = haSess.lockForeground();
                if (lockResult) {
                    keepTrying = false;
                    break;
                }
                if (++tryNumber < maxNumberOfRetries) {
                    this.threadSleep(pollTime *= 2L);
                    continue;
                }
                _logger.warning("this should not happen-breaking background lock: sess =" + sess);
                haSess.unlockBackground();
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("finished locking session: sess =" + sess);
                _logger.finest("LOCK = " + haSess.getSessionLock());
            }
        }
        return sess;
    }

    protected void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void unlockSession(Request request) {
        Session sess = request.getSessionInternal(false);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN UNLOCK_SESSION: sess = " + sess);
        }
        if (sess != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("unlocking session: sess =" + sess);
            }
            StandardSession haSess = (StandardSession)sess;
            haSess.unlockForeground();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("finished unlocking session: sess =" + sess);
                _logger.finest("LOCK = " + haSess.getSessionLock());
            }
        }
    }
}

