/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.TypeLiteral;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.api.Singleton;
import org.jboss.webbeans.bootstrap.api.SingletonProvider;

public class CurrentManager {
    private static Singleton<BeanManagerImpl> rootManager = SingletonProvider.instance().create(BeanManagerImpl.class);
    private static final Singleton<Map<Integer, BeanManagerImpl>> managers = SingletonProvider.instance().create(new IntegerMangerImplMap().getRawType());

    public static void clear() {
        managers.get().clear();
        rootManager.clear();
        managers.clear();
    }

    public static BeanManagerImpl rootManager() {
        return rootManager.get();
    }

    public static void setRootManager(BeanManagerImpl managerImpl) {
        rootManager.set(managerImpl);
        if (!managers.isSet()) {
            managers.set(new ConcurrentHashMap());
        }
        managers.get().put(managerImpl.getId(), managerImpl);
    }

    public static BeanManagerImpl get(Integer key) {
        return managers.get().get(key);
    }

    public static Integer add(BeanManagerImpl manager) {
        Integer id = manager.getId();
        managers.get().put(id, manager);
        return id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerMangerImplMap
    extends TypeLiteral<Map<Integer, BeanManagerImpl>> {
        private IntegerMangerImplMap() {
        }
    }
}

