/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.deployment.Standard;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.collections.ConcurrentCache;

public class NonContextualInjector {
    private final Bean<?> nonContextualBean;
    private final ConcurrentCache<Class<?>, Set<FieldInjectionPoint<?>>> instances = new ConcurrentCache();
    private final BeanManagerImpl manager;

    public NonContextualInjector(BeanManagerImpl manager) {
        this.manager = manager;
        this.nonContextualBean = new Bean<Object>(){

            @Override
            public Set<Annotation> getBindings() {
                return Collections.emptySet();
            }

            @Override
            public Class<? extends Annotation> getDeploymentType() {
                return Standard.class;
            }

            @Override
            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public Class<? extends Annotation> getScopeType() {
                return Dependent.class;
            }

            @Override
            public Set<Type> getTypes() {
                return Collections.emptySet();
            }

            @Override
            public boolean isNullable() {
                return false;
            }

            @Override
            public boolean isSerializable() {
                return true;
            }

            @Override
            public Object create(CreationalContext<Object> creationalContext) {
                return null;
            }

            @Override
            public void destroy(Object instance, CreationalContext<Object> context) {
            }
        };
    }

    public void inject(final Object instance) {
        if (DependentContext.instance() != null && ApplicationContext.instance() != null) {
            boolean startApplication;
            DependentContext.instance().setActive(true);
            boolean bl = startApplication = !ApplicationContext.instance().isActive();
            if (startApplication) {
                ApplicationContext.instance().setActive(true);
            }
            Set injectionPoints = (Set)this.instances.putIfAbsent(instance.getClass(), new Callable<Set<FieldInjectionPoint<?>>>(){

                @Override
                public Set<FieldInjectionPoint<?>> call() throws Exception {
                    return Beans.getFieldInjectionPoints(NonContextualInjector.this.manager.getServices().get(ClassTransformer.class).loadClass(instance.getClass()), NonContextualInjector.this.nonContextualBean);
                }
            });
            for (FieldInjectionPoint injectionPoint : injectionPoints) {
                injectionPoint.inject(instance, this.manager, null);
            }
            DependentContext.instance().setActive(false);
            if (startApplication) {
                ApplicationContext.instance().setActive(false);
            }
        }
    }
}

