/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.BindingType;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.literal.CurrentLiteral;
import org.jboss.webbeans.metadata.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationStore {
    private static final Annotation[] DEFAULT_BINDING_ARRAY = new Annotation[]{new CurrentLiteral()};
    private static final Set<Annotation> DEFAULT_BINDING = new HashSet<Annotation>(Arrays.asList(DEFAULT_BINDING_ARRAY));
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Map<Class<? extends Annotation>, Annotation> annotationMap;
    private final SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap;
    private final Set<Annotation> annotationSet;
    private final Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap;
    private final SetMultimap<Class<? extends Annotation>, Annotation> declaredMetaAnnotationMap;
    private final Set<Annotation> declaredAnnotationSet;

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Iterable<Annotation> annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    public static AnnotationStore of(AnnotatedElement annotatedElement, TypeStore typeStore) {
        return new AnnotationStore(AnnotationStore.buildAnnotationMap(annotatedElement.getAnnotations()), AnnotationStore.buildAnnotationMap(annotatedElement.getDeclaredAnnotations()), typeStore);
    }

    public static AnnotationStore of(AnnotatedElement annotatedElement, Set<Annotation> extraAnnotations, Set<Annotation> extraDeclaredAnnotations, TypeStore typeStore) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        annotationMap.putAll(AnnotationStore.buildAnnotationMap(annotatedElement.getAnnotations()));
        annotationMap.putAll(AnnotationStore.buildAnnotationMap(extraAnnotations));
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        declaredAnnotationMap.putAll(AnnotationStore.buildAnnotationMap(annotatedElement.getDeclaredAnnotations()));
        declaredAnnotationMap.putAll(AnnotationStore.buildAnnotationMap(extraDeclaredAnnotations));
        return new AnnotationStore(annotationMap, declaredAnnotationMap, typeStore);
    }

    public static AnnotationStore of(Annotation[] annotations, Annotation[] declaredAnnotations, TypeStore typeStore) {
        return new AnnotationStore(AnnotationStore.buildAnnotationMap(annotations), AnnotationStore.buildAnnotationMap(declaredAnnotations), typeStore);
    }

    public static AnnotationStore of(Set<Annotation> annotations, Set<Annotation> declaredAnnotations, TypeStore typeStore) {
        return new AnnotationStore(AnnotationStore.buildAnnotationMap(annotations), AnnotationStore.buildAnnotationMap(declaredAnnotations), typeStore);
    }

    public static AnnotationStore wrap(AnnotationStore annotationStore, Set<Annotation> annotations, Set<Annotation> declaredAnnotations, TypeStore typeStore) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        annotationMap.putAll(AnnotationStore.buildAnnotationMap(annotations));
        annotationMap.putAll(annotationStore.getAnnotationMap());
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        declaredAnnotationMap.putAll(AnnotationStore.buildAnnotationMap(declaredAnnotations));
        declaredAnnotationMap.putAll(annotationStore.getDeclaredAnnotationMap());
        return new AnnotationStore(annotationMap, declaredAnnotationMap, typeStore);
    }

    protected AnnotationStore(Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, TypeStore typeStore) {
        if (annotationMap == null) {
            throw new NullPointerException("annotationMap cannot be null");
        }
        this.annotationMap = annotationMap;
        this.annotationSet = new HashSet<Annotation>();
        this.metaAnnotationMap = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Annotation>>(){

            @Override
            public Set<Annotation> get() {
                return new HashSet<Annotation>();
            }
        });
        for (Annotation annotation : annotationMap.values()) {
            AnnotationStore.addMetaAnnotations(this.metaAnnotationMap, annotation, annotation.annotationType().getAnnotations());
            AnnotationStore.addMetaAnnotations(this.metaAnnotationMap, annotation, typeStore.get(annotation.annotationType()));
            this.annotationSet.add(annotation);
        }
        if (declaredAnnotationMap == null) {
            throw new NullPointerException("declaredAnnotationMap cannot be null");
        }
        this.declaredAnnotationMap = declaredAnnotationMap;
        this.declaredAnnotationSet = new HashSet<Annotation>();
        this.declaredMetaAnnotationMap = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Annotation>>(){

            @Override
            public Set<Annotation> get() {
                return new HashSet<Annotation>();
            }
        });
        for (Annotation declaredAnnotation : declaredAnnotationMap.values()) {
            AnnotationStore.addMetaAnnotations(this.declaredMetaAnnotationMap, declaredAnnotation, declaredAnnotation.annotationType().getAnnotations());
            AnnotationStore.addMetaAnnotations(this.declaredMetaAnnotationMap, declaredAnnotation, typeStore.get(declaredAnnotation.annotationType()));
            this.declaredAnnotationSet.add(declaredAnnotation);
        }
    }

    private static void addMetaAnnotations(SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Annotation[] metaAnnotations) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AnnotationStore.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType());
        }
    }

    private static void addMetaAnnotations(SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Iterable<Annotation> metaAnnotations) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AnnotationStore.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType());
        }
    }

    private static void addMetaAnnotation(SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Class<? extends Annotation> metaAnnotationType) {
        if (WBAnnotated.MAPPED_METAANNOTATIONS.contains(metaAnnotationType)) {
            metaAnnotationMap.put(metaAnnotationType, annotation);
        }
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotationSet);
    }

    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.metaAnnotationMap.get(metaAnnotationType));
    }

    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.declaredMetaAnnotationMap.get(metaAnnotationType));
    }

    public Annotation[] getMetaAnnotationsAsArray(Class<? extends Annotation> metaAnnotationType) {
        return this.getMetaAnnotations(metaAnnotationType).toArray(EMPTY_ANNOTATION_ARRAY);
    }

    @Deprecated
    public Set<Annotation> getBindings() {
        if (this.getMetaAnnotations(BindingType.class).size() > 0) {
            return Collections.unmodifiableSet(this.getMetaAnnotations(BindingType.class));
        }
        return Collections.unmodifiableSet(DEFAULT_BINDING);
    }

    @Deprecated
    public Annotation[] getBindingsAsArray() {
        return this.getBindings().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <A extends Annotation> A getAnnotation(Class<? extends A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.annotationMap.get(annotationType)));
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    public boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.declaredAnnotationMap.containsKey(annotationType);
    }

    Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    Map<Class<? extends Annotation>, Annotation> getDeclaredAnnotationMap() {
        return this.declaredAnnotationMap;
    }
}

