/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
public class ConnectorJavaBeanValidator {
    private static final Logger _logger = LogDomains.getLogger(ConnectorJavaBeanValidator.class, (String)"javax.enterprise.resource.resourceadapter");

    public boolean validateJavaBean(Object bean, String rarName) {
        if (bean != null) {
            Validator validator = ConnectorRegistry.getInstance().getBeanValidator(rarName);
            if (validator != null) {
                BeanDescriptor bd = validator.getConstraintsForClass(bean.getClass());
                bd.getConstraintDescriptors();
                Class[] array = new Class[]{};
                Set constraintViolations = validator.validate(bean, array);
                if (constraintViolations != null) {
                    Iterator it = constraintViolations.iterator();
                    boolean violated = false;
                    String msg = "Constraints for this bean violated. \n Message = ";
                    while (it.hasNext()) {
                        violated = true;
                        ConstraintViolation cv = (ConstraintViolation)it.next();
                        msg = msg + cv.getPropertyPath() + " " + cv.getMessage();
                    }
                    if (violated) {
                        _logger.log(Level.SEVERE, "Following validation constraints violated for bean of type [ " + bean.getClass() + " ] : " + msg);
                        throw new ValidationException(msg);
                    }
                    return false;
                }
                return true;
            }
            _logger.log(Level.FINE, "no bean validator is available for RAR [ " + rarName + " ]");
            return true;
        }
        throw new ValidationException("null Bean passed for validation");
    }
}

