/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.util.Arrays;
import java.util.List;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMethod
extends MetadataAnnotatedElement {
    protected MetadataClass metadataClass;
    protected String returnType;
    protected List<String> parameters;
    protected MetadataMethod setMethod;
    protected MetadataMethod next;

    public MetadataMethod(MetadataFactory factory, MetadataClass metadataClass, MetadataLogger logger) {
        super(factory, logger);
        this.metadataClass = metadataClass;
    }

    public MetadataMethod getSetMethod() {
        if (this.setMethod == null) {
            this.setMethod = this.getSetMethod(this.getMetadataClass());
        }
        return this.setMethod;
    }

    public void setSetMethod(MetadataMethod method) {
        this.setMethod = method;
    }

    public MetadataMethod getSetMethod(MetadataClass cls) {
        String getMethodName = this.getName();
        List<String> params = Arrays.asList(this.getReturnType());
        MetadataMethod setMethod = null;
        if (getMethodName.startsWith("get")) {
            setMethod = cls.getMethod("set" + getMethodName.substring(3), params);
        } else {
            setMethod = cls.getMethod("set" + getMethodName.substring(2), params);
            if (setMethod == null) {
                setMethod = cls.getMethod("setIs" + getMethodName.substring(2), params);
            }
        }
        return setMethod;
    }

    public String getSetMethodName() {
        return this.getSetMethod().getName();
    }

    public boolean hasAttributeName() {
        return !this.getAttributeName().equals("");
    }

    public boolean hasParameters() {
        return this.getParameters().size() > 0;
    }

    public boolean hasSetMethod() {
        return this.getSetMethod() != null;
    }

    protected boolean isALifeCycleCallbackMethod() {
        return this.isAnnotationPresent(PostLoad.class) || this.isAnnotationPresent(PostPersist.class) || this.isAnnotationPresent(PostRemove.class) || this.isAnnotationPresent(PostUpdate.class) || this.isAnnotationPresent(PrePersist.class) || this.isAnnotationPresent(PreRemove.class) || this.isAnnotationPresent(PreUpdate.class);
    }

    protected boolean isValidPersistenceMethod() {
        return this.isValidPersistenceMethodName() && !this.hasParameters() && this.hasSetMethod();
    }

    public boolean isValidPersistenceMethod(boolean mustBeExplicit, MetadataDescriptor descriptor) {
        if (this.isValidPersistenceElement(mustBeExplicit, "PROPERTY", descriptor)) {
            return !this.isALifeCycleCallbackMethod() && this.isValidPersistenceMethod(descriptor, this.hasDeclaredAnnotations(descriptor));
        }
        return false;
    }

    public boolean isValidPersistenceMethod(MetadataDescriptor descriptor, boolean userDecorated) {
        if (!this.isValidPersistenceElement(this.getModifiers()) || !this.isValidPersistenceMethod()) {
            if (userDecorated) {
                if (this.hasParameters()) {
                    throw ValidationException.mappingMetadataAppliedToMethodWithArguments((Object)this, (Object)descriptor.getJavaClass());
                }
                if (!this.hasSetMethod()) {
                    throw ValidationException.noCorrespondingSetterMethodDefined((Object)descriptor.getJavaClass(), (Object)this);
                }
                throw ValidationException.mappingMetadataAppliedToInvalidAttribute((Object)this, (Object)descriptor.getJavaClass());
            }
            return false;
        }
        return true;
    }

    public boolean isValidPersistenceMethodName() {
        return (this.getName().startsWith("get") || this.getName().startsWith("is")) && this.hasAttributeName();
    }

    public MetadataMethod getNext() {
        return this.next;
    }

    public void setNext(MetadataMethod next) {
        this.next = next;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
        this.setType(returnType);
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public MetadataClass getMetadataClass() {
        return this.metadataClass;
    }

    public void setMetadataClass(MetadataClass metadataClass) {
        this.metadataClass = metadataClass;
    }
}

