/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.QueryBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.TupleQuery;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryImpl<T>
extends AbstractQueryImpl<T>
implements CriteriaQuery<T> {
    protected SelectionImpl<?> selection;
    protected Class<?> queryType;
    protected boolean distinct;

    public CriteriaQueryImpl(Metamodel metamodel, AbstractQueryImpl.ResultType queryResult, Class result, QueryBuilderImpl queryBuilder) {
        super(metamodel, queryResult, queryBuilder);
        this.queryType = result;
    }

    public CriteriaQuery<T> select(Selection<? extends T> selection) {
        this.selection = (SelectionImpl)selection;
        if (selection.isCompoundSelection()) {
            if (!(selection.getJavaType().equals(Tuple.class) || this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE) || this.queryResult.equals((Object)AbstractQueryImpl.ResultType.OBJECT_ARRAY))) {
                int size = selection.getCompoundSelectionItems().size();
                if (!this.discoverResultType(selection.getCompoundSelectionItems().toArray(new Selection[selection.getCompoundSelectionItems().size()]))) {
                    Object[] params = new Object[size + 1];
                    params[0] = this.queryType;
                    int count = 0;
                    for (Selection select : selection.getCompoundSelectionItems()) {
                        params[++count] = select.getJavaType();
                    }
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"CRITERIA_NO_CONSTRUCTOR_FOUND_TODO", (Object[])params));
                }
            }
        } else {
            this.queryType = selection.getJavaType();
            ManagedType type = this.metamodel.type(this.queryType);
            this.queryResult = type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY) ? AbstractQueryImpl.ResultType.ENTITY : AbstractQueryImpl.ResultType.OTHER;
        }
        this.integrateRoot(selection);
        return this;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... selections) {
        if (selections == null || selections.length == 0) {
            this.selection = null;
        }
        if (this.queryType.equals(ClassConstants.OBJECT)) {
            if (selections.length > 1) {
                this.queryType = ClassConstants.AOBJECT;
                this.selection = (SelectionImpl)this.queryBuilder.construct(ClassConstants.AOBJECT, selections);
                this.queryResult = AbstractQueryImpl.ResultType.OBJECT_ARRAY;
            } else {
                ManagedType type = this.metamodel.type(selections[0].getJavaType());
                this.queryResult = type == null || !type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY) ? AbstractQueryImpl.ResultType.OTHER : AbstractQueryImpl.ResultType.ENTITY;
                this.queryType = selections[0].getJavaType();
                this.selection = (SelectionImpl)selections[0];
            }
            return this;
        }
        if (selections.length > 1 || !this.queryType.isAssignableFrom(selections[0].getJavaType())) {
            if ((this.queryResult.equals((Object)AbstractQueryImpl.ResultType.OTHER) || this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY)) && !this.discoverResultType(selections)) {
                Object[] params = new Object[selections.length];
                params[0] = this.queryType;
                int count = 0;
                for (Selection<?> select : this.selection.getCompoundSelectionItems()) {
                    params[++count] = select.getJavaType();
                }
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"CRITERIA_NO_CONSTRUCTOR_FOUND_TODO", (Object[])params));
            }
            this.selection = (SelectionImpl)this.queryBuilder.construct(this.queryType, selections);
        } else {
            this.selection = (SelectionImpl)selections[0];
        }
        return this;
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        if (selectionList == null) {
            this.selection = null;
            return this;
        }
        return this.multiselect(selectionList.toArray(new Selection[selectionList.size()]));
    }

    @Override
    public CriteriaQuery<T> where(Expression<Boolean> restriction) {
        return (CriteriaQuery)super.where(restriction);
    }

    @Override
    public CriteriaQuery<T> where(Predicate ... restrictions) {
        return (CriteriaQuery)super.where(restrictions);
    }

    @Override
    public CriteriaQuery<T> groupBy(Expression<?> ... grouping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CriteriaQuery<T> having(Expression<Boolean> restriction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CriteriaQuery<T> having(Predicate ... restrictions) {
        throw new UnsupportedOperationException();
    }

    protected void initialRoot(RootImpl root, EntityType entity) {
        if (this.roots.isEmpty() && (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY) || this.queryType.equals(ClassConstants.Object_Class))) {
            this.selection = root;
            this.queryResult = AbstractQueryImpl.ResultType.ENTITY;
            this.queryType = entity.getJavaType();
        }
    }

    public CriteriaQuery<T> orderBy(Order ... o) {
        throw new UnsupportedOperationException();
    }

    public boolean discoverResultType(Selection<?> ... selections) {
        Class[] constructorArgs = new Class[selections.length];
        int count = 0;
        for (Selection<?> select : this.selection.getCompoundSelectionItems()) {
            constructorArgs[++count] = select.getJavaType();
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.queryType, constructorArgs, false));
                this.queryResult = AbstractQueryImpl.ResultType.CONSTRUCTOR;
                return true;
            }
            PrivilegedAccessHelper.getConstructorFor(this.queryType, (Class[])constructorArgs, (boolean)false);
            this.queryResult = AbstractQueryImpl.ResultType.CONSTRUCTOR;
            return true;
        }
        catch (PrivilegedActionException ex) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY)) {
            this.queryResult = AbstractQueryImpl.ResultType.PARTIAL;
            return true;
        }
        return false;
    }

    @Override
    public CriteriaQuery<T> distinct(boolean distinct) {
        super.distinct(distinct);
        return this;
    }

    @Override
    public <X> Root<X> from(EntityType<X> entity) {
        RootImpl root = new RootImpl((ManagedType)entity, this.metamodel, entity.getBindableJavaType(), (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder(entity.getBindableJavaType()), (Bindable)entity);
        this.roots.add(root);
        this.initialRoot(root, entity);
        return root;
    }

    @Override
    public <X> Root<X> from(Class<X> entityClass) {
        EntityType entity = this.metamodel.entity(entityClass);
        return this.from(entity);
    }

    public List<Order> getOrderList() {
        throw new UnsupportedOperationException();
    }

    public Set<ParameterExpression<?>> getParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Selection<T> getSelection() {
        return this.selection;
    }

    public Class<?> getResultType() {
        return this.queryType;
    }

    public DatabaseQuery translate() {
        ReadAllQuery query = null;
        if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY)) {
            query = new ReadAllQuery(this.queryType);
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.PARTIAL)) {
            ReadAllQuery raq = new ReadAllQuery(this.queryType);
            for (Selection<?> selection : this.selection.getCompoundSelectionItems()) {
                raq.addPartialAttribute(((SelectionImpl)selection).currentNode);
            }
            query = raq;
        } else {
            if (this.roots == null || this.roots.isEmpty()) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"CRITERIA_NO_ROOT_FOR_COMPOUND_QUERY"));
            }
            ReportQuery reportQuery = new ReportQuery();
            if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.CONSTRUCTOR)) {
                reportQuery.addConstructorReportItem(((ConstructorSelectionImpl)this.selection).translate());
                reportQuery.setShouldReturnSingleAttribute(true);
            } else {
                if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE)) {
                    reportQuery = new TupleQuery(this.selection == null ? new ArrayList() : this.selection.getCompoundSelectionItems());
                } else {
                    reportQuery = new ReportQuery();
                    reportQuery.setShouldReturnWithoutReportQueryResult(true);
                }
                if (this.selection != null) {
                    if (this.selection.isCompoundSelection()) {
                        for (Selection<?> nested : this.selection.getCompoundSelectionItems()) {
                            if (((SelectionImpl)nested).isCompoundSelection()) {
                                reportQuery.addConstructorReportItem(((ConstructorSelectionImpl)nested).translate());
                                continue;
                            }
                            reportQuery.addItem(nested.getAlias(), ((SelectionImpl)nested).getCurrentNode());
                        }
                    } else {
                        reportQuery.addItem(this.selection.getAlias(), this.selection.getCurrentNode());
                    }
                }
            }
            if (this.where != null && ((ExpressionImpl)this.where).getCurrentNode() != null) {
                reportQuery.setReferenceClass(((ExpressionImpl)this.where).getCurrentNode().getBuilder().getQueryClass());
            } else {
                reportQuery.setReferenceClass(this.getRoots().iterator().next().getJavaType());
            }
            query = reportQuery;
        }
        if (this.where != null) {
            query.setSelectionCriteria(((ExpressionImpl)this.where).getCurrentNode());
        }
        if (this.distinct) {
            query.setDistinctState((short)1);
        } else {
            query.setDistinctState((short)2);
        }
        return query;
    }
}

