/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ConnectorsClassLoaderUtil {
    @Inject
    private ClassLoaderHierarchy clh;
    private Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");

    public ConnectorClassFinder createRARClassLoader(String moduleDir, ClassLoader deploymentParent) throws ConnectorRuntimeException {
        ClassLoader parent = null;
        parent = deploymentParent == null ? this.clh.getConnectorClassLoader(null).getParent() : deploymentParent;
        return this.createRARClassLoader(parent, moduleDir);
    }

    private ConnectorClassFinder createRARClassLoader(final ClassLoader parent, String moduleDir) throws ConnectorRuntimeException {
        ConnectorClassFinder cl = null;
        try {
            cl = (ConnectorClassFinder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new ConnectorClassFinder(parent);
                }
            });
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "failed to create connector classloader", ex);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ex.getMessage());
            cre.initCause(ex);
            throw cre;
        }
        File file = new File(moduleDir);
        try {
            cl.appendURL(file.toURI().toURL());
            this.appendJars(file, (EJBClassLoader)cl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return cl;
    }

    private void appendJars(File moduleDir, EJBClassLoader cl) throws MalformedURLException {
        if (moduleDir.isDirectory()) {
            for (File file : moduleDir.listFiles()) {
                if (file.getName().toUpperCase().endsWith(".JAR")) {
                    cl.appendURL(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.appendJars(file, cl);
            }
        }
    }
}

