/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.monitor;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.scripting.jruby.monitor.RubyApplicationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="JRuby Container Statistics")
public class JRubyProbeStatsProvider {
    private final CountStatisticImpl activeRubyAppsCount = new CountStatisticImpl("ActiveRubyApplications", "count", "Number of currently loaded Ruby applications");
    private final ConcurrentHashMap<String, RubyApplicationData> apps = new ConcurrentHashMap();
    private final Logger logger = Logger.getLogger(JRubyProbeStatsProvider.class.getName());

    public JRubyProbeStatsProvider() {
        this.logger.fine("JRubyProbeStatsProvider() created");
    }

    @ProbeListener(value="glassfish:jruby:jruby-container:jrubyModuleStartedEvent")
    public void jrubyModuleStartedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="applicationType") String applicationType, @ProbeParam(value="environment") String environment, @ProbeParam(value="jrubyVersion") String jrubyVersion) {
        if (appName == null) {
            this.logger.warning("appName is null in jrubyModuleStartedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        this.logger.fine("JRubyProbeStatsProvider:jrubyModuleStartedEvent invoked");
        this.activeRubyAppsCount.increment();
        this.apps.put(appName, new RubyApplicationData(appName, applicationType, environment, jrubyVersion));
    }

    @ProbeListener(value="glassfish:jruby:jruby-container:jrubyModuleStoppedEvent")
    public void jrubyModuleStoppedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="applicationType") String applicationType, @ProbeParam(value="environment") String environment) {
        if (appName == null) {
            this.logger.warning("appName is null in jrubyModuleStoppedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        this.logger.fine("JRubyProbeStatsProvider:jrubyModuleStoppedEvent invoked");
        this.activeRubyAppsCount.decrement();
        this.apps.remove(appName);
    }

    @ManagedAttribute(id="activerubyappscount")
    @Description(value="Number of active Ruby applications")
    public CountStatistic getActiveRubyAppsCount() {
        return this.activeRubyAppsCount;
    }

    @ManagedAttribute(id="activerubyapplications")
    @Description(value="Active Ruby applications deployed on GlassFish")
    public Collection<RubyApplicationData> getActiveRubyApplications() {
        return Collections.unmodifiableCollection(this.apps.values());
    }

    RubyApplicationData getApplication(String appName) {
        return this.apps.get(appName);
    }
}

