/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.algorithms;

import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.StreamAlgorithm;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamAlgorithmBase
implements StreamAlgorithm<SocketChannel> {
    private int port = 8080;
    protected int contentLength = -1;
    protected int curLimit = -1;
    protected int curPosition = -1;
    protected int headerLength = -1;
    protected int lastStatePosition = -1;
    protected int state = 0;
    protected ByteBuffer primaryByteBuffer = null;
    protected boolean useByteBufferView = false;
    protected boolean useDirectByteBuffer;
    protected SocketChannel socketChannel;
    protected Interceptor handler = new DummyHandler();

    public abstract boolean parse(ByteBuffer var1);

    public int contentLength() {
        return this.contentLength;
    }

    public int headerLength() {
        return this.headerLength;
    }

    public ByteBuffer preParse(ByteBuffer byteBuffer) {
        if (byteBuffer.position() == byteBuffer.capacity()) {
            int bufferSize = this.contentLength > 0 ? this.contentLength + this.headerLength + 5 : byteBuffer.capacity() * 2;
            byteBuffer = this.swapBuffer(byteBuffer, bufferSize);
        }
        return byteBuffer;
    }

    public ByteBuffer postParse(ByteBuffer byteBuffer) {
        if (this.primaryByteBuffer != null) {
            this.primaryByteBuffer.clear();
            byteBuffer = this.primaryByteBuffer;
            this.primaryByteBuffer = null;
        }
        return byteBuffer;
    }

    public void recycle() {
        this.contentLength = -1;
        this.lastStatePosition = -1;
        this.headerLength = -1;
        this.curLimit = -1;
        this.curPosition = -1;
        this.state = 0;
    }

    public ByteBuffer allocate(boolean useDirectByteBuffer, boolean useByteBufferView, int size) {
        ByteBuffer byteBuffer = useByteBufferView ? ByteBufferFactory.allocateView((int)size, (boolean)useDirectByteBuffer) : (useDirectByteBuffer ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size));
        return byteBuffer;
    }

    private ByteBuffer swapBuffer(ByteBuffer byteBuffer, int size) {
        ByteBuffer tmp = this.allocate(this.useDirectByteBuffer, this.useByteBufferView, size);
        byteBuffer.flip();
        tmp.put(byteBuffer);
        if (this.primaryByteBuffer == null) {
            this.primaryByteBuffer = byteBuffer;
        }
        byteBuffer = tmp;
        return byteBuffer;
    }

    public ByteBuffer rollbackParseState(ByteBuffer byteBuffer) {
        if (this.curLimit != -1 && this.curPosition != -1) {
            byteBuffer.limit(this.curLimit);
            byteBuffer.position(this.curPosition);
            this.contentLength = -1;
            this.headerLength = -1;
        }
        return byteBuffer;
    }

    protected String dump(ByteBuffer byteBuffer) {
        ByteBuffer dd = byteBuffer.duplicate();
        dd.flip();
        int length = dd.limit();
        byte[] dump = new byte[length];
        dd.get(dump, 0, length);
        return new String(dump) + "\n----------------------------" + dd + "\ncontentLength: " + this.contentLength + "\nheaderLength: " + this.headerLength;
    }

    public void setChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        if (socketChannel != null) {
            this.handler.attachChannel((Channel)socketChannel);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyHandler
    implements Interceptor<Object, SocketChannel> {
        public int handle(Object e, int handlerCode) throws IOException {
            return 0;
        }

        public void attachChannel(SocketChannel sc) {
        }
    }
}

