/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashSet;

public final class RunScriptLocalCommand
extends RemoteCommand {
    public static final String TERSE = "terse";
    public static final String HTTP_PORT = "httpport";
    public static final String UPLOAD = "upload";
    private boolean upload = true;
    private int httpPort = 8080;
    private String scriptName;

    public RunScriptLocalCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        RunScriptLocalCommand.addOption(opts, TERSE, '\u0000', "BOOLEAN", false, "true");
        RunScriptLocalCommand.addOption(opts, UPLOAD, '\u0000', "BOOLEAN", false, "true");
        RunScriptLocalCommand.addOption(opts, HTTP_PORT, '\u0000', "STRING", false, "8080");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "script";
        this.operandType = "FILE";
        this.operandMin = 1;
        this.operandMax = 1;
        if (!this.isValidCommand()) {
            throw new CommandException("Command " + this.name + " is not supported");
        }
        try {
            this.processProgramOptions();
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        String shttpPort = this.getOption(HTTP_PORT);
        if (RunScriptLocalCommand.ok(shttpPort)) {
            this.httpPort = Integer.parseInt(shttpPort);
        }
        this.upload = Boolean.getBoolean(this.getOption(UPLOAD));
        String scriptPath = (String)this.operands.get(0);
        int i = scriptPath.lastIndexOf(File.separator);
        this.scriptName = scriptPath.substring(i + 1, scriptPath.length());
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        Object in = null;
        boolean isContinue = true;
        CLILogger.getInstance().printDebugMessage("In the run-script command");
        try {
            int c;
            super.executeCommand();
            String urlStr = "http://" + this.programOpts.getHost() + ":" + this.httpPort + "/comet/cometServlet";
            CLILogger.getInstance().printDebugMessage("URL = " + urlStr);
            URL url1 = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url1.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            String data = URLEncoder.encode("script", "UTF-8") + "=" + URLEncoder.encode(this.scriptName, "UTF-8");
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            wr.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((c = rd.read()) >= 0) {
                System.out.print((char)c);
            }
            return 0;
        }
        catch (Exception e) {
            this.printRemoteException(e);
            return 1;
        }
    }

    private boolean isValidCommand() {
        try {
            String line;
            String cmds;
            try {
                RemoteCommand cmd = new RemoteCommand("list-commands", this.programOpts, this.env);
                cmds = cmd.executeAndReturnOutput("list-commands");
            }
            catch (CommandException ce) {
                return false;
            }
            BufferedReader r = new BufferedReader(new StringReader(cmds));
            while ((line = r.readLine()) != null) {
                if (!line.contains("run-script")) continue;
                return true;
            }
            return false;
        }
        catch (CommandValidationException ex) {
            return false;
        }
        catch (IOException ioex) {
            return false;
        }
    }

    private void printRemoteException(Exception e) {
        CLILogger.getInstance().printMessage("Command " + this.name + " is not supported");
        CLILogger.getInstance().printDebugMessage(e.getMessage());
        CLILogger.getInstance().printExceptionStackTrace(e);
    }
}

