/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public class ReadObjectQuery
extends ObjectLevelReadQuery {
    protected transient Object selectionObject;
    protected Vector selectionKey;
    protected boolean shouldLoadResultIntoSelectionObject = false;

    public ReadObjectQuery() {
    }

    public ReadObjectQuery(Class classToRead) {
        this();
        this.referenceClass = classToRead;
    }

    public ReadObjectQuery(Class classToRead, Expression selectionCriteria) {
        this();
        this.referenceClass = classToRead;
        this.setSelectionCriteria(selectionCriteria);
    }

    public ReadObjectQuery(Class classToRead, ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
        this.referenceClass = classToRead;
    }

    public ReadObjectQuery(Class classToRead, Call call) {
        this();
        this.referenceClass = classToRead;
        this.setCall(call);
    }

    public ReadObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public ReadObjectQuery(Object objectToRead) {
        this();
        this.setSelectionObject(objectToRead);
    }

    public ReadObjectQuery(Object exampleObject, QueryByExamplePolicy policy) {
        this();
        this.setExampleObject(exampleObject);
        this.setQueryByExamplePolicy(policy);
    }

    public ReadObjectQuery(ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
    }

    public void cacheResult(Object unwrappedOriginal) {
        Object cachableObject = unwrappedOriginal;
        if (this.shouldUseWrapperPolicy()) {
            cachableObject = this.getSession().wrapObject(unwrappedOriginal);
        }
        this.setTemporaryCachedQueryResults(cachableObject);
    }

    public void checkCacheByExactPrimaryKey() {
        this.setCacheUsage(1);
    }

    public void checkCacheByPrimaryKey() {
        this.setCacheUsage(2);
    }

    public void checkCacheThenDatabase() {
        this.setCacheUsage(3);
    }

    public void checkDescriptor(AbstractSession session) throws QueryException {
        if (this.descriptor == null) {
            if (this.getReferenceClass() == null) {
                throw QueryException.referenceClassMissing(this);
            }
            ClassDescriptor referenceDescriptor = this.getSelectionObject() != null && session.getProject().hasProxyIndirection() ? session.getDescriptor(this.getSelectionObject()) : session.getDescriptor(this.getReferenceClass());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
    }

    protected Object checkEarlyReturnImpl(AbstractSession session, AbstractRecord translationRow) {
        if (!(!this.shouldCheckCache() || !this.shouldMaintainCache() || this.shouldRefreshIdentityMapResult() || session.isRemoteSession() && (this.shouldRefreshRemoteIdentityMapResult() || this.descriptor.shouldDisableCacheHitsOnRemote()) || this.shouldCheckDescriptorForCacheUsage() && this.descriptor.shouldDisableCacheHits() || this.descriptor.isDescriptorForInterface())) {
            Object cachedObject = this.getQueryMechanism().checkCacheForObject(translationRow, session);
            if (cachedObject == InvalidObject.instance) {
                return cachedObject;
            }
            if (cachedObject != null) {
                if (this.shouldLoadResultIntoSelectionObject()) {
                    ObjectBuilder builder = this.descriptor.getObjectBuilder();
                    builder.copyInto(cachedObject, this.getSelectionObject());
                    session.getIdentityMapAccessorInstance().putInIdentityMap(this.getSelectionObject());
                    cachedObject = this.getSelectionObject();
                }
                if (this.isLockQuery() && session.isUnitOfWork() && !((UnitOfWorkImpl)session).isPessimisticLocked(cachedObject)) {
                    if (QueryMonitor.shouldMonitor()) {
                        QueryMonitor.incrementReadObjectMisses(this);
                    }
                    return null;
                }
                if (QueryMonitor.shouldMonitor()) {
                    QueryMonitor.incrementReadObjectHits(this);
                }
            } else if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementReadObjectMisses(this);
            }
            if (this.shouldUseWrapperPolicy()) {
                cachedObject = this.descriptor.getObjectBuilder().wrapObject(cachedObject, session);
            }
            return cachedObject;
        }
        if (QueryMonitor.shouldMonitor()) {
            QueryMonitor.incrementReadObjectMisses(this);
        }
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        if (this.isCustomQueryUsed() == null) {
            DescriptorQueryManager descriptorQueryManager;
            if (!(this.isUserDefined() || this.isCallQuery() || !(descriptorQueryManager = this.descriptor.getQueryManager()).hasReadObjectQuery() || this.hasJoining() && this.getJoinedAttributeManager().hasJoinedAttributeExpressions() || this.hasPartialAttributeExpressions() || this.hasAsOfClause() || this.hasNonDefaultFetchGroup() || this.getHintString() != null || !this.wasDefaultLockMode() || !this.shouldIgnoreBindAllParameters() || this.hasFetchGroup() || this.getFetchGroupName() != null || !this.shouldUseDefaultFetchGroup())) {
                AbstractRecord primaryKeyRow;
                if (this.getSelectionKey() != null || this.getSelectionObject() != null) {
                    this.setIsCustomQueryUsed(true);
                } else if (this.getSelectionCriteria() != null && (primaryKeyRow = this.descriptor.getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), translationRow, session)) != null) {
                    this.setIsCustomQueryUsed(true);
                }
            }
            if (this.isCustomQueryUsed() == null) {
                this.setIsCustomQueryUsed(false);
            }
        }
        if (this.isCustomQueryUsed().booleanValue()) {
            return this.descriptor.getQueryManager().getReadObjectQuery();
        }
        return null;
    }

    protected Object conformResult(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord databaseRow, boolean buildDirectlyFromRows) {
        Object clone;
        Object implementation = null;
        implementation = buildDirectlyFromRows ? result : this.descriptor.getObjectBuilder().unwrapObject(result, unitOfWork.getParent());
        if (this.getSelectionCriteria() != null && this.getSelectionKey() == null && this.getSelectionObject() == null) {
            ExpressionBuilder builder = this.getSelectionCriteria().getBuilder();
            builder.setSession(unitOfWork.getRootSession(null));
            builder.setQueryClass(this.getReferenceClass());
        }
        if ((clone = this.conformIndividualResult(implementation, unitOfWork, databaseRow, this.getSelectionCriteria(), null, buildDirectlyFromRows)) == null) {
            return clone;
        }
        if (this.shouldUseWrapperPolicy()) {
            return this.descriptor.getObjectBuilder().wrapObject(clone, unitOfWork);
        }
        return clone;
    }

    public void dontLoadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(false);
    }

    public Object execute(AbstractSession session, AbstractRecord row) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            if (this.shouldConformResultsInUnitOfWork()) {
                throw QueryException.cannotConformAndCacheQueryResults(this);
            }
            if (this.isPrepared()) {
                Object result = this.getQueryResults(session, row, true);
                if (result == InvalidObject.instance) {
                    return null;
                }
                if (result != null) {
                    if (session.isUnitOfWork()) {
                        result = ((UnitOfWorkImpl)session).registerExistingObject(result);
                    }
                    return result;
                }
            }
        }
        return super.execute(session, row);
    }

    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        if (this.descriptor.isDescriptorForInterface() || this.descriptor.hasTablePerClassPolicy()) {
            Object returnValue = this.descriptor.getInterfacePolicy().selectOneObjectUsingMultipleTableSubclassRead(this);
            if (!this.descriptor.hasTablePerClassPolicy() || returnValue != null) {
                this.setExecutionTime(System.currentTimeMillis());
                return returnValue;
            }
        }
        AbstractRecord row = null;
        AbstractSession session = this.getSession();
        if (this.hasJoining() && this.getJoinedAttributeManager().isToManyJoin()) {
            Vector rows = this.getQueryMechanism().selectAllRows();
            if (rows.size() > 0) {
                row = (AbstractRecord)rows.get(0);
            }
            this.getJoinedAttributeManager().setDataResults(rows, session);
        } else {
            row = this.getQueryMechanism().selectOneRow();
        }
        this.setExecutionTime(System.currentTimeMillis());
        Object result = null;
        if (session.isUnitOfWork()) {
            result = this.registerResultInUnitOfWork(row, (UnitOfWorkImpl)session, this.getTranslationRow(), true);
        } else if (row != null) {
            result = this.buildObject(row);
        }
        if (result == null && this.shouldRefreshIdentityMapResult()) {
            if (this.getSelectionKey() != null) {
                session.getParentIdentityMapSession(this, true, true).getIdentityMapAccessor().invalidateObject(this.getSelectionKey(), this.getReferenceClass());
            } else if (this.getSelectionObject() != null) {
                session.getParentIdentityMapSession(this, true, true).getIdentityMapAccessor().invalidateObject(this.getSelectionObject());
            }
        }
        if (this.shouldIncludeData()) {
            ComplexQueryResult complexResult = new ComplexQueryResult();
            complexResult.setResult(result);
            complexResult.setData(row);
            return complexResult;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object executeObjectLevelReadQueryFromResultSet() throws DatabaseException {
        Object object;
        boolean exceptionOccured;
        ResultSet resultSet;
        PreparedStatement statement;
        DatabaseCall call;
        DatabaseAccessor accessor;
        UnitOfWorkImpl unitOfWork;
        block13: {
            Object var9_9;
            block12: {
                unitOfWork = (UnitOfWorkImpl)this.getSession();
                accessor = (DatabaseAccessor)unitOfWork.getAccessor();
                DatabasePlatform platform = accessor.getPlatform();
                call = (DatabaseCall)this.getCall().clone();
                call.setQuery(this);
                AbstractRecord translationRow = this.getTranslationRow();
                call.translate(this.getTranslationRow(), null, unitOfWork);
                statement = null;
                resultSet = null;
                exceptionOccured = false;
                try {
                    try {
                        accessor.incrementCallCount(unitOfWork);
                        statement = (PreparedStatement)call.prepareStatement(accessor, translationRow, unitOfWork);
                        resultSet = statement.executeQuery();
                        if (!resultSet.next()) {
                            var9_9 = null;
                            Object var12_12 = null;
                            break block12;
                        }
                        ResultSetMetaData metaData = resultSet.getMetaData();
                        object = this.descriptor.getObjectBuilder().buildWorkingCopyCloneFromResultSet(this, null, resultSet, unitOfWork, accessor, metaData, platform);
                        break block13;
                    }
                    catch (SQLException exception) {
                        exceptionOccured = true;
                        DatabaseException commException = accessor.processExceptionForCommError(this.session, exception, call);
                        if (commException == null) throw DatabaseException.sqlException(exception, call, accessor, unitOfWork, false);
                        throw commException;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement == null) throw throwable;
                        accessor.releaseStatement(statement, call.getSQLString(), call, unitOfWork);
                        throw throwable;
                    }
                    catch (SQLException exception2) {
                        if (exceptionOccured) throw throwable;
                        DatabaseException commException = accessor.processExceptionForCommError(this.session, exception2, call);
                        if (commException == null) throw DatabaseException.sqlException(exception2, call, accessor, this.session, false);
                        throw commException;
                    }
                }
            }
            try {}
            catch (SQLException exception2) {
                if (exceptionOccured) return var9_9;
                DatabaseException commException = accessor.processExceptionForCommError(this.session, exception2, call);
                if (commException == null) throw DatabaseException.sqlException(exception2, call, accessor, this.session, false);
                throw commException;
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement == null) return var9_9;
            accessor.releaseStatement(statement, call.getSQLString(), call, unitOfWork);
            return var9_9;
        }
        Object var12_13 = null;
        try {}
        catch (SQLException exception2) {
            if (exceptionOccured) return object;
            DatabaseException commException = accessor.processExceptionForCommError(this.session, exception2, call);
            if (commException == null) throw DatabaseException.sqlException(exception2, call, accessor, this.session, false);
            throw commException;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement == null) return object;
        accessor.releaseStatement(statement, call.getSQLString(), call, unitOfWork);
        return object;
    }

    public Object extractRemoteResult(Transporter transporter) {
        return ((RemoteSession)this.getSession()).getObjectCorrespondingTo(transporter.getObject(), transporter.getObjectDescriptors(), new IdentityHashMap(), this);
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultReadObjectQueryRedirector();
    }

    public Vector getSelectionKey() {
        return this.selectionKey;
    }

    public Object getSelectionObject() {
        return this.selectionObject;
    }

    public boolean isReadObjectQuery() {
        return true;
    }

    public boolean isPrimaryKeyQuery() {
        return this.selectionKey != null || this.selectionObject != null;
    }

    public void loadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(true);
    }

    public void copyFromQuery(DatabaseQuery query) {
        super.copyFromQuery(query);
        if (query.isReadObjectQuery()) {
            ReadObjectQuery readQuery = (ReadObjectQuery)query;
            this.selectionKey = readQuery.selectionKey;
            this.selectionObject = readQuery.selectionObject;
            this.shouldLoadResultIntoSelectionObject = readQuery.shouldLoadResultIntoSelectionObject;
        }
    }

    protected void prepare() throws QueryException {
        if (this.prepareFromCachedQuery()) {
            return;
        }
        super.prepare();
        if (this.getSelectionKey() != null || this.getSelectionObject() != null) {
            this.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
            if (!this.shouldPrepare()) {
                if (this.getSelectionKey() != null) {
                    this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowFromPrimaryKeyValues(this.getSelectionKey(), this.getSession()));
                } else {
                    this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getSelectionObject(), this.getSession()));
                }
            }
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            return;
        }
        if (this.hasJoining() && this.getJoinedAttributeManager().isToManyJoin()) {
            this.getQueryMechanism().prepareSelectAllRows();
        } else {
            this.getQueryMechanism().prepareSelectOneRow();
        }
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        ReadObjectQuery customReadQuery = (ReadObjectQuery)customQuery;
        customReadQuery.setShouldRefreshIdentityMapResult(this.shouldRefreshIdentityMapResult());
        customReadQuery.setCascadePolicy(this.getCascadePolicy());
        customReadQuery.setShouldMaintainCache(this.shouldMaintainCache());
        customReadQuery.setShouldUseWrapperPolicy(this.shouldUseWrapperPolicy());
        customReadQuery.setQueryId(this.getQueryId());
        customReadQuery.setExecutionTime(this.getExecutionTime());
        customReadQuery.setShouldLoadResultIntoSelectionObject(this.shouldLoadResultIntoSelectionObject());
        if (this.getSelectionObject() != null) {
            customReadQuery.setSelectionObject(this.getSelectionObject());
        } else if (this.getSelectionKey() != null) {
            customReadQuery.setSelectionKey(this.getSelectionKey());
        } else {
            AbstractRecord primaryKeyRow = customQuery.getDescriptor().getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), customQuery.getTranslationRow(), customReadQuery.getSession());
            customReadQuery.setTranslationRow(primaryKeyRow);
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.shouldPrepare()) {
            if (this.getSelectionKey() != null) {
                this.setTranslationRow(this.descriptor.getObjectBuilder().buildRowFromPrimaryKeyValues(this.getSelectionKey(), this.getSession()));
            } else if (this.getSelectionObject() != null) {
                this.setTranslationRow(this.descriptor.getObjectBuilder().buildRowForTranslation(this.getSelectionObject(), this.getSession()));
            }
        }
    }

    protected void prePrepare() throws QueryException {
        super.prePrepare();
        if (this.getSelectionObject() != null && this.getSession().getProject().hasProxyIndirection()) {
            this.setSelectionObject(ProxyIndirectionPolicy.getValueFromProxy(this.getSelectionObject()));
        }
    }

    public Object registerResultInUnitOfWork(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, boolean buildDirectlyFromRows) {
        if (result == null) {
            return null;
        }
        if (this.shouldConformResultsInUnitOfWork() || this.descriptor.shouldAlwaysConformResultsInUnitOfWork()) {
            return this.conformResult(result, unitOfWork, arguments, buildDirectlyFromRows);
        }
        Object clone = null;
        clone = buildDirectlyFromRows ? this.buildObject((AbstractRecord)result) : this.registerIndividualResult(result, unitOfWork, null);
        if (this.shouldUseWrapperPolicy()) {
            clone = this.descriptor.getObjectBuilder().wrapObject(clone, unitOfWork);
        }
        return clone;
    }

    protected Object remoteExecute() {
        Object cacheHit;
        this.checkDescriptor(this.session);
        if (this.getSelectionObject() != null) {
            this.setSelectionKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(this.getSelectionObject(), this.session));
        }
        if ((cacheHit = this.checkEarlyReturn(this.getSession(), this.getTranslationRow())) != null || this.shouldCheckCacheOnly()) {
            return cacheHit;
        }
        return super.remoteExecute();
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return controller.replaceValueHoldersIn(object);
    }

    public void setSelectionKey(List selectionKey) {
        this.selectionKey = selectionKey == null ? null : (selectionKey instanceof NonSynchronizedVector ? (Vector)selectionKey : new NonSynchronizedVector((Collection)selectionKey));
    }

    public void setSelectionObject(Object selectionObject) {
        if (selectionObject == null) {
            throw QueryException.selectionObjectCannotBeNull(this);
        }
        this.setSelectionKey(null);
        if (this.selectionObject == null || this.selectionObject.getClass() != selectionObject.getClass()) {
            this.setIsPrepared(false);
        }
        this.setReferenceClass(selectionObject.getClass());
        this.selectionObject = selectionObject;
    }

    public void setShouldLoadResultIntoSelectionObject(boolean shouldLoadResultIntoSelectionObject) {
        this.shouldLoadResultIntoSelectionObject = shouldLoadResultIntoSelectionObject;
    }

    public void setSingletonSelectionKey(Object selectionKey) {
        Vector<Object> key = new Vector<Object>();
        key.addElement(selectionKey);
        this.setSelectionKey(key);
    }

    public boolean shouldCheckCache() {
        return this.cacheUsage != 0;
    }

    public boolean shouldCheckCacheByExactPrimaryKey() {
        return this.cacheUsage == 1;
    }

    public boolean shouldCheckCacheByPrimaryKey() {
        return this.cacheUsage == 2 || this.cacheUsage == -1;
    }

    public boolean shouldCheckCacheThenDatabase() {
        return this.cacheUsage == 3;
    }

    public boolean shouldLoadResultIntoSelectionObject() {
        return this.shouldLoadResultIntoSelectionObject;
    }

    protected boolean hasNonDefaultFetchGroup() {
        return this.descriptor.hasFetchGroupManager() && (this.fetchGroup != null || this.fetchGroupName != null || !this.shouldUseDefaultFetchGroup);
    }
}

