/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterRegistrationImpl
implements FilterRegistration {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected FilterDef filterDef;
    protected StandardContext ctx;

    FilterRegistrationImpl(FilterDef filterDef, StandardContext ctx) {
        this.filterDef = filterDef;
        this.ctx = ctx;
    }

    @Override
    public String getName() {
        return this.filterDef.getFilterName();
    }

    @Override
    public String getClassName() {
        return this.filterDef.getFilterClassName();
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"init parameter", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        return this.filterDef.setInitParameter(name, value, false);
    }

    @Override
    public String getInitParameter(String name) {
        return this.filterDef.getInitParameter(name);
    }

    @Override
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        return this.filterDef.setInitParameters(initParameters);
    }

    @Override
    public Map<String, String> getInitParameters() {
        return this.filterDef.getInitParameters();
    }

    @Override
    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"servlet-name mapping", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        if (servletNames == null || servletNames.length == 0) {
            throw new IllegalArgumentException(sm.getString("filterRegistration.mappingWithNullOrEmptyServletNames", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        for (String servletName : servletNames) {
            FilterMap fmap = new FilterMap();
            fmap.setFilterName(this.filterDef.getFilterName());
            fmap.setServletName(servletName);
            fmap.setDispatcherTypes(dispatcherTypes);
            this.ctx.addFilterMap(fmap, isMatchAfter);
        }
    }

    @Override
    public Collection<String> getServletNameMappings() {
        return this.ctx.getServletNameFilterMappings(this.getName());
    }

    @Override
    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"url-pattern mapping", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw new IllegalArgumentException(sm.getString("filterRegistration.mappingWithNullOrEmptyUrlPatterns", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        for (String urlPattern : urlPatterns) {
            FilterMap fmap = new FilterMap();
            fmap.setFilterName(this.filterDef.getFilterName());
            fmap.setURLPattern(urlPattern);
            fmap.setDispatcherTypes(dispatcherTypes);
            this.ctx.addFilterMap(fmap, isMatchAfter);
        }
    }

    @Override
    public Collection<String> getUrlPatternMappings() {
        return this.ctx.getUrlPatternFilterMappings(this.getName());
    }
}

