/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.GuiUtil;

public class UtilHandlers {
    private static final String PATH_SEPARATOR = "${path.separator}";

    public static void calendarAdd(HandlerContext handlerCtx) {
        int field = (Integer)handlerCtx.getInputValue("Field");
        int amount = (Integer)handlerCtx.getInputValue("Amount");
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(field, amount);
        handlerCtx.setOutputValue("Date", (Object)cal.getTime());
    }

    public static void getFile(HandlerContext handlerCtx) {
        String pathname = (String)handlerCtx.getInputValue("Pathname");
        handlerCtx.setOutputValue("File", (Object)(pathname != null ? new File(pathname) : null));
    }

    public static void fileGetName(HandlerContext handlerCtx) {
        File file = (File)handlerCtx.getInputValue("File");
        String name = file != null ? file.getName() : "";
        handlerCtx.setOutputValue("Name", (Object)(name != null ? name : ""));
    }

    public static void mapGet(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("Map");
        Object key = handlerCtx.getInputValue("Key");
        handlerCtx.setOutputValue("Value", map.get(key));
    }

    public static void listAdd(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        Integer index = (Integer)handlerCtx.getInputValue("index");
        if (index == null) {
            list.add(handlerCtx.getInputValue("value"));
        } else {
            list.add(index, handlerCtx.getInputValue("value"));
        }
    }

    public static void compare(HandlerContext handlerCtx) {
        boolean ret = false;
        Object obj1 = handlerCtx.getInputValue("obj1");
        Object obj2 = handlerCtx.getInputValue("obj2");
        if (obj1 != null) {
            ret = obj1.equals(obj2);
        } else if (obj2 == null) {
            ret = true;
        }
        handlerCtx.setOutputValue("objEqual", (Object)ret);
    }

    public static void prepareSuccessful(HandlerContext handlerCtx) {
        GuiUtil.prepareSuccessful(handlerCtx);
    }

    public static void prepareAlertMsg(HandlerContext handlerCtx) {
        String summary = (String)handlerCtx.getInputValue("summary");
        String type = (String)handlerCtx.getInputValue("type");
        String detail = (String)handlerCtx.getInputValue("detail");
        GuiUtil.prepareAlert(handlerCtx, type, summary, detail);
    }

    public static void decodeString(HandlerContext handlerCtx) {
        String str = (String)handlerCtx.getInputValue("str");
        String scheme = (String)handlerCtx.getInputValue("scheme");
        if (GuiUtil.isEmpty(str)) {
            handlerCtx.setOutputValue("output", (Object)"");
            return;
        }
        if (GuiUtil.isEmpty(scheme)) {
            scheme = "UTF-8";
        }
        try {
            String output = URLDecoder.decode(str, scheme);
            handlerCtx.setOutputValue("output", (Object)output);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("output", (Object)str);
        }
    }

    public static void roundTo2DecimalPoint(HandlerContext handlerCtx) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        try {
            Double input = (Double)handlerCtx.getInputValue("input");
            String output = input == null ? "" : df.format(input);
            handlerCtx.setOutputValue("output", (Object)output);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("output", (Object)"");
        }
    }

    public static void addEmptyFirstElement(HandlerContext handlerCtx) {
        List in = (List)handlerCtx.getInputValue("in");
        ArrayList<String> ar = null;
        ar = in == null ? new ArrayList<String>() : new ArrayList(in);
        ar.add(0, "");
        handlerCtx.setOutputValue("out", ar);
    }

    public static void getListBoxOptions(HandlerContext handlerCtx) {
        String selectedCommaString = (String)handlerCtx.getInputValue("selectedCommaString");
        ArrayList<String> availableList = (ArrayList<String>)handlerCtx.getInputValue("availableList");
        String addEmptyFirstChoice = (String)handlerCtx.getInputValue("addEmptyFirstChoice");
        String[] selectedOptions = null;
        if (addEmptyFirstChoice != null) {
            if (availableList == null) {
                availableList = new ArrayList<String>();
            }
            availableList.add(0, "");
        }
        if (availableList != null && availableList.size() > 0 && (selectedOptions = GuiUtil.stringToArray(selectedCommaString, ",")) != null && selectedOptions.length <= 0) {
            selectedOptions = new String[]{(String)availableList.get(0)};
        }
        handlerCtx.setOutputValue("availableListResult", availableList);
        handlerCtx.setOutputValue("selectedOptions", (Object)selectedOptions);
    }

    public static void convertArrayToString(HandlerContext handlerCtx) {
        String[] array = (String[])handlerCtx.getInputValue("array");
        String commaString = "";
        if (array != null && array.length > 0) {
            commaString = GuiUtil.arrayToString(array, ",");
        }
        handlerCtx.setOutputValue("commaString", (Object)commaString);
    }

    public static void convertListToCommaString(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        String commaString = "";
        if (list != null && list.size() > 0) {
            commaString = GuiUtil.listToString(list, ",");
        }
        handlerCtx.setOutputValue("commaString", (Object)commaString);
    }

    public static void formatStringsforDisplay(HandlerContext handlerCtx) {
        String values = (String)handlerCtx.getInputValue("string");
        if (values == null || GuiUtil.isEmpty(values.trim())) {
            handlerCtx.setOutputValue("formattedString", (Object)"");
        } else {
            String s1 = values.trim().replaceAll("\\.jar:", "\\.jar\\$\\{path.separator\\}");
            String s2 = s1.replaceAll("\\.jar;", "\\.jar\\$\\{path.separator\\}");
            String[] strArray = s2.split("\\$\\{path.separator\\}");
            String result = "";
            for (String s : strArray) {
                result = result + s + "\n";
            }
            handlerCtx.setOutputValue("formattedString", (Object)result.trim());
        }
    }

    public static void formatPathSeperatorStringsforSaving(HandlerContext handlerCtx) {
        String values = (String)handlerCtx.getInputValue("string");
        String token = "";
        if (values != null && values.toString().trim().length() != 0) {
            for (String nextToken : GuiUtil.parseStringList(values, "\t\n\r\f")) {
                token = token + nextToken + PATH_SEPARATOR;
            }
            int end = token.length() - PATH_SEPARATOR.length();
            if (token.lastIndexOf(PATH_SEPARATOR) == end) {
                token = token.substring(0, end);
            }
        }
        handlerCtx.setOutputValue("formattedString", (Object)token);
    }

    public static void addHandler(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        String desc = (String)handlerCtx.getInputValue("desc");
        String cls = (String)handlerCtx.getInputValue("class");
        String meth = (String)handlerCtx.getInputValue("method");
        HandlerDefinition def = new HandlerDefinition(id);
        def.setHandlerMethod(cls, meth);
        if (desc != null) {
            def.setDescription(desc);
        }
        LayoutDefinitionManager.addGlobalHandlerDefinition((HandlerDefinition)def);
    }

    public static boolean forLoop(HandlerContext handlerCtx) {
        Integer startInt = (Integer)handlerCtx.getInputValue("start");
        int start = startInt == null ? 0 : startInt;
        int end = (Integer)handlerCtx.getInputValue("end");
        String varName = (String)handlerCtx.getInputValue("varName");
        List handlers = handlerCtx.getHandler().getChildHandlers();
        if (handlers.size() > 0) {
            LayoutElement elt = handlerCtx.getLayoutElement();
            Map<String, Object> requestMap = handlerCtx.getFacesContext().getExternalContext().getRequestMap();
            for (int ix = start; ix <= end; ++ix) {
                requestMap.put(varName, ix);
                elt.dispatchHandlers(handlerCtx, handlers);
            }
        }
        return false;
    }

    public static void convertStrToBoolean(HandlerContext handlerCtx) {
        String str = (String)handlerCtx.getInputValue("str");
        handlerCtx.setOutputValue("out", (Object)"true".equals(str));
    }
}

