/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import org.glassfish.admin.amx.base.ConnectorRuntimeAPIProvider;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectorRuntimeAPIProviderImpl
extends AMXImplBase {
    private final Habitat mHabitat;

    public ConnectorRuntimeAPIProviderImpl(ObjectName parent, Habitat habitat) {
        super(parent, ConnectorRuntimeAPIProvider.class);
        if (habitat == null) {
            throw new IllegalStateException("Habitat is null");
        }
        this.mHabitat = habitat;
    }

    public Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String datasourceClassName, String resType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map connProps = this.getConnectorRuntime().getConnectionDefinitionPropertiesAndDefaults(datasourceClassName, resType);
            result.put("PropertyMapKey", connProps);
        }
        catch (ComponentException e) {
            result.put("PropertyMapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    private ConnectorRuntime getConnectorRuntime() {
        return (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
    }

    public Map<String, Object> getSystemConnectorsAllowingPoolCreation() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] systemRars = this.getConnectorRuntime().getSystemConnectorsAllowingPoolCreation();
            result.put("StringArrayKey", systemRars);
        }
        catch (ComponentException e) {
            result.put("StringArrayKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getBuiltInCustomResources() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map customResources = this.getConnectorRuntime().getBuiltInCustomResources();
            result.put("MapKey", customResources);
        }
        catch (ComponentException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getConnectionDefinitionNames(String rarName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] conDefnNames = this.getConnectorRuntime().getConnectionDefinitionNames(rarName);
            result.put("StringArrayKey", conDefnNames);
        }
        catch (ConnectorRuntimeException e) {
            result.put("StringArrayKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("StringArrayKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getMCFConfigProps(String rarName, String connectionDefName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getMCFConfigProps(rarName, connectionDefName);
            result.put("MapKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getAdminObjectInterfaceNames(String rarName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] adminObjectInterfaceNames = this.getConnectorRuntime().getAdminObjectInterfaceNames(rarName);
            result.put("StringArrayKey", adminObjectInterfaceNames);
        }
        catch (ConnectorRuntimeException e) {
            result.put("StringArrayKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("StringArrayKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getResourceAdapterConfigProps(String rarName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getResourceAdapterConfigProps(rarName);
            result.put("MapKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getAdminObjectConfigProps(String rarName, String adminObjectIntf) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getAdminObjectConfigProps(rarName, adminObjectIntf);
            result.put("MapKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getConnectorConfigJavaBeans(String rarName, String connectionDefName, String type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getConnectorConfigJavaBeans(rarName, connectionDefName, type);
            result.put("MapKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getActivationSpecClass(String rarName, String messageListenerType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String activationSpec = this.getConnectorRuntime().getActivationSpecClass(rarName, messageListenerType);
            result.put("StringKey", activationSpec);
        }
        catch (ConnectorRuntimeException e) {
            result.put("StringKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("StringKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getMessageListenerTypes(String rarName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] messageListenerTypes = this.getConnectorRuntime().getMessageListenerTypes(rarName);
            result.put("StringArrayKey", messageListenerTypes);
        }
        catch (ConnectorRuntimeException e) {
            result.put("StringArrayKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("StringArrayKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getMessageListenerConfigProps(String rarName, String messageListenerType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getMessageListenerConfigProps(rarName, messageListenerType);
            result.put("MapKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getMessageListenerConfigPropTypes(String rarName, String messageListenerType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getMessageListenerConfigPropTypes(rarName, messageListenerType);
            result.put("MapKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> flushConnectionPool(String poolName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.mHabitat == null) {
            result.put("BooleanKey", false);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            connRuntime.flushConnectionPool(poolName);
            result.put("BooleanKey", true);
        }
        catch (ConnectorRuntimeException ex) {
            result.put("BooleanKey", false);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)ex));
        }
        catch (ComponentException e) {
            result.put("BooleanKey", false);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getValidationTableNames(String poolName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            Set tableNames = connRuntime.getValidationTableNames(poolName);
            result.put("SetKey", tableNames);
        }
        catch (ComponentException e) {
            result.put("SetKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("SetKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getJdbcDriverClassNames(String dbVendor, String resType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            Set implClassNames = connRuntime.getJdbcDriverClassNames(dbVendor, resType);
            result.put("SetKey", implClassNames);
        }
        catch (ComponentException e) {
            result.put("SetKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("SetKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> pingJDBCConnectionPool(String poolName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.mHabitat == null) {
            result.put("BooleanKey", false);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            boolean pingStatus = connRuntime.pingConnectionPool(poolName);
            result.put("BooleanKey", pingStatus);
        }
        catch (ResourceException ex) {
            result.put("BooleanKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)ex));
        }
        catch (ComponentException e) {
            result.put("BooleanKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("BooleanKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getValidationClassNames(String dbVendor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            Set valClassNames = connRuntime.getValidationClassNames(dbVendor);
            result.put("SetKey", valClassNames);
        }
        catch (ComponentException e) {
            result.put("SetKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("SetKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }
}

