/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.Server;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.ejb.embedded.EJBContainerImpl;
import org.glassfish.ejb.embedded.EjbBuilder;
import org.glassfish.ejb.embedded.EmbeddedEjbContainer;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerProviderImpl
implements EJBContainerProvider {
    private static final String GF_PROVIDER_NAME = EJBContainerProviderImpl.class.getName();
    private static final String JAR_FILE_EXT = ".jar";
    private static final Attributes.Name ATTRIBUTE_NAME_SKIP = new Attributes.Name("Bundle-SymbolicName");
    private static final String[] ATTRIBUTE_VALUES_SKIP = new String[]{"org.glassfish.", "com.sun.enterprise.", "org.eclipse."};
    private static final String[] ATTRIBUTE_VALUES_OK = new String[]{"sample", "test"};
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private static final StringManager localStrings = StringManager.getManager(EJBContainerProviderImpl.class);
    private static final Object lock = new Object();
    private static EJBContainerImpl container;
    private static Server server;
    private static Habitat habitat;
    private static ArchiveFactory archiveFactory;
    private static Class[] ejbAnnotations;

    @Override
    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        if (properties == null || properties.get("javax.ejb.embeddable.provider") == null || properties.get("javax.ejb.embeddable.provider").equals(GF_PROVIDER_NAME)) {
            if (container != null && container.isOpen()) {
                throw new EJBException(localStrings.getString("ejb.embedded.exception_exists_container"));
            }
            this.init(properties);
            try {
                Set<File> modules = this.addEJBModules(properties);
                if (modules.isEmpty()) {
                    _logger.log(Level.SEVERE, "No EJB modules found");
                }
                container.deploy(properties, modules);
                return container;
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "ejb.embedded.exception_instantiating", t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Map<?, ?> properties) throws EJBException {
        Object object = lock;
        synchronized (object) {
            Server.Builder builder = new Server.Builder("GFEJBContainerProviderImpl");
            File installed_root = null;
            File domain_file = null;
            if (properties != null) {
                String gf_root = (String)properties.get("glassfish.ejb.embedded.glassfish.installation");
                System.err.println("+++ gf_root : " + gf_root);
                if (gf_root != null) {
                    installed_root = new File(gf_root);
                    if (!installed_root.exists()) {
                        _logger.log(Level.SEVERE, "ejb.embedded.location_not_exists", gf_root);
                        installed_root = null;
                    } else {
                        String domain_root = gf_root + File.separatorChar + "domains" + File.separatorChar + "domain1" + File.separatorChar + "config" + File.separatorChar + "domain.xml";
                        System.err.println("+++ domain_root : " + domain_root);
                        domain_file = new File(domain_root);
                        if (!domain_file.exists()) {
                            _logger.log(Level.SEVERE, "ejb.embedded.location_not_exists", domain_root);
                            installed_root = null;
                        }
                    }
                }
            }
            System.err.println("+++ installed_root: " + installed_root);
            System.err.println("+++ domain_file: " + domain_file);
            if (installed_root == null) {
                server = builder.build();
            } else {
                EmbeddedFileSystem.Builder efsb = new EmbeddedFileSystem.Builder();
                efsb.setInstallRoot(installed_root);
                efsb.setConfigurationFile(domain_file);
                builder.setEmbeddedFileSystem(efsb.build());
                server = builder.build();
            }
            EjbBuilder ejb = (EjbBuilder)server.createConfig(EjbBuilder.class);
            habitat = ejb.habitat;
            archiveFactory = (ArchiveFactory)habitat.getComponent(ArchiveFactory.class);
            EmbeddedEjbContainer ejbContainer = (EmbeddedEjbContainer)server.addContainer((ContainerBuilder)ejb);
            server.addContainer(ContainerBuilder.Type.jpa);
            EmbeddedDeployer deployer = server.getDeployer();
            Sniffer sniffer = (Sniffer)habitat.getComponent(Sniffer.class, "Ejb");
            ejbAnnotations = sniffer.getAnnotationTypes();
            container = new EJBContainerImpl(server, ejbContainer, deployer);
        }
    }

    private Set<File> addEJBModules(Map<?, ?> properties) {
        HashSet<File> modules = new HashSet<File>();
        Object obj = properties == null ? null : properties.get("javax.ejb.embeddable.modules");
        HashSet<String> moduleNames = new HashSet<String>();
        if (obj != null) {
            Object[] arr;
            if (obj instanceof String) {
                moduleNames.add(obj);
            } else if (obj instanceof String[]) {
                arr = obj;
                for (Object s : arr) {
                    moduleNames.add((String)s);
                }
            } else if (obj instanceof File) {
                this.addEJBModule(modules, moduleNames, obj);
            } else if (obj instanceof File[]) {
                arr = obj;
                for (Object f : arr) {
                    this.addEJBModule(modules, moduleNames, (File)f);
                }
            }
        }
        if (modules.isEmpty()) {
            String[] entries;
            String path = System.getProperty("java.class.path");
            for (String s0 : entries = path.split(File.pathSeparator)) {
                this.addEJBModule(modules, moduleNames, new File(s0));
            }
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRequestedEJBModule(File file, Set<String> moduleNames) throws Exception {
        boolean bl;
        InputStream is;
        block7: {
            String fileName = file.getName();
            System.err.println("... Testing ... " + fileName);
            ReadableArchive archive = null;
            is = null;
            try {
                boolean handles = false;
                String moduleName = DeploymentUtils.getDefaultEEName((String)fileName);
                archive = archiveFactory.openArchive(file);
                is = archive.getEntry("META-INF/ejb-jar.xml");
                if (is != null) {
                    handles = true;
                    EjbDeploymentDescriptorFile eddf = new EjbDeploymentDescriptorFile();
                    eddf.setXMLValidation(false);
                    EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)eddf.read(is);
                    ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
                    moduleDesc.setArchiveUri(fileName);
                    moduleName = moduleDesc.getModuleName();
                } else {
                    GenericAnnotationDetector detector = new GenericAnnotationDetector(ejbAnnotations);
                    handles = detector.hasAnnotationInArchive(archive);
                }
                System.err.println("... is EJB module: " + handles);
                if (handles) {
                    System.err.println("... is Requested EJB module [" + moduleName + "]: " + (moduleNames.isEmpty() || moduleNames.contains(moduleName)));
                }
                bl = handles && (moduleNames.isEmpty() || moduleNames.contains(moduleName));
                Object var12_12 = null;
                if (archive == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var12_13 = null;
                    if (archive != null) {
                        archive.close();
                    }
                    if (is == null) break block8;
                    is.close();
                }
                throw throwable;
            }
            archive.close();
        }
        if (is != null) {
            is.close();
        }
        return bl;
    }

    private void addEJBModule(Set<File> modules, Set<String> moduleNames, File f) {
        try {
            if (f.exists() && this.isRequestedEJBModule(f, moduleNames) && !this.skipJar(f)) {
                modules.add(f);
                _logger.info("... Added EJB Module .... " + f.getName());
            }
        }
        catch (Exception ioe) {
            _logger.log(Level.INFO, "ejb.embedded.io_exception", ioe);
        }
    }

    private boolean skipJar(File file) throws Exception {
        Attributes attributes;
        String value;
        if (!file.isFile()) {
            return false;
        }
        JarFile jf = new JarFile(file);
        Manifest m = jf.getManifest();
        if (m != null && (value = (attributes = m.getMainAttributes()).getValue(ATTRIBUTE_NAME_SKIP)) != null) {
            for (String skipValue : ATTRIBUTE_VALUES_SKIP) {
                if (!value.startsWith(skipValue)) continue;
                for (String okValue : ATTRIBUTE_VALUES_OK) {
                    if (value.indexOf(okValue) <= 0) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    static {
        ejbAnnotations = null;
    }
}

