/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.enterprise.v3.server.AppServerStartup;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="upgrade")
public class UpgradeStartup
implements ModuleStartup {
    @Inject
    CommandRunner runner;
    @Inject
    AppServerStartup appservStartup;
    @Inject
    Applications applications;
    @Inject
    Logger logger;

    public void setStartupContext(StartupContext startupContext) {
        this.appservStartup.setStartupContext(startupContext);
    }

    public void start() {
        ArrayList<Application> enabledApps = new ArrayList<Application>();
        for (Application app : this.applications.getApplications()) {
            System.out.println("app " + app.getName() + " is " + app.getEnabled() + " resulting in " + Boolean.parseBoolean(app.getEnabled()));
            if (!Boolean.parseBoolean(app.getEnabled())) continue;
            this.logger.log(Level.INFO, "Disabling application " + app.getName());
            enabledApps.add(app);
        }
        if (enabledApps.size() > 0) {
            try {
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... configBeanProxies) throws PropertyVetoException, TransactionFailure {
                        for (ConfigBeanProxy proxy : configBeanProxies) {
                            Application app = (Application)proxy;
                            app.setEnabled(Boolean.FALSE.toString());
                        }
                        return null;
                    }
                }, (ConfigBeanProxy[])((ConfigBeanProxy[])enabledApps.toArray(new Application[enabledApps.size()])));
            }
            catch (TransactionFailure tf) {
                this.logger.log(Level.SEVERE, "Exception while disabling applications", tf);
                return;
            }
        }
        this.appservStartup.start();
        for (Application app : this.applications.getApplications()) {
            this.logger.log(Level.INFO, "Redeploy application " + app.getName() + " located at " + app.getLocation());
        }
        if (enabledApps.size() > 0) {
            try {
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... configBeanProxies) throws PropertyVetoException, TransactionFailure {
                        for (ConfigBeanProxy proxy : configBeanProxies) {
                            Application app = (Application)proxy;
                            UpgradeStartup.this.logger.log(Level.INFO, "Enabling application " + app.getName());
                            app.setEnabled(Boolean.TRUE.toString());
                        }
                        return null;
                    }
                }, (ConfigBeanProxy[])((ConfigBeanProxy[])enabledApps.toArray(new Application[enabledApps.size()])));
            }
            catch (TransactionFailure tf) {
                this.logger.log(Level.SEVERE, "Exception while disabling applications", tf);
                return;
            }
        }
        Logger.getAnonymousLogger().info("Exiting after upgrade");
        try {
            Thread.sleep(3000L);
            if (this.runner != null) {
                this.runner.doCommand("stop-domain", new Properties(), (ActionReport)new PlainTextActionReporter());
                return;
            }
        }
        catch (InterruptedException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Exception while attempting to shutdown after upgrade", e);
        }
    }

    public void stop() {
        this.appservStartup.stop();
    }
}

