/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Constraint;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validation.constraints.impl.AssertFalseValidator;
import org.hibernate.validation.constraints.impl.AssertTrueValidator;
import org.hibernate.validation.constraints.impl.DecimalMaxValidatorForNumber;
import org.hibernate.validation.constraints.impl.DecimalMaxValidatorForString;
import org.hibernate.validation.constraints.impl.DecimalMinValidatorForNumber;
import org.hibernate.validation.constraints.impl.DecimalMinValidatorForString;
import org.hibernate.validation.constraints.impl.DigitsValidatorForNumber;
import org.hibernate.validation.constraints.impl.DigitsValidatorForString;
import org.hibernate.validation.constraints.impl.FutureValidatorForCalendar;
import org.hibernate.validation.constraints.impl.FutureValidatorForDate;
import org.hibernate.validation.constraints.impl.MaxValidatorForNumber;
import org.hibernate.validation.constraints.impl.MaxValidatorForString;
import org.hibernate.validation.constraints.impl.MinValidatorForNumber;
import org.hibernate.validation.constraints.impl.MinValidatorForString;
import org.hibernate.validation.constraints.impl.NotNullValidator;
import org.hibernate.validation.constraints.impl.NullValidator;
import org.hibernate.validation.constraints.impl.PastValidatorForCalendar;
import org.hibernate.validation.constraints.impl.PastValidatorForDate;
import org.hibernate.validation.constraints.impl.PatternValidator;
import org.hibernate.validation.constraints.impl.SizeValidatorForArray;
import org.hibernate.validation.constraints.impl.SizeValidatorForArraysOfBoolean;
import org.hibernate.validation.constraints.impl.SizeValidatorForArraysOfByte;
import org.hibernate.validation.constraints.impl.SizeValidatorForArraysOfChar;
import org.hibernate.validation.constraints.impl.SizeValidatorForArraysOfDouble;
import org.hibernate.validation.constraints.impl.SizeValidatorForArraysOfFloat;
import org.hibernate.validation.constraints.impl.SizeValidatorForArraysOfInt;
import org.hibernate.validation.constraints.impl.SizeValidatorForArraysOfLong;
import org.hibernate.validation.constraints.impl.SizeValidatorForCollection;
import org.hibernate.validation.constraints.impl.SizeValidatorForMap;
import org.hibernate.validation.constraints.impl.SizeValidatorForString;
import org.hibernate.validation.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintHelper {
    private final ConcurrentHashMap<Class<? extends Annotation>, List<Class<? extends ConstraintValidator<?, ?>>>> builtinConstraints = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Annotation>, List<Class<? extends ConstraintValidator<? extends Annotation, ?>>>> constraintValidatorDefinitons = new ConcurrentHashMap();

    public ConstraintHelper() {
        ArrayList<Class> constraintList = new ArrayList<Class>();
        constraintList.add(AssertFalseValidator.class);
        this.builtinConstraints.put(AssertFalse.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(AssertTrueValidator.class);
        this.builtinConstraints.put(AssertTrue.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(DecimalMaxValidatorForNumber.class);
        constraintList.add(DecimalMaxValidatorForString.class);
        this.builtinConstraints.put(DecimalMax.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(DecimalMinValidatorForNumber.class);
        constraintList.add(DecimalMinValidatorForString.class);
        this.builtinConstraints.put(DecimalMin.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(DigitsValidatorForString.class);
        constraintList.add(DigitsValidatorForNumber.class);
        this.builtinConstraints.put(Digits.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(FutureValidatorForCalendar.class);
        constraintList.add(FutureValidatorForDate.class);
        this.builtinConstraints.put(Future.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(MaxValidatorForNumber.class);
        constraintList.add(MaxValidatorForString.class);
        this.builtinConstraints.put(Max.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(MinValidatorForNumber.class);
        constraintList.add(MinValidatorForString.class);
        this.builtinConstraints.put(Min.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(NotNullValidator.class);
        this.builtinConstraints.put(NotNull.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(NullValidator.class);
        this.builtinConstraints.put(Null.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(PastValidatorForCalendar.class);
        constraintList.add(PastValidatorForDate.class);
        this.builtinConstraints.put(Past.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(PatternValidator.class);
        this.builtinConstraints.put(Pattern.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(SizeValidatorForString.class);
        constraintList.add(SizeValidatorForCollection.class);
        constraintList.add(SizeValidatorForArray.class);
        constraintList.add(SizeValidatorForMap.class);
        constraintList.add(SizeValidatorForArraysOfBoolean.class);
        constraintList.add(SizeValidatorForArraysOfByte.class);
        constraintList.add(SizeValidatorForArraysOfChar.class);
        constraintList.add(SizeValidatorForArraysOfDouble.class);
        constraintList.add(SizeValidatorForArraysOfFloat.class);
        constraintList.add(SizeValidatorForArraysOfInt.class);
        constraintList.add(SizeValidatorForArraysOfLong.class);
        this.builtinConstraints.put(Size.class, constraintList);
    }

    public List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> getBuiltInConstraints(Class<? extends Annotation> annotationClass) {
        List<Class<ConstraintValidator<?, ?>>> builtInList = this.builtinConstraints.get(annotationClass);
        if (builtInList == null || builtInList.size() == 0) {
            throw new ValidationException("Unable to find constraints for  " + annotationClass);
        }
        ArrayList constraints = new ArrayList(builtInList.size());
        Iterator<Class<ConstraintValidator<?, ?>>> i$ = builtInList.iterator();
        while (i$.hasNext()) {
            Class<ConstraintValidator<?, ?>> validatorClass;
            Class<ConstraintValidator<?, ?>> safeValdiatorClass = validatorClass = i$.next();
            constraints.add(safeValdiatorClass);
        }
        return constraints;
    }

    public boolean isBuiltinConstraint(Class<? extends Annotation> annotationType) {
        return this.builtinConstraints.containsKey(annotationType);
    }

    public boolean isMultiValueConstraint(Annotation annotation) {
        boolean isMultiValueConstraint;
        block6: {
            isMultiValueConstraint = false;
            try {
                Annotation[] annotations;
                Method m = annotation.getClass().getMethod("value", new Class[0]);
                Class<?> returnType = m.getReturnType();
                if (!returnType.isArray() || !returnType.getComponentType().isAnnotation()) break block6;
                for (Annotation a : annotations = (Annotation[])m.invoke((Object)annotation, new Object[0])) {
                    if (!this.isConstraintAnnotation(a) && !this.isBuiltinConstraint(a.annotationType())) {
                        isMultiValueConstraint = false;
                        break;
                    }
                    isMultiValueConstraint = true;
                }
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return isMultiValueConstraint;
    }

    public <A extends Annotation> List<Annotation> getMultiValueConstraints(A annotation) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        try {
            Method m = annotation.getClass().getMethod("value", new Class[0]);
            Class<?> returnType = m.getReturnType();
            if (returnType.isArray() && returnType.getComponentType().isAnnotation()) {
                Annotation[] annotations;
                for (Annotation a : annotations = (Annotation[])m.invoke(annotation, new Object[0])) {
                    if (!this.isConstraintAnnotation(a) && !this.isBuiltinConstraint(a.annotationType())) continue;
                    annotationList.add(a);
                }
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return annotationList;
    }

    public boolean isConstraintAnnotation(Annotation annotation) {
        Constraint constraint = annotation.annotationType().getAnnotation(Constraint.class);
        if (constraint == null) {
            return false;
        }
        this.assertMessageParameterExists(annotation);
        this.assertGroupsParameterExists(annotation);
        this.assertPayloadParameterExists(annotation);
        this.assertNoParameterStartsWithValid(annotation);
        return true;
    }

    private void assertNoParameterStartsWithValid(Annotation annotation) {
        Method[] methods;
        for (Method m : methods = annotation.getClass().getMethods()) {
            if (!m.getName().startsWith("valid")) continue;
            String msg = "Parameters starting with 'valid' are not allowed in a constraint.";
            throw new ConstraintDefinitionException(msg);
        }
    }

    private void assertPayloadParameterExists(Annotation annotation) {
        try {
            Class[] defaultPayload = (Class[])annotation.annotationType().getMethod("payload", new Class[0]).getDefaultValue();
            if (defaultPayload.length != 0) {
                String msg = annotation.annotationType().getName() + " contains Constraint annotation, but the payload " + "paramter default value is not the empty array.";
                throw new ConstraintDefinitionException(msg);
            }
        }
        catch (ClassCastException e) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but the " + "payload parameter is of wrong type.";
            throw new ConstraintDefinitionException(msg);
        }
        catch (NoSuchMethodException nsme) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but does " + "not contain a payload parameter.";
            throw new ConstraintDefinitionException(msg);
        }
    }

    private void assertGroupsParameterExists(Annotation annotation) {
        try {
            Class[] defaultGroups = (Class[])annotation.annotationType().getMethod("groups", new Class[0]).getDefaultValue();
            if (defaultGroups.length != 0) {
                String msg = annotation.annotationType().getName() + " contains Constraint annotation, but the groups " + "paramter default value is not the empty array.";
                throw new ConstraintDefinitionException(msg);
            }
        }
        catch (ClassCastException e) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but the " + "groups parameter is of wrong type.";
            throw new ConstraintDefinitionException(msg);
        }
        catch (NoSuchMethodException nsme) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but does " + "not contain a groups parameter.";
            throw new ConstraintDefinitionException(msg);
        }
    }

    private void assertMessageParameterExists(Annotation annotation) {
        try {
            ReflectionHelper.getAnnotationParameter(annotation, "message", String.class);
        }
        catch (Exception e) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but does " + "not contain a message parameter.";
            throw new ConstraintDefinitionException(msg);
        }
    }

    public <T extends Annotation> List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorDefinition(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        List<Class<ConstraintValidator<Annotation, ?>>> list = this.constraintValidatorDefinitons.get(annotationClass);
        ArrayList constraintsValidators = new ArrayList(list.size());
        Iterator<Class<ConstraintValidator<Annotation, ?>>> i$ = list.iterator();
        while (i$.hasNext()) {
            Class<ConstraintValidator<Annotation, ?>> validatorClass;
            Class<ConstraintValidator<Annotation, ?>> safeValdiatorClass = validatorClass = i$.next();
            constraintsValidators.add(safeValdiatorClass);
        }
        return constraintsValidators;
    }

    public <A extends Annotation> void addConstraintValidatorDefinition(Class<A> annotationClass, List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> definitionClasses) {
        this.constraintValidatorDefinitons.putIfAbsent(annotationClass, definitionClasses);
    }

    public boolean containsConstraintValidatorDefinition(Class<? extends Annotation> annotationClass) {
        return this.constraintValidatorDefinitons.containsKey(annotationClass);
    }
}

