/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXConnectorServerMBean;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.BootAMX;
import org.glassfish.admin.mbeanserver.JMXMPConnectorStarter;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.glassfish.api.amx.BootAMXMBean;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.AdminAccessController;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
@Async
public final class JMXStartupService
implements Startup,
PostConstruct {
    @Inject
    private MBeanServer mMBeanServer = ManagementFactory.getPlatformMBeanServer();
    @Inject
    private AdminService mAdminService;
    @Inject
    private Habitat mHabitat;
    @Inject
    Events mEvents;
    @Inject
    static volatile AdminAccessController sAuthenticator;
    private volatile BootAMX mBootAMX;
    private volatile JMXConnectorsStarterThread mConnectorsStarterThread;

    private static void debug(String s) {
        System.out.println("### " + s);
    }

    public void postConstruct() {
        this.mBootAMX = BootAMX.create(this.mHabitat, this.mMBeanServer);
        List configuredConnectors = this.mAdminService.getJmxConnector();
        this.mConnectorsStarterThread = new JMXConnectorsStarterThread(this.mMBeanServer, configuredConnectors, this.mBootAMX);
        this.mConnectorsStarterThread.start();
        this.mEvents.register((EventListener)new ShutdownListener());
    }

    private void shutdown() {
        Util.getLogger().info("ConnectorStartupService: shutting down AMX and JMX");
        this.mConnectorsStarterThread.shutdown();
    }

    private static Registry startRegistry(int port) {
        System.setProperty("java.rmi.server.randomIDs", "true");
        try {
            return LocateRegistry.createRegistry(port);
        }
        catch (Exception e) {
            throw new RuntimeException("Port " + port + " is not available for the internal rmi registry. " + "This means that a call was made with the same port, without closing earlier " + "registry instance. This has to do with the system jmx connector configuration " + "in admin-service element of the configuration associated with this instance");
        }
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JMXConnectorsStarterThread
    extends Thread {
        private final List<JmxConnector> mConfiguredConnectors;
        private final MBeanServer mMBeanServer;
        private final BootAMX mAMXBooterNew;
        private final List<JMXConnectorServer> mConnectorServers = new ArrayList<JMXConnectorServer>();

        public JMXConnectorsStarterThread(MBeanServer mbs, List<JmxConnector> configuredConnectors, BootAMX amxBooter) {
            this.mMBeanServer = mbs;
            this.mConfiguredConnectors = configuredConnectors;
            this.mAMXBooterNew = amxBooter;
        }

        void shutdown() {
            for (JMXConnectorServer connector : this.mConnectorServers) {
                try {
                    JMXServiceURL address = connector.getAddress();
                    connector.stop();
                    Util.getLogger().info("Stopped JMXConnectorServer: " + address);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mConnectorServers.clear();
        }

        private static String toString(JmxConnector c) {
            return "JmxConnector config: { name = " + c.getName() + ", Protocol = " + c.getProtocol() + ", Address = " + c.getAddress() + ", Port = " + c.getPort() + ", AcceptAll = " + c.getAcceptAll() + ", AuthRealmName = " + c.getAuthRealmName() + ", SecurityEnabled = " + c.getSecurityEnabled() + "}";
        }

        private JMXConnectorServer startConnector(JmxConnector connConfig) throws IOException {
            Object starter;
            Util.getLogger().fine("Starting JMXConnector: " + JMXConnectorsStarterThread.toString(connConfig));
            String protocol = connConfig.getProtocol();
            String address = connConfig.getAddress();
            int port = Integer.parseInt(connConfig.getPort());
            String authRealmName = connConfig.getAuthRealmName();
            boolean securityEnabled = Boolean.parseBoolean(connConfig.getSecurityEnabled());
            JMXConnectorServerMBean server = null;
            if (protocol.equals("rmi_jrmp")) {
                starter = new RMIConnectorStarter(this.mMBeanServer, address, port, protocol, authRealmName, securityEnabled);
                server = ((RMIConnectorStarter)starter).startRMIConnector("jmxrmi");
            } else if (protocol.equals("jmxmp")) {
                starter = new JMXMPConnectorStarter(this.mMBeanServer, address, port, authRealmName, securityEnabled);
                server = ((JMXMPConnectorStarter)starter).start(true);
            }
            JMXServiceURL url = server.getAddress();
            Util.getLogger().info("Started JMXConnector, JMXService URL = " + url);
            try {
                ObjectName objectName = new ObjectName("jmxremote:type=jmx-connector-server,protocol=" + protocol + ",name=" + connConfig.getName());
                objectName = this.mMBeanServer.registerMBean(server, objectName).getObjectName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return server;
        }

        @Override
        public void run() {
            Util.getLogger().fine("Number of JMX connectors: " + this.mConfiguredConnectors.size());
            for (JmxConnector c : this.mConfiguredConnectors) {
                if (!Boolean.parseBoolean(c.getEnabled())) {
                    Util.getLogger().info("JmxConnector " + c.getName() + " is disabled, skipping.");
                    continue;
                }
                try {
                    JMXConnectorServer server = this.startConnector(c);
                    this.mConnectorServers.add(server);
                }
                catch (Throwable t) {
                    Util.getLogger().warning("Cannot start JMX connector: " + JMXConnectorsStarterThread.toString(c) + ": " + t);
                }
            }
        }

        private final class RMIConnectorStarter {
            private final MBeanServer mMBeanServer;
            private final String mAddress;
            private final int mPort;
            private final String mProtocol;
            private final String mAuthRealmName;
            private final boolean mSecurityEnabled;
            private final Registry mRegistry;

            public RMIConnectorStarter(MBeanServer mbeanServer, String address, int port, String protocol, String authRealmName, boolean securityEnabled) {
                this.mMBeanServer = mbeanServer;
                this.mAddress = address;
                this.mPort = port;
                this.mProtocol = protocol;
                this.mAuthRealmName = authRealmName;
                this.mSecurityEnabled = securityEnabled;
                if (securityEnabled) {
                    throw new IllegalArgumentException("JMXConnectorServer not yet supporting security");
                }
                if (!"rmi_jrmp".equals(protocol)) {
                    throw new IllegalArgumentException("JMXConnectorServer not yet supporting protocol: " + protocol);
                }
                this.mRegistry = JMXStartupService.startRegistry(this.mPort);
            }

            public JMXConnectorServer startRMIConnector(String name) throws IOException {
                String hostname = Util.localhost();
                HashMap<String, AdminAccessController> env = new HashMap<String, AdminAccessController>();
                if (sAuthenticator != null) {
                    env.put("jmx.remote.authenticator", sAuthenticator);
                }
                boolean useSamePortForClients = false;
                String jmxServiceURL = null;
                jmxServiceURL = "service:jmx:rmi:///jndi/rmi://" + hostname + ":" + this.mPort + "/" + name;
                JMXServiceURL url = new JMXServiceURL(jmxServiceURL);
                JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, this.mMBeanServer);
                BootAMXListener listener = new BootAMXListener(cs, JMXConnectorsStarterThread.this.mAMXBooterNew);
                cs.addNotificationListener(listener, null, null);
                cs.start();
                return cs;
            }
        }
    }

    private static final class BootAMXListener
    implements NotificationListener {
        private final JMXConnectorServer mServer;
        private final BootAMXMBean mBooter;

        public BootAMXListener(JMXConnectorServer server, BootAMXMBean booter) {
            this.mServer = server;
            this.mBooter = booter;
        }

        public void handleNotification(Notification notif, Object handback) {
            JMXConnectionNotification n;
            if (notif instanceof JMXConnectionNotification && (n = (JMXConnectionNotification)notif).getType().equals("jmx.remote.connection.opened")) {
                Util.getLogger().info("ConnectorStartupService.BootAMXListener: connection made, booting AMX MBeans");
                this.mBooter.bootAMX();
                try {
                    this.mServer.removeNotificationListener(this);
                    Util.getLogger().fine("ConnectorStartupService.BootAMXListener: AMX is booted, stopped listening");
                }
                catch (ListenerNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final class ShutdownListener
    implements EventListener {
        private ShutdownListener() {
        }

        public void event(EventListener.Event event) {
            if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                JMXStartupService.this.shutdown();
            }
        }
    }
}

