/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.FileObject;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnitReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

public class PersistenceUnit {
    protected List<XMLEntityMappings> m_xmlEntityMappings;
    protected MetadataProject m_project;
    protected MetadataMirrorFactory m_factory;
    protected ProcessingEnvironment m_processingEnv;
    protected SEPersistenceUnitInfo m_puInfo;

    public PersistenceUnit(SEPersistenceUnitInfo puInfo, MetadataMirrorFactory factory) throws IOException {
        this.m_puInfo = puInfo;
        this.m_processingEnv = factory.getProcessingEnvironment();
        this.m_xmlEntityMappings = new ArrayList<XMLEntityMappings>();
        this.m_factory = factory;
        this.m_project = new MetadataProject(this.m_puInfo, (AbstractSession)new ServerSession(new Project(new DatabaseLogin())), false, false);
        this.initXMLEntityMappings();
    }

    public void addEntityAccessor(Element element) {
        String elementString = element.toString();
        if (!this.m_project.hasEntity(elementString) && !this.excludeUnlistedClasses()) {
            MetadataClass entityClass = this.m_factory.getMetadataClass(element);
            EntityAccessor entityAccessor = new EntityAccessor(entityClass.getAnnotation(Entity.class), entityClass, this.m_project);
            this.m_project.addEntityAccessor(entityAccessor);
        }
    }

    public void addMappedSuperclassAccessor(Element element) {
        String elementString = element.toString();
        if (!this.m_project.hasMappedSuperclass(elementString) && !this.excludeUnlistedClasses()) {
            MetadataClass mappedSuperclassClass = this.m_factory.getMetadataClass(element);
            MappedSuperclassAccessor mappedSuperclassAccessor = new MappedSuperclassAccessor(mappedSuperclassClass.getAnnotation(MappedSuperclass.class), mappedSuperclassClass, this.m_project);
            this.m_project.addMappedSuperclass(element.toString(), mappedSuperclassAccessor);
        }
    }

    public void addEmbeddableAccessor(Element element) {
        String elementString = element.toString();
        if (!this.m_project.hasEmbeddable(elementString) && !this.excludeUnlistedClasses()) {
            MetadataClass embeddableClass = this.m_factory.getMetadataClass(element);
            EmbeddableAccessor embeddableAccessor = new EmbeddableAccessor(embeddableClass.getAnnotation(Embeddable.class), embeddableClass, this.m_project);
            this.m_project.addEmbeddableAccessor(embeddableAccessor);
        }
    }

    protected void addXMLEntityMappings(FileObject fileObject, XMLContext context) throws IOException {
        InputStream in = null;
        try {
            in = fileObject.openInputStream();
            XMLEntityMappings xmlEntityMappings = (XMLEntityMappings)XMLEntityMappingsReader.getEclipseLinkOrmProject().createUnmarshaller().unmarshal(in);
            this.m_xmlEntityMappings.add(xmlEntityMappings);
        }
        catch (XMLMarshalException e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected void addXMLEntityMappings(String mappingFile, boolean validate) throws IOException {
        FileObject fileObject = PersistenceUnitReader.getFileObject(mappingFile, this.m_processingEnv);
        if (fileObject != null) {
            try {
                this.addXMLEntityMappings(fileObject, XMLEntityMappingsReader.getEclipseLinkOrmProject());
            }
            catch (XMLMarshalException e) {
                try {
                    this.addXMLEntityMappings(fileObject, XMLEntityMappingsReader.getOrm2Project());
                }
                catch (XMLMarshalException ee) {
                    this.addXMLEntityMappings(fileObject, XMLEntityMappingsReader.getOrm1Project());
                }
            }
        }
    }

    public boolean containsElement(Element element) {
        String elementString = element.toString();
        if (this.m_project.hasEntity(elementString)) {
            return true;
        }
        if (this.m_project.hasEmbeddable(elementString)) {
            return true;
        }
        return this.m_project.hasMappedSuperclass(elementString);
    }

    public ClassAccessor getClassAccessor(Element element) {
        String elementString = element.toString();
        if (this.m_project.hasEntity(elementString)) {
            return this.m_project.getEntityAccessor(elementString);
        }
        if (this.m_project.hasEmbeddable(elementString)) {
            return this.m_project.getEmbeddableAccessor(elementString);
        }
        if (this.m_project.hasMappedSuperclass(elementString)) {
            return this.m_project.getMappedSuperclass(elementString);
        }
        return null;
    }

    protected boolean excludeUnlistedClasses() {
        return this.m_puInfo.excludeUnlistedClasses();
    }

    protected void initXMLEntityMappings() throws IOException {
        this.addXMLEntityMappings("META-INF/orm.xml", false);
        for (String mappingFile : this.m_puInfo.getMappingFileNames()) {
            if (mappingFile.equals("META-INF/orm.xml")) continue;
            this.addXMLEntityMappings(mappingFile, true);
        }
        for (XMLEntityMappings entityMappings : this.m_xmlEntityMappings) {
            entityMappings.setLoader(this.m_factory.getLoader());
            entityMappings.setProject(this.m_project);
            entityMappings.setMetadataFactory(this.m_factory);
            entityMappings.processPersistenceUnitMetadata();
        }
        HashMap<String, EntityAccessor> entities = new HashMap<String, EntityAccessor>();
        HashMap<String, EmbeddableAccessor> embeddables = new HashMap<String, EmbeddableAccessor>();
        for (XMLEntityMappings entityMappings : this.m_xmlEntityMappings) {
            entityMappings.initPersistenceUnitClasses(entities, embeddables);
        }
        for (EntityAccessor entity : entities.values()) {
            this.m_project.addEntityAccessor(entity);
            entity.getEntityMappings().processEntityMappingsDefaults(entity);
        }
        for (EmbeddableAccessor embeddable : embeddables.values()) {
            this.m_project.addEmbeddableAccessor(embeddable);
            embeddable.getEntityMappings().processEntityMappingsDefaults(embeddable);
        }
    }

    public void preProcessForCanonicalModel() {
        for (EntityAccessor entityAccessor : this.m_project.getEntityAccessors()) {
            if (!this.shouldPreProcess(entityAccessor)) continue;
            entityAccessor.preProcessForCanonicalModel();
        }
        for (MappedSuperclassAccessor mappedSuperclassAccessor : this.m_project.getMappedSuperclasses()) {
            if (!this.shouldPreProcess(mappedSuperclassAccessor)) continue;
            mappedSuperclassAccessor.preProcessForCanonicalModel();
        }
        for (EmbeddableAccessor embeddableAccessor : this.m_project.getRootEmbeddableAccessors()) {
            if (!this.shouldPreProcess(embeddableAccessor)) continue;
            embeddableAccessor.preProcessForCanonicalModel();
        }
        for (EmbeddableAccessor embeddableAccessor : this.m_project.getEmbeddableAccessors()) {
            if (!this.shouldPreProcess(embeddableAccessor)) continue;
            embeddableAccessor.setOwningDescriptor(embeddableAccessor.getOwningDescriptor());
            embeddableAccessor.preProcessForCanonicalModel();
        }
    }

    protected boolean shouldPreProcess(ClassAccessor accessor) {
        return !accessor.isPreProcessed() && this.m_factory.isRoundElement((MetadataClass)accessor.getAccessibleObject());
    }

    public String toString() {
        return this.m_puInfo.getPersistenceUnitName();
    }
}

