/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.monitor.config;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.api.monitoring.MonitoringItem;
import org.glassfish.jdbc.admin.monitor.config.JdbcConnectionPoolMI;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class JdbcConnectionPoolConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    MonitoringService ms;
    private String level = "OFF";
    private String name = "jdbc-connection-pool";

    public void postConstruct() {
        try {
            MonitoringItem mi;
            if (this.ms == null) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Failure while upgrading domain.xml, monitoring-service does not exist in domain.xml");
                return;
            }
            ModuleMonitoringLevels mmls = this.ms.getModuleMonitoringLevels();
            if (mmls != null) {
                this.level = mmls.getJdbcConnectionPool();
            }
            if ((mi = this.getMonitoringItem(this.ms)) != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringItem>(){

                    public Object run(MonitoringItem param) throws PropertyVetoException, TransactionFailure {
                        param.setLevel(JdbcConnectionPoolConfigUpgrade.this.level);
                        return param;
                    }
                }, (ConfigBeanProxy)mi);
            } else {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                    public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                        MonitoringItem newItem = (MonitoringItem)param.createChild(JdbcConnectionPoolMI.class);
                        newItem.setName(JdbcConnectionPoolConfigUpgrade.this.name);
                        newItem.setLevel(JdbcConnectionPoolConfigUpgrade.this.level);
                        param.getMonitoringItems().add(newItem);
                        return newItem;
                    }
                }, (ConfigBeanProxy)this.ms);
            }
        }
        catch (TransactionFailure tf) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading domain.xml monitoring-service", tf);
            throw new RuntimeException(tf);
        }
    }

    private MonitoringItem getMonitoringItem(MonitoringService ms) {
        for (MonitoringItem mi : ms.getMonitoringItems()) {
            if (!mi.getName().equals(this.name)) continue;
            return mi;
        }
        return null;
    }
}

