/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTable
implements Cloneable,
Serializable {
    protected String name;
    protected String tableQualifier;
    protected String qualifiedName;
    protected Vector<List<String>> uniqueConstraints;
    protected boolean useDelimiters = false;

    public DatabaseTable() {
        this.name = "";
        this.tableQualifier = "";
        this.uniqueConstraints = new Vector();
    }

    public DatabaseTable(String possiblyQualifiedName) {
        this.setPossiblyQualifiedName(possiblyQualifiedName);
        this.uniqueConstraints = new Vector();
    }

    public DatabaseTable(String tableName, String qualifier) {
        this.setName(tableName);
        this.tableQualifier = qualifier;
        this.uniqueConstraints = new Vector();
    }

    public DatabaseTable(String tableName, String qualifier, boolean useDelimiters) {
        this(tableName, qualifier);
        this.useDelimiters = useDelimiters;
    }

    public void addUniqueConstraints(List<String> columnNames) {
        this.uniqueConstraints.add(columnNames);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseTable) {
            return this.equals((DatabaseTable)object);
        }
        return false;
    }

    public boolean equals(DatabaseTable table) {
        if (this == table) {
            return true;
        }
        return DatabasePlatform.shouldIgnoreCaseOnFieldComparisons() ? this.getName().equalsIgnoreCase(table.getName()) && (this.getTableQualifier().length() == 0 || table.getTableQualifier().length() == 0 || this.getTableQualifier().equalsIgnoreCase(table.getTableQualifier())) : this.getName().equals(table.getName()) && (this.getTableQualifier().length() == 0 || table.getTableQualifier().length() == 0 || this.getTableQualifier().equals(table.getTableQualifier()));
    }

    public String getName() {
        return this.name;
    }

    public String getNameDelimited() {
        if (this.useDelimiters) {
            return Helper.getStartDatabaseDelimiter() + this.name + Helper.getEndDatabaseDelimiter();
        }
        return this.name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.tableQualifier.equals("") ? this.getName() : this.getTableQualifier() + "." + this.getName();
        }
        return this.qualifiedName;
    }

    public String getQualifiedNameDelimited() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.tableQualifier.equals("") ? (this.useDelimiters ? Helper.getStartDatabaseDelimiter() + this.getName() + Helper.getEndDatabaseDelimiter() : this.getName()) : (this.useDelimiters ? Helper.getStartDatabaseDelimiter() + this.getTableQualifier() + Helper.getEndDatabaseDelimiter() + "." + Helper.getStartDatabaseDelimiter() + this.getName() + Helper.getEndDatabaseDelimiter() : this.getTableQualifier() + "." + this.getName());
        }
        return this.qualifiedName;
    }

    public String getTableQualifier() {
        if (this.useDelimiters && this.tableQualifier != null && !this.tableQualifier.equals("")) {
            return Helper.getStartDatabaseDelimiter() + this.tableQualifier + Helper.getEndDatabaseDelimiter();
        }
        return this.tableQualifier;
    }

    public Vector<List<String>> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean hasName() {
        return this.getName().length() != 0 || this.getTableQualifier().length() != 0;
    }

    public boolean isDecorated() {
        return false;
    }

    protected void resetQualifiedName() {
        this.qualifiedName = null;
    }

    public void setName(String name) {
        if (name != null && name.startsWith(Helper.getStartDatabaseDelimiter()) && name.endsWith(Helper.getEndDatabaseDelimiter())) {
            this.name = name.substring(1, name.length() - 1);
            this.useDelimiters = true;
        } else {
            this.name = name;
        }
        this.resetQualifiedName();
    }

    public void setPossiblyQualifiedName(String possiblyQualifiedName) {
        this.resetQualifiedName();
        int index = possiblyQualifiedName.lastIndexOf(46);
        if (index == -1) {
            this.setName(possiblyQualifiedName);
            this.tableQualifier = "";
        } else {
            this.setName(possiblyQualifiedName.substring(index + 1, possiblyQualifiedName.length()));
            this.setTableQualifier(possiblyQualifiedName.substring(0, index));
            if (possiblyQualifiedName.startsWith(Helper.getStartDatabaseDelimiter()) && possiblyQualifiedName.endsWith(Helper.getEndDatabaseDelimiter()) && !this.useDelimiters) {
                this.setName(possiblyQualifiedName);
                this.tableQualifier = "";
            }
        }
    }

    public void setTableQualifier(String qualifier) {
        if (qualifier.startsWith(Helper.getStartDatabaseDelimiter()) && qualifier.endsWith(Helper.getEndDatabaseDelimiter())) {
            this.tableQualifier = qualifier.substring(1, qualifier.length() - 1);
            this.useDelimiters = true;
        } else {
            this.tableQualifier = qualifier;
        }
        this.resetQualifiedName();
    }

    public String toString() {
        return "DatabaseTable(" + this.getQualifiedName() + ")";
    }

    public void setUseDelimiters(boolean useDelimiters) {
        this.useDelimiters = useDelimiters;
    }

    public boolean shouldUseDelimiters() {
        return this.useDelimiters;
    }
}

