/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import javax.persistence.Transient;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassAdapter;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Constants;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.attrs.Annotation;
import org.eclipse.persistence.internal.libraries.asm.attrs.RuntimeVisibleAnnotations;
import org.eclipse.persistence.internal.libraries.asm.commons.SerialVersionUIDAdder;
import org.eclipse.persistence.internal.weaving.AttributeDetails;
import org.eclipse.persistence.internal.weaving.ClassDetails;
import org.eclipse.persistence.internal.weaving.MethodWeaver;

public class ClassWeaver
extends ClassAdapter
implements Constants {
    public static final String PERSISTENCE_WEAVED_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeaved";
    public static final String TW_LAZY_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedLazy";
    public static final String VHI_CLASSNAME = "org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface";
    public static final String VH_SHORT_SIGNATURE = "org/eclipse/persistence/indirection/ValueHolder";
    public static final String VHI_SHORT_SIGNATURE = "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface";
    public static final String VHI_SIGNATURE = "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;";
    public static final String TW_CT_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedChangeTracking";
    public static final String PCL_SHORT_SIGNATURE = "java/beans/PropertyChangeListener";
    public static final String PCL_SIGNATURE = "Ljava/beans/PropertyChangeListener;";
    public static final String CT_SHORT_SIGNATURE = "org/eclipse/persistence/descriptors/changetracking/ChangeTracker";
    public static final String PCE_SHORT_SIGNATURE = "java/beans/PropertyChangeEvent";
    public static final String PCE_SIGNATURE = "Ljava/beans/PropertyChangeEvent;";
    public static final String PERSISTENCE_ENTITY_SHORT_SIGNATURE = "org/eclipse/persistence/internal/descriptors/PersistenceEntity";
    public static final String PERSISTENCE_OBJECT_SHORT_SIGNATURE = "org/eclipse/persistence/internal/descriptors/PersistenceObject";
    public static final String PERSISTENCE_OBJECT_SIGNATURE = "Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;";
    public static final String VECTOR_SIGNATURE = "Ljava/util/Vector;";
    public static final String CACHEKEY_SIGNATURE = "Lorg/eclipse/persistence/internal/identitymaps/CacheKey;";
    public static final String WEAVED_FETCHGROUPS_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedFetchGroups";
    public static final String FETCHGROUP_TRACKER_SHORT_SIGNATURE = "org/eclipse/persistence/queries/FetchGroupTracker";
    public static final String FETCHGROUP_SHORT_SIGNATURE = "org/eclipse/persistence/queries/FetchGroup";
    public static final String FETCHGROUP_SIGNATURE = "Lorg/eclipse/persistence/queries/FetchGroup;";
    public static final String SESSION_SIGNATURE = "Lorg/eclipse/persistence/sessions/Session;";
    public static final String PBOOLEAN_SIGNATURE = "Z";
    public static final String LONG_SIGNATURE = "J";
    public static final String CLONEABLE_SHORT_SIGNATURE = "java/lang/Cloneable";
    protected static Boolean isJAXBOnPath;
    protected ClassDetails classDetails;
    protected SerialVersionUIDAdder uuidGenerator;
    protected boolean alreadyWeaved = false;
    public boolean weaved = false;
    public boolean weavedLazy = false;
    public boolean weavedPersistenceEntity = false;
    public boolean weavedChangeTracker = false;
    public boolean weavedFetchGroups = false;

    public static String wrapperFor(int sort) {
        switch (sort) {
            case 1: {
                return "java/lang/Boolean";
            }
            case 3: {
                return "java/lang/Byte";
            }
            case 2: {
                return "java/lang/Character";
            }
            case 4: {
                return "java/lang/Short";
            }
            case 5: {
                return "java/lang/Integer";
            }
            case 6: {
                return "java/lang/Float";
            }
            case 7: {
                return "java/lang/Long";
            }
            case 8: {
                return "java/lang/Double";
            }
        }
        return null;
    }

    public static void unwrapPrimitive(AttributeDetails attribute, CodeVisitor visitor) {
        String wrapper = ClassWeaver.wrapperFor(attribute.getReferenceClassType().getSort());
        switch (attribute.getReferenceClassType().getSort()) {
            case 1: {
                visitor.visitMethodInsn(182, wrapper, "booleanValue", "()Z");
                return;
            }
            case 3: {
                visitor.visitMethodInsn(182, wrapper, "byteValue", "()B");
                return;
            }
            case 2: {
                visitor.visitMethodInsn(182, wrapper, "charValue", "()C");
                return;
            }
            case 4: {
                visitor.visitMethodInsn(182, wrapper, "shortValue", "()S");
                return;
            }
            case 5: {
                visitor.visitMethodInsn(182, wrapper, "intValue", "()I");
                return;
            }
            case 6: {
                visitor.visitMethodInsn(182, wrapper, "floatValue", "()F");
                return;
            }
            case 7: {
                visitor.visitMethodInsn(182, wrapper, "longValue", "()J");
                return;
            }
            case 8: {
                visitor.visitMethodInsn(182, wrapper, "doubleValue", "()D");
                return;
            }
        }
    }

    public static String getWeavedValueHolderGetMethodName(String attributeName) {
        return "_persistence_get" + attributeName + "_vh";
    }

    public static String getWeavedValueHolderSetMethodName(String attributeName) {
        return "_persistence_set" + attributeName + "_vh";
    }

    public static boolean isJAXBOnPath() {
        isJAXBOnPath = true;
        if (isJAXBOnPath == null) {
            try {
                Class.forName("javax.xml.bind.annotation.XmlTransient");
            }
            catch (Exception notThere) {
                isJAXBOnPath = false;
            }
        }
        return isJAXBOnPath;
    }

    public ClassWeaver(ClassWriter classWriter, ClassDetails classDetails) {
        super((ClassVisitor)classWriter);
        this.classDetails = classDetails;
        this.uuidGenerator = new SerialVersionUIDAdder((ClassVisitor)classWriter);
    }

    public void addValueHolder(AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        RuntimeVisibleAnnotations annotations = null;
        if (attributeDetails.getGetterMethodName() == null || attributeDetails.getGetterMethodName().equals("") || attributeDetails.weaveTransientFieldValueHolders()) {
            annotations = this.getTransientAnnotation();
        }
        this.cv.visitField(4, "_persistence_" + attribute + "_vh", VHI_SIGNATURE, null, (Attribute)annotations);
    }

    public void addPropertyChangeListener(boolean attributeAccess) {
        this.cv.visitField(132, "_persistence_listener", PCL_SIGNATURE, null, null);
    }

    public void addGetPropertyChangeListener(ClassDetails classDetails) {
        CodeVisitor cv_getPCL = this.cv.visitMethod(1, "_persistence_getPropertyChangeListener", "()Ljava/beans/PropertyChangeListener;", null, null);
        cv_getPCL.visitVarInsn(25, 0);
        cv_getPCL.visitFieldInsn(180, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_getPCL.visitInsn(176);
        cv_getPCL.visitMaxs(0, 0);
    }

    public void addSetPropertyChangeListener(ClassDetails classDetails) {
        Attribute annotations = null;
        CodeVisitor cv_setPCL = this.cv.visitMethod(1, "_persistence_setPropertyChangeListener", "(Ljava/beans/PropertyChangeListener;)V", null, annotations);
        cv_setPCL.visitVarInsn(25, 0);
        cv_setPCL.visitVarInsn(25, 1);
        cv_setPCL.visitFieldInsn(181, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_setPCL.visitInsn(177);
        cv_setPCL.visitMaxs(0, 0);
    }

    public void addPropertyChange(ClassDetails classDetails) {
        CodeVisitor cv_addPC = this.cv.visitMethod(1, "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        cv_addPC.visitVarInsn(25, 0);
        cv_addPC.visitFieldInsn(180, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        Label l0 = new Label();
        cv_addPC.visitJumpInsn(198, l0);
        cv_addPC.visitVarInsn(25, 2);
        cv_addPC.visitVarInsn(25, 3);
        cv_addPC.visitJumpInsn(165, l0);
        cv_addPC.visitVarInsn(25, 0);
        cv_addPC.visitFieldInsn(180, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_addPC.visitTypeInsn(187, PCE_SHORT_SIGNATURE);
        cv_addPC.visitInsn(89);
        cv_addPC.visitVarInsn(25, 0);
        cv_addPC.visitVarInsn(25, 1);
        cv_addPC.visitVarInsn(25, 2);
        cv_addPC.visitVarInsn(25, 3);
        cv_addPC.visitMethodInsn(183, PCE_SHORT_SIGNATURE, "<init>", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V");
        cv_addPC.visitMethodInsn(185, PCL_SHORT_SIGNATURE, "propertyChange", "(Ljava/beans/PropertyChangeEvent;)V");
        cv_addPC.visitLabel(l0);
        cv_addPC.visitInsn(177);
        cv_addPC.visitMaxs(0, 0);
    }

    public void addInitializerForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        CodeVisitor cv_init_VH = this.cv.visitMethod(4, "_persistence_initialize_" + attribute + "_vh", "()V", null, null);
        cv_init_VH.visitVarInsn(25, 0);
        cv_init_VH.visitFieldInsn(180, className, "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
        Label l0 = new Label();
        cv_init_VH.visitJumpInsn(199, l0);
        cv_init_VH.visitVarInsn(25, 0);
        cv_init_VH.visitTypeInsn(187, VH_SHORT_SIGNATURE);
        cv_init_VH.visitInsn(89);
        if (attributeDetails.hasField()) {
            cv_init_VH.visitVarInsn(25, 0);
            cv_init_VH.visitFieldInsn(180, className, attribute, attributeDetails.getReferenceClassType().getDescriptor());
            cv_init_VH.visitMethodInsn(183, VH_SHORT_SIGNATURE, "<init>", "(Ljava/lang/Object;)V");
        } else {
            cv_init_VH.visitMethodInsn(183, VH_SHORT_SIGNATURE, "<init>", "()V");
        }
        cv_init_VH.visitFieldInsn(181, className, "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
        cv_init_VH.visitVarInsn(25, 0);
        cv_init_VH.visitFieldInsn(180, className, "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
        cv_init_VH.visitInsn(4);
        cv_init_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "setIsNewlyWeavedValueHolder", "(Z)V");
        cv_init_VH.visitLabel(l0);
        cv_init_VH.visitInsn(177);
        cv_init_VH.visitMaxs(0, 0);
    }

    public void addGetterMethodForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        CodeVisitor cv_get_VH = this.cv.visitMethod(1, "_persistence_get" + attribute + "_vh", "()Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;", null, null);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + "_vh", "()V");
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isCoordinatedWithProperty", "()Z");
        Label l0 = new Label();
        cv_get_VH.visitJumpInsn(154, l0);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isNewlyWeavedValueHolder", "()Z");
        Label l1 = new Label();
        cv_get_VH.visitJumpInsn(153, l1);
        cv_get_VH.visitLabel(l0);
        cv_get_VH.visitVarInsn(25, 0);
        if (attributeDetails.getGetterMethodName() != null) {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), attributeDetails.getGetterMethodName(), "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";");
            cv_get_VH.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
        } else {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), "_persistence_get" + attributeDetails.attributeName, "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";");
        }
        cv_get_VH.visitVarInsn(58, 1);
        cv_get_VH.visitVarInsn(25, 1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;");
        cv_get_VH.visitJumpInsn(165, l1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitVarInsn(25, 1);
        if (attributeDetails.getSetterMethodName() != null) {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V");
        } else {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), "_persistence_set" + attributeDetails.getAttributeName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V");
        }
        cv_get_VH.visitLabel(l1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, className, "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
        cv_get_VH.visitInsn(176);
        cv_get_VH.visitMaxs(0, 0);
    }

    public void addSetterMethodForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        CodeVisitor cv_set_value = this.cv.visitMethod(1, "_persistence_set" + attribute + "_vh", "(Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;)V", null, null);
        cv_set_value.visitVarInsn(25, 0);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitFieldInsn(181, className, "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isInstantiated", "()Z");
        Label l0 = new Label();
        cv_set_value.visitJumpInsn(153, l0);
        cv_set_value.visitVarInsn(25, 0);
        if (attributeDetails.getGetterMethodName() != null) {
            cv_set_value.visitMethodInsn(182, className, attributeDetails.getGetterMethodName(), "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";");
        } else {
            cv_set_value.visitMethodInsn(182, className, "_persistence_get" + attributeDetails.attributeName, "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";");
        }
        cv_set_value.visitVarInsn(58, 2);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;");
        cv_set_value.visitVarInsn(58, 3);
        cv_set_value.visitVarInsn(25, 2);
        cv_set_value.visitVarInsn(25, 3);
        cv_set_value.visitJumpInsn(165, l0);
        cv_set_value.visitVarInsn(25, 0);
        cv_set_value.visitVarInsn(25, 3);
        cv_set_value.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
        if (attributeDetails.getSetterMethodName() != null) {
            cv_set_value.visitMethodInsn(182, className, attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V");
        } else {
            cv_set_value.visitMethodInsn(182, className, "_persistence_set" + attributeDetails.getAttributeName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V");
        }
        cv_set_value.visitLabel(l0);
        cv_set_value.visitInsn(177);
        cv_set_value.visitMaxs(0, 0);
    }

    public void addSetterMethodForFieldAccess(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        CodeVisitor cv_set = this.cv.visitMethod(1, "_persistence_set" + attribute, "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", null, null);
        int opcode = attributeDetails.getReferenceClassType().getOpcode(21);
        cv_set.visitVarInsn(25, 0);
        cv_set.visitMethodInsn(182, classDetails.getClassName(), "_persistence_get" + attribute, "()" + attributeDetails.getReferenceClassType().getDescriptor());
        if (classDetails.shouldWeaveChangeTracking()) {
            cv_set.visitVarInsn(25, 0);
            cv_set.visitLdcInsn((Object)attribute);
            String wrapper = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
            if (wrapper != null) {
                cv_set.visitTypeInsn(187, wrapper);
                cv_set.visitInsn(89);
            }
            cv_set.visitVarInsn(25, 0);
            cv_set.visitFieldInsn(180, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
            if (wrapper != null) {
                cv_set.visitMethodInsn(183, wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
                cv_set.visitTypeInsn(187, wrapper);
                cv_set.visitInsn(89);
                cv_set.visitVarInsn(opcode, 1);
                cv_set.visitMethodInsn(183, wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
            } else {
                cv_set.visitVarInsn(25, 1);
            }
            cv_set.visitMethodInsn(182, classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V");
        }
        cv_set.visitVarInsn(25, 0);
        cv_set.visitVarInsn(opcode, 1);
        cv_set.visitFieldInsn(181, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        if (attributeDetails.weaveValueHolders()) {
            cv_set.visitVarInsn(25, 0);
            cv_set.visitFieldInsn(180, classDetails.getClassName(), "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
            cv_set.visitVarInsn(25, 1);
            cv_set.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "setValue", "(Ljava/lang/Object;)V");
        }
        cv_set.visitInsn(177);
        cv_set.visitMaxs(0, 0);
    }

    public void addGetterMethodForFieldAccess(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        CodeVisitor cv_get = this.cv.visitMethod(1, "_persistence_get" + attribute, "()" + attributeDetails.getReferenceClassType().getDescriptor(), null, null);
        if (classDetails.shouldWeaveFetchGroups()) {
            cv_get.visitVarInsn(25, 0);
            cv_get.visitLdcInsn((Object)attribute);
            cv_get.visitMethodInsn(182, classDetails.getClassName(), "_persistence_checkFetched", "(Ljava/lang/String;)V");
        }
        if (attributeDetails.weaveValueHolders()) {
            cv_get.visitVarInsn(25, 0);
            cv_get.visitMethodInsn(182, classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + "_vh", "()V");
            cv_get.visitVarInsn(25, 0);
            cv_get.visitVarInsn(25, 0);
            cv_get.visitFieldInsn(180, classDetails.getClassName(), "_persistence_" + attribute + "_vh", VHI_SIGNATURE);
            cv_get.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;");
            cv_get.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_get.visitFieldInsn(181, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        }
        cv_get.visitVarInsn(25, 0);
        cv_get.visitFieldInsn(180, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        int opcode = attributeDetails.getReferenceClassType().getOpcode(172);
        cv_get.visitInsn(opcode);
        cv_get.visitMaxs(0, 0);
    }

    public void addPersistenceEntityVariables() {
        this.cv.visitField(132, "_persistence_primaryKey", VECTOR_SIGNATURE, null, null);
        this.cv.visitField(132, "_persistence_cacheKey", CACHEKEY_SIGNATURE, null, null);
    }

    public void addPersistencePostClone(ClassDetails classDetails) {
        CodeVisitor cv_clone = this.cv.visitMethod(1, "_persistence_post_clone", "()Ljava/lang/Object;", null, null);
        if (classDetails.getSuperClassDetails() != null && classDetails.getSuperClassDetails().shouldWeaveInternal()) {
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitMethodInsn(183, classDetails.getSuperClassName(), "_persistence_post_clone", "()Ljava/lang/Object;");
        }
        if (classDetails.shouldWeaveValueHolders()) {
            for (AttributeDetails attributeDetails : classDetails.getAttributesMap().values()) {
                if (!attributeDetails.weaveValueHolders()) continue;
                cv_clone.visitVarInsn(25, 0);
                cv_clone.visitFieldInsn(180, classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", VHI_SIGNATURE);
                Label label = new Label();
                cv_clone.visitJumpInsn(198, label);
                cv_clone.visitVarInsn(25, 0);
                cv_clone.visitVarInsn(25, 0);
                cv_clone.visitFieldInsn(180, classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", VHI_SIGNATURE);
                cv_clone.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "clone", "()Ljava/lang/Object;");
                cv_clone.visitTypeInsn(192, VHI_SHORT_SIGNATURE);
                cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", VHI_SIGNATURE);
                cv_clone.visitLabel(label);
            }
        }
        if (classDetails.shouldWeaveChangeTracking()) {
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        }
        if (classDetails.shouldWeaveFetchGroups()) {
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        }
        if (!classDetails.isEmbedable()) {
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_primaryKey", VECTOR_SIGNATURE);
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_cacheKey", CACHEKEY_SIGNATURE);
        }
        cv_clone.visitVarInsn(25, 0);
        cv_clone.visitInsn(176);
        cv_clone.visitMaxs(0, 0);
    }

    public void addShallowClone(ClassDetails classDetails) {
        CodeVisitor cv_clone = this.cv.visitMethod(1, "_persistence_shallow_clone", "()Ljava/lang/Object;", null, null);
        cv_clone.visitVarInsn(25, 0);
        cv_clone.visitMethodInsn(183, "java/lang/Object", "clone", "()Ljava/lang/Object;");
        cv_clone.visitInsn(176);
        cv_clone.visitMaxs(0, 0);
    }

    public void addPersistenceNew(ClassDetails classDetails) {
        CodeVisitor cv_new = this.cv.visitMethod(1, "_persistence_new", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)Ljava/lang/Object;", null, null);
        cv_new.visitTypeInsn(187, classDetails.getClassName());
        cv_new.visitInsn(89);
        cv_new.visitVarInsn(25, 1);
        cv_new.visitMethodInsn(183, classDetails.getClassName(), "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V");
        cv_new.visitInsn(176);
        cv_new.visitMaxs(0, 0);
        CodeVisitor cv_constructor = this.cv.visitMethod(1, "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V", null, null);
        cv_constructor.visitVarInsn(25, 0);
        if (classDetails.getSuperClassDetails() == null) {
            cv_constructor.visitMethodInsn(183, classDetails.getSuperClassName(), "<init>", "()V");
        } else {
            cv_constructor.visitVarInsn(25, 1);
            cv_constructor.visitMethodInsn(183, classDetails.getSuperClassName(), "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V");
        }
        cv_constructor.visitInsn(177);
        cv_constructor.visitMaxs(0, 0);
    }

    public void addPersistenceGetSet(ClassDetails classDetails) {
        CodeVisitor cv_get = this.cv.visitMethod(1, "_persistence_get", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
        Label label = null;
        for (AttributeDetails attributeDetails : classDetails.getAttributesMap().values()) {
            if (attributeDetails.isAttributeOnSuperClass()) continue;
            if (label != null) {
                cv_get.visitLabel(label);
            }
            cv_get.visitVarInsn(25, 1);
            cv_get.visitLdcInsn((Object)attributeDetails.getAttributeName().intern());
            label = new Label();
            cv_get.visitJumpInsn(166, label);
            cv_get.visitVarInsn(25, 0);
            cv_get.visitFieldInsn(180, classDetails.getClassName(), attributeDetails.getAttributeName(), attributeDetails.getReferenceClassType().getDescriptor());
            String wrapper = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
            if (wrapper != null) {
                cv_get.visitMethodInsn(184, wrapper, "valueOf", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")L" + wrapper + ";");
            }
            cv_get.visitInsn(176);
        }
        if (label != null) {
            cv_get.visitLabel(label);
        }
        if (classDetails.getSuperClassDetails() == null) {
            cv_get.visitInsn(1);
        } else {
            cv_get.visitVarInsn(25, 0);
            cv_get.visitVarInsn(25, 1);
            cv_get.visitMethodInsn(183, classDetails.getSuperClassName(), "_persistence_get", "(Ljava/lang/String;)Ljava/lang/Object;");
        }
        cv_get.visitInsn(176);
        cv_get.visitMaxs(0, 0);
        CodeVisitor cv_set = this.cv.visitMethod(1, "_persistence_set", "(Ljava/lang/String;Ljava/lang/Object;)V", null, null);
        label = null;
        for (AttributeDetails attribute : classDetails.getAttributesMap().values()) {
            if (attribute.isAttributeOnSuperClass()) continue;
            if (label != null) {
                cv_set.visitLabel(label);
            }
            cv_set.visitVarInsn(25, 1);
            cv_set.visitLdcInsn((Object)attribute.getAttributeName().intern());
            label = new Label();
            cv_set.visitJumpInsn(166, label);
            cv_set.visitVarInsn(25, 0);
            cv_set.visitVarInsn(25, 2);
            String wrapper = ClassWeaver.wrapperFor(attribute.getReferenceClassType().getSort());
            if (wrapper == null) {
                wrapper = attribute.getReferenceClassName().replace('.', '/');
            }
            cv_set.visitTypeInsn(192, wrapper);
            ClassWeaver.unwrapPrimitive(attribute, cv_set);
            cv_set.visitFieldInsn(181, classDetails.getClassName(), attribute.getAttributeName(), attribute.getReferenceClassType().getDescriptor());
            cv_set.visitInsn(177);
        }
        if (label != null) {
            cv_set.visitLabel(label);
        }
        if (classDetails.getSuperClassDetails() != null) {
            cv_set.visitVarInsn(25, 0);
            cv_set.visitVarInsn(25, 1);
            cv_set.visitVarInsn(25, 2);
            cv_set.visitMethodInsn(183, classDetails.getSuperClassName(), "_persistence_set", "(Ljava/lang/String;Ljava/lang/Object;)V");
        }
        cv_set.visitInsn(177);
        cv_set.visitMaxs(0, 0);
    }

    public void addPersistenceEntityMethods(ClassDetails classDetails) {
        CodeVisitor cv_getCacheKey = this.cv.visitMethod(1, "_persistence_getCacheKey", "()Lorg/eclipse/persistence/internal/identitymaps/CacheKey;", null, null);
        cv_getCacheKey.visitVarInsn(25, 0);
        cv_getCacheKey.visitFieldInsn(180, classDetails.getClassName(), "_persistence_cacheKey", CACHEKEY_SIGNATURE);
        cv_getCacheKey.visitInsn(176);
        cv_getCacheKey.visitMaxs(0, 0);
        CodeVisitor cv_setCacheKey = this.cv.visitMethod(1, "_persistence_setCacheKey", "(Lorg/eclipse/persistence/internal/identitymaps/CacheKey;)V", null, null);
        cv_setCacheKey.visitVarInsn(25, 0);
        cv_setCacheKey.visitVarInsn(25, 1);
        cv_setCacheKey.visitFieldInsn(181, classDetails.getClassName(), "_persistence_cacheKey", CACHEKEY_SIGNATURE);
        cv_setCacheKey.visitInsn(177);
        cv_setCacheKey.visitMaxs(0, 0);
        CodeVisitor cv_getPKVector = this.cv.visitMethod(1, "_persistence_getPKVector", "()Ljava/util/Vector;", null, null);
        cv_getPKVector.visitVarInsn(25, 0);
        cv_getPKVector.visitFieldInsn(180, classDetails.getClassName(), "_persistence_primaryKey", VECTOR_SIGNATURE);
        cv_getPKVector.visitInsn(176);
        cv_getPKVector.visitMaxs(0, 0);
        CodeVisitor cv_setPKVector = this.cv.visitMethod(1, "_persistence_setPKVector", "(Ljava/util/Vector;)V", null, null);
        cv_setPKVector.visitVarInsn(25, 0);
        cv_setPKVector.visitVarInsn(25, 1);
        cv_setPKVector.visitFieldInsn(181, classDetails.getClassName(), "_persistence_primaryKey", VECTOR_SIGNATURE);
        cv_setPKVector.visitInsn(177);
        cv_setPKVector.visitMaxs(0, 0);
    }

    public void addFetchGroupVariables() {
        this.cv.visitField(132, "_persistence_fetchGroup", FETCHGROUP_SIGNATURE, null, null);
        this.cv.visitField(132, "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE, null, null);
        this.cv.visitField(132, "_persistence_session", SESSION_SIGNATURE, null, null);
    }

    public void addFetchGroupMethods(ClassDetails classDetails) {
        CodeVisitor cv_getSession = this.cv.visitMethod(1, "_persistence_getSession", "()Lorg/eclipse/persistence/sessions/Session;", null, null);
        cv_getSession.visitVarInsn(25, 0);
        cv_getSession.visitFieldInsn(180, classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        cv_getSession.visitInsn(176);
        cv_getSession.visitMaxs(0, 0);
        CodeVisitor cv_setSession = this.cv.visitMethod(1, "_persistence_setSession", "(Lorg/eclipse/persistence/sessions/Session;)V", null, null);
        cv_setSession.visitVarInsn(25, 0);
        cv_setSession.visitVarInsn(25, 1);
        cv_setSession.visitFieldInsn(181, classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        cv_setSession.visitInsn(177);
        cv_setSession.visitMaxs(0, 0);
        CodeVisitor cv_getFetchGroup = this.cv.visitMethod(1, "_persistence_getFetchGroup", "()Lorg/eclipse/persistence/queries/FetchGroup;", null, null);
        cv_getFetchGroup.visitVarInsn(25, 0);
        cv_getFetchGroup.visitFieldInsn(180, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_getFetchGroup.visitInsn(176);
        cv_getFetchGroup.visitMaxs(0, 0);
        CodeVisitor cv_setFetchGroup = this.cv.visitMethod(1, "_persistence_setFetchGroup", "(Lorg/eclipse/persistence/queries/FetchGroup;)V", null, null);
        cv_setFetchGroup.visitVarInsn(25, 0);
        cv_setFetchGroup.visitVarInsn(25, 1);
        cv_setFetchGroup.visitFieldInsn(181, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_setFetchGroup.visitInsn(177);
        cv_setFetchGroup.visitMaxs(0, 0);
        CodeVisitor cv_shouldRefreshFetchGroup = this.cv.visitMethod(1, "_persistence_shouldRefreshFetchGroup", "()Z", null, null);
        cv_shouldRefreshFetchGroup.visitVarInsn(25, 0);
        cv_shouldRefreshFetchGroup.visitFieldInsn(180, classDetails.getClassName(), "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE);
        cv_shouldRefreshFetchGroup.visitInsn(172);
        cv_shouldRefreshFetchGroup.visitMaxs(0, 0);
        CodeVisitor cv_setShouldRefreshFetchGroup = this.cv.visitMethod(1, "_persistence_setShouldRefreshFetchGroup", "(Z)V", null, null);
        cv_setShouldRefreshFetchGroup.visitVarInsn(25, 0);
        cv_setShouldRefreshFetchGroup.visitVarInsn(21, 1);
        cv_setShouldRefreshFetchGroup.visitFieldInsn(181, classDetails.getClassName(), "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE);
        cv_setShouldRefreshFetchGroup.visitInsn(177);
        cv_setShouldRefreshFetchGroup.visitMaxs(0, 0);
        CodeVisitor cv_resetFetchGroup = this.cv.visitMethod(1, "_persistence_resetFetchGroup", "()V", null, null);
        cv_resetFetchGroup.visitInsn(177);
        cv_resetFetchGroup.visitMaxs(0, 0);
        CodeVisitor cv_isAttributeFetched = this.cv.visitMethod(1, "_persistence_isAttributeFetched", "(Ljava/lang/String;)Z", null, null);
        cv_isAttributeFetched.visitVarInsn(25, 0);
        cv_isAttributeFetched.visitFieldInsn(180, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        Label gotoTrue = new Label();
        cv_isAttributeFetched.visitJumpInsn(198, gotoTrue);
        cv_isAttributeFetched.visitVarInsn(25, 0);
        cv_isAttributeFetched.visitFieldInsn(180, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_isAttributeFetched.visitVarInsn(25, 1);
        cv_isAttributeFetched.visitMethodInsn(182, FETCHGROUP_SHORT_SIGNATURE, "containsAttribute", "(Ljava/lang/String;)Z");
        Label gotoFalse = new Label();
        cv_isAttributeFetched.visitJumpInsn(153, gotoFalse);
        cv_isAttributeFetched.visitLabel(gotoTrue);
        cv_isAttributeFetched.visitInsn(4);
        Label gotoReturn = new Label();
        cv_isAttributeFetched.visitJumpInsn(167, gotoReturn);
        cv_isAttributeFetched.visitLabel(gotoFalse);
        cv_isAttributeFetched.visitInsn(3);
        cv_isAttributeFetched.visitLabel(gotoReturn);
        cv_isAttributeFetched.visitInsn(172);
        cv_isAttributeFetched.visitMaxs(0, 0);
        CodeVisitor cv_checkFetched = this.cv.visitMethod(1, "_persistence_checkFetched", "(Ljava/lang/String;)V", null, null);
        cv_checkFetched.visitVarInsn(25, 0);
        cv_checkFetched.visitVarInsn(25, 1);
        cv_checkFetched.visitMethodInsn(182, classDetails.getClassName(), "_persistence_isAttributeFetched", "(Ljava/lang/String;)Z");
        gotoReturn = new Label();
        cv_checkFetched.visitJumpInsn(154, gotoReturn);
        cv_checkFetched.visitVarInsn(25, 0);
        cv_checkFetched.visitMethodInsn(184, "org/eclipse/persistence/jpa/JpaHelper", "loadUnfetchedObject", "(Ljava/lang/Object;)V");
        cv_checkFetched.visitLabel(gotoReturn);
        cv_checkFetched.visitInsn(177);
        cv_checkFetched.visitMaxs(0, 0);
    }

    protected RuntimeVisibleAnnotations getTransientAnnotation() {
        RuntimeVisibleAnnotations attrs = new RuntimeVisibleAnnotations();
        Annotation transientAnnotation = new Annotation(Type.getDescriptor(Transient.class));
        if (ClassWeaver.isJAXBOnPath()) {
            try {
                attrs.annotations.add(new Annotation(Type.getDescriptor(Class.forName("javax.xml.bind.annotation.XmlTransient"))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        attrs.annotations.add(transientAnnotation);
        return attrs;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        boolean fetchGroupTracker;
        boolean persistenceEntity;
        this.uuidGenerator.visit(version, access, name, superName, interfaces, sourceFile);
        boolean weaveCloneable = true;
        for (int index = 0; index < interfaces.length; ++index) {
            String existingInterface = interfaces[index];
            if (PERSISTENCE_WEAVED_SHORT_SIGNATURE.equals(existingInterface)) {
                this.alreadyWeaved = true;
                super.visit(version, access, name, superName, interfaces, sourceFile);
                return;
            }
            if (CT_SHORT_SIGNATURE.equals(existingInterface)) {
                this.classDetails.setShouldWeaveChangeTracking(false);
                continue;
            }
            if (!CLONEABLE_SHORT_SIGNATURE.equals(existingInterface)) continue;
            weaveCloneable = false;
        }
        int newInterfacesLength = interfaces.length;
        int cloneableIndex = 0;
        boolean bl = weaveCloneable = this.classDetails.shouldWeaveInternal() && weaveCloneable && this.classDetails.getSuperClassDetails() == null;
        if (weaveCloneable) {
            cloneableIndex = newInterfacesLength++;
        }
        int persistenceWeavedIndex = newInterfacesLength++;
        int persistenceEntityIndex = 0;
        boolean bl2 = persistenceEntity = this.classDetails.shouldWeaveInternal() && this.classDetails.getSuperClassDetails() == null && !this.classDetails.isEmbedable();
        if (persistenceEntity) {
            persistenceEntityIndex = newInterfacesLength++;
        }
        int persistenceObjectIndex = 0;
        boolean persistenceObject = this.classDetails.shouldWeaveInternal();
        if (persistenceObject) {
            persistenceObjectIndex = newInterfacesLength++;
        }
        int fetchGroupTrackerIndex = 0;
        boolean bl3 = fetchGroupTracker = this.classDetails.shouldWeaveFetchGroups() && this.classDetails.getSuperClassDetails() == null;
        if (fetchGroupTracker) {
            fetchGroupTrackerIndex = newInterfacesLength++;
        }
        int persistenceWeavedFetchGroupsIndex = 0;
        if (this.classDetails.shouldWeaveFetchGroups()) {
            persistenceWeavedFetchGroupsIndex = newInterfacesLength++;
        }
        int persistenceWeavedLazyIndex = 0;
        if (this.classDetails.shouldWeaveValueHolders()) {
            persistenceWeavedLazyIndex = newInterfacesLength++;
        }
        boolean changeTracker = !this.classDetails.doesSuperclassWeaveChangeTracking() && this.classDetails.shouldWeaveChangeTracking();
        int persistenceWeavedChangeTrackingIndex = 0;
        int changeTrackerIndex = 0;
        if (changeTracker) {
            changeTrackerIndex = newInterfacesLength++;
        }
        if (this.classDetails.shouldWeaveChangeTracking()) {
            persistenceWeavedChangeTrackingIndex = newInterfacesLength++;
        }
        String[] newInterfaces = new String[newInterfacesLength];
        System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
        newInterfaces[persistenceWeavedIndex] = PERSISTENCE_WEAVED_SHORT_SIGNATURE;
        this.weaved = true;
        if (weaveCloneable) {
            newInterfaces[cloneableIndex] = CLONEABLE_SHORT_SIGNATURE;
        }
        if (persistenceEntity) {
            newInterfaces[persistenceEntityIndex] = PERSISTENCE_ENTITY_SHORT_SIGNATURE;
        }
        if (persistenceObject) {
            newInterfaces[persistenceObjectIndex] = PERSISTENCE_OBJECT_SHORT_SIGNATURE;
        }
        if (fetchGroupTracker) {
            newInterfaces[fetchGroupTrackerIndex] = FETCHGROUP_TRACKER_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveFetchGroups()) {
            newInterfaces[persistenceWeavedFetchGroupsIndex] = WEAVED_FETCHGROUPS_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveValueHolders()) {
            newInterfaces[persistenceWeavedLazyIndex] = TW_LAZY_SHORT_SIGNATURE;
        }
        if (changeTracker) {
            newInterfaces[changeTrackerIndex] = CT_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveChangeTracking()) {
            newInterfaces[persistenceWeavedChangeTrackingIndex] = TW_CT_SHORT_SIGNATURE;
        }
        super.visit(version, access, name, superName, newInterfaces, sourceFile);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.uuidGenerator.visitField(access, name, desc, value, attrs);
        super.visitField(access, name, desc, value, attrs);
    }

    public CodeVisitor visitMethod(int access, String methodName, String desc, String[] exceptions, Attribute attrs) {
        this.uuidGenerator.visitMethod(access, methodName, desc, exceptions, attrs);
        if (!this.alreadyWeaved) {
            if ("<init>".equals(methodName) || "<cinit>".equals(methodName)) {
                return super.visitMethod(access, methodName, desc, exceptions, attrs);
            }
            return new MethodWeaver(this, methodName, desc, this.cv.visitMethod(access, methodName, desc, exceptions, attrs));
        }
        return super.visitMethod(access, methodName, desc, exceptions, attrs);
    }

    public void visitAttribute(Attribute attr) {
        if (!this.alreadyWeaved) {
            this.cv.visitAttribute(attr);
        } else {
            super.visitAttribute(attr);
        }
    }

    public void visitEnd() {
        if (this.alreadyWeaved) {
            return;
        }
        if (this.classDetails.shouldWeaveInternal()) {
            if (!this.uuidGenerator.hasSVUID()) {
                long suid = this.uuidGenerator.computeSVUID();
                this.cv.visitField(25, "serialVersionUID", LONG_SIGNATURE, (Object)suid, null);
            }
            this.addPersistencePostClone(this.classDetails);
            if (this.classDetails.getSuperClassDetails() == null) {
                this.addShallowClone(this.classDetails);
                if (!this.classDetails.isEmbedable()) {
                    this.addPersistenceEntityVariables();
                    this.addPersistenceEntityMethods(this.classDetails);
                    this.weavedPersistenceEntity = true;
                }
            }
            this.addPersistenceNew(this.classDetails);
            this.addPersistenceGetSet(this.classDetails);
        }
        boolean attributeAccess = false;
        for (AttributeDetails attributeDetails : this.classDetails.getAttributesMap().values()) {
            if (attributeDetails.isAttributeOnSuperClass()) continue;
            if (attributeDetails.weaveValueHolders() && !attributeDetails.isAttributeOnSuperClass()) {
                this.weaved = true;
                this.weavedLazy = true;
                this.addValueHolder(attributeDetails);
                this.addInitializerForValueHolder(this.classDetails, attributeDetails);
                this.addGetterMethodForValueHolder(this.classDetails, attributeDetails);
                this.addSetterMethodForValueHolder(this.classDetails, attributeDetails);
            }
            if (!this.classDetails.shouldWeaveChangeTracking() && !this.classDetails.shouldWeaveFetchGroups() && !attributeDetails.weaveValueHolders() || !attributeDetails.hasField()) continue;
            this.weaved = true;
            this.addGetterMethodForFieldAccess(this.classDetails, attributeDetails);
            this.addSetterMethodForFieldAccess(this.classDetails, attributeDetails);
            attributeAccess = true;
        }
        if (this.classDetails.shouldWeaveChangeTracking()) {
            this.weaved = true;
            this.weavedChangeTracker = true;
            if (this.classDetails.getSuperClassDetails() == null || !this.classDetails.doesSuperclassWeaveChangeTracking()) {
                this.addPropertyChangeListener(attributeAccess);
                this.addGetPropertyChangeListener(this.classDetails);
                this.addSetPropertyChangeListener(this.classDetails);
                this.addPropertyChange(this.classDetails);
            }
        }
        if (this.classDetails.shouldWeaveFetchGroups()) {
            this.weaved = true;
            this.weavedFetchGroups = true;
            if (this.classDetails.getSuperClassDetails() == null) {
                this.addFetchGroupVariables();
                this.addFetchGroupMethods(this.classDetails);
            }
        }
        super.visitEnd();
    }
}

