/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.glassfish.admin.amx.base.Sample;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.OpenMBeanUtil;

public final class SampleImpl
extends AMXImplBase {
    private final Map<String, Serializable> mAttributes = Collections.synchronizedMap(new HashMap());
    private MBeanInfo mExtendedMBeanInfo = null;
    private static final int MEGABYTE = 0x100000;

    public void emitNotifications(Serializable data, int numNotifs, long interval) {
        if (numNotifs <= 0) {
            throw new IllegalArgumentException("" + numNotifs);
        }
        new EmitterThread(data, numNotifs, interval).start();
    }

    public SampleImpl(ObjectName parentObjectName) {
        super(parentObjectName, Sample.class);
    }

    public void addAttribute(String name, Serializable value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.mAttributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.mAttributes.remove(name);
        this.mExtendedMBeanInfo = null;
    }

    private synchronized MBeanInfo createMBeanInfo(MBeanInfo baseMBeanInfo) {
        MBeanAttributeInfo[] dynamicAttrInfos = new MBeanAttributeInfo[this.mAttributes.keySet().size()];
        int i = 0;
        for (String name : this.mAttributes.keySet()) {
            Serializable value = this.mAttributes.get(name);
            String type = value == null ? String.class.getName() : value.getClass().getName();
            dynamicAttrInfos[i] = new MBeanAttributeInfo(name, type, "dynamically-added Attribute", true, true, false);
            ++i;
        }
        MBeanAttributeInfo[] attrInfos = JMXUtil.mergeMBeanAttributeInfos((MBeanAttributeInfo[])dynamicAttrInfos, (MBeanAttributeInfo[])baseMBeanInfo.getAttributes());
        return JMXUtil.newMBeanInfo((MBeanInfo)baseMBeanInfo, (MBeanAttributeInfo[])attrInfos);
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mExtendedMBeanInfo == null) {
            this.mExtendedMBeanInfo = this.createMBeanInfo(super.getMBeanInfo());
        }
        return this.mExtendedMBeanInfo;
    }

    protected Serializable getAttributeManually(String name) {
        return this.mAttributes.get(name);
    }

    protected void setAttributeManually(Attribute attr) {
        this.mAttributes.put(attr.getName(), (Serializable)Serializable.class.cast(attr.getValue()));
    }

    public void uploadBytes(byte[] bytes) {
    }

    public byte[] downloadBytes(int numBytes) {
        if (numBytes < 0 || numBytes > 0xA00000) {
            throw new IllegalArgumentException("Illegal count: " + numBytes);
        }
        byte[] bytes = new byte[numBytes];
        return bytes;
    }

    public ObjectName[] getAllAMX() {
        List all = Util.toObjectNameList((Collection)this.getDomainRootProxy().getQueryMgr().queryAll());
        return (ObjectName[])CollectionUtil.toArray((Collection)all, ObjectName.class);
    }

    public Object[] getAllSortsOfStuff() {
        List stuff = ListUtil.newList();
        Map values = MapUtil.newMap();
        values.put("ByteField", new Byte(0));
        values.put("ShortField", new Short(0));
        values.put("IntegerField", new Integer(0));
        values.put("LongField", new Long(0L));
        values.put("FloatField", new Float(0.0));
        values.put("DoubleField", new Double(0.0));
        values.put("BigDecimalField", new BigDecimal("999999999999999999999999999999.999999999999999999999999999999"));
        values.put("BigIntegerField", new BigInteger("999999999999999999999999999999999999999999999999999999999999"));
        values.put("CharacterField", Character.valueOf('x'));
        values.put("StringField", "hello");
        values.put("BooleanField", true);
        values.put("DateField", new Date());
        values.put("ObjectNameField", this.getObjectName());
        CompositeData data = null;
        try {
            data = OpenMBeanUtil.mapToCompositeData((String)"org.glassfish.test.Sample1", (String)"test", (Map)values);
            stuff.add(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        stuff.add(data);
        stuff.addAll(values.values());
        stuff.add(MapUtil.newMap());
        stuff.add(ListUtil.newList());
        stuff.add(SetUtil.newSet());
        TabularDataSupport table = null;
        try {
            String[] indexNames = (String[])CollectionUtil.toArray(values.keySet(), String.class);
            CompositeType rowType = data.getCompositeType();
            TabularType tabularType = new TabularType("org.glassfish.test.Sample2", "test", rowType, indexNames);
            table = new TabularDataSupport(tabularType);
            table.put(data);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        stuff.add(table);
        Object[] result = CollectionUtil.toArray((Collection)stuff, Object.class);
        return result;
    }

    private final class EmitterThread
    extends Thread {
        private final Serializable mData;
        private final int mNumNotifs;
        private final long mIntervalMillis;

        public EmitterThread(Serializable data, int numNotifs, long intervalMillis) {
            this.mData = data;
            this.mNumNotifs = numNotifs;
            this.mIntervalMillis = intervalMillis;
        }

        public void run() {
            for (int i = 0; i < this.mNumNotifs; ++i) {
                SampleImpl.this.sendNotification("Sample", "UserData", this.mData);
                try {
                    Thread.sleep(this.mIntervalMillis);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

