/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.api.amx.BootAMXMBean;

class BootAMXListener
implements NotificationListener {
    private final JMXConnectorServer mServer;
    private final BootAMXMBean mBooter;

    public BootAMXListener(JMXConnectorServer server, BootAMXMBean booter) {
        this.mServer = server;
        this.mBooter = booter;
    }

    public void handleNotification(Notification notif, Object handback) {
        JMXConnectionNotification n;
        if (notif instanceof JMXConnectionNotification && (n = (JMXConnectionNotification)notif).getType().equals("jmx.remote.connection.opened")) {
            Util.getLogger().info("BootAMXListener: connection made for " + handback + ", booting AMX MBeans");
            this.mBooter.bootAMX();
            try {
                this.mServer.removeNotificationListener(this);
                Util.getLogger().fine("ConnectorStartupService.BootAMXListener: AMX is booted, stopped listening");
            }
            catch (ListenerNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

