/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.monitoring;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.TransactionAdminBean;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="Transaction Service Statistics")
public class TransactionServiceStatsProvider {
    private static final int COLUMN_LENGTH = 25;
    private CountStatisticImpl activeCount = new CountStatisticImpl("ActiveCount", "count", "Provides the number of transactions that are currently active.");
    private CountStatisticImpl committedCount = new CountStatisticImpl("CommittedCount", "count", "Provides the number of transactions that have been committed.");
    private CountStatisticImpl rolledbackCount = new CountStatisticImpl("RolledbackCount", "count", "Provides the number of transactions that have been rolled back.");
    private StringStatisticImpl inflightTransactions = new StringStatisticImpl("ActiveIds", "List", "Provides the IDs of the transactions that are currently active a.k.a. in-flight transactions. Every such transaction can be rolled back after freezing the transaction service.");
    private StringStatisticImpl state = new StringStatisticImpl("State", "String", "Indicates if the transaction service has been frozen");
    private boolean isFrozen = false;
    private JavaEETransactionManager txMgr;
    private Logger _logger;

    public TransactionServiceStatsProvider(JavaEETransactionManager tm, Logger l) {
        this.txMgr = tm;
        this._logger = l;
    }

    @ManagedAttribute(id="activecount")
    @Description(value="Provides the number of transactions that are currently active.")
    public CountStatistic getActiveCount() {
        return this.activeCount.getStatistic();
    }

    @ManagedAttribute(id="committedcount")
    @Description(value="Provides the number of transactions that have been committed.")
    public CountStatistic getCommittedCount() {
        return this.committedCount.getStatistic();
    }

    @ManagedAttribute(id="rolledbackcount")
    @Description(value="Provides the number of transactions that have been rolled back.")
    public CountStatistic getRolledbackCount() {
        return this.rolledbackCount.getStatistic();
    }

    @ManagedAttribute(id="state")
    @Description(value="Indicates if the transaction service has been frozen.")
    public StringStatistic getState() {
        this.state.setCurrent(this.isFrozen ? "True" : "False");
        return this.state.getStatistic();
    }

    @ManagedAttribute(id="activeids")
    @Description(value="List of inflight transactions.")
    public StringStatistic getActiveIds() {
        try {
            StringBuffer strBuf = new StringBuffer(1024);
            if (this.txMgr == null) {
                this._logger.warning("transaction.monitor.tm_null");
                this.inflightTransactions.setCurrent("");
                return this.inflightTransactions.getStatistic();
            }
            ArrayList aList = this.txMgr.getActiveTransactions();
            if (!aList.isEmpty()) {
                if (aList.size() > 0) {
                    int i;
                    String colName = "Transaction Id";
                    strBuf.append(colName);
                    for (i = colName.length(); i < 40; ++i) {
                        strBuf.append(" ");
                    }
                    colName = "Status";
                    strBuf.append(colName);
                    for (i = colName.length(); i < 25; ++i) {
                        strBuf.append(" ");
                    }
                    colName = "ElapsedTime(ms)";
                    strBuf.append(colName);
                    for (i = colName.length(); i < 25; ++i) {
                        strBuf.append(" ");
                    }
                    colName = "ComponentName";
                    strBuf.append(colName);
                    for (i = colName.length(); i < 25; ++i) {
                        strBuf.append(" ");
                    }
                    strBuf.append("ResourceNames ");
                }
                for (int i = 0; i < aList.size(); ++i) {
                    int j;
                    TransactionAdminBean txnBean = (TransactionAdminBean)aList.get(i);
                    String txnId = txnBean.getId();
                    this._logger.fine("=== Processing txnId: " + txnId);
                    strBuf.append(txnId);
                    for (j = txnId.length(); j < 40; ++j) {
                        strBuf.append(" ");
                    }
                    strBuf.append(txnBean.getStatus());
                    for (j = txnBean.getStatus().length(); j < 25; ++j) {
                        strBuf.append(" ");
                    }
                    strBuf.append(String.valueOf(txnBean.getElapsedTime()));
                    for (j = String.valueOf(txnBean.getElapsedTime()).length(); j < 25; ++j) {
                        strBuf.append(" ");
                    }
                    strBuf.append(txnBean.getComponentName());
                    for (j = txnBean.getComponentName().length(); j < 25; ++j) {
                        strBuf.append(" ");
                    }
                    ArrayList resourceList = txnBean.getResourceNames();
                    if (resourceList == null) continue;
                    for (int k = 0; k < resourceList.size(); ++k) {
                        strBuf.append((String)resourceList.get(k));
                        strBuf.append(",");
                    }
                }
            }
            this._logger.fine("Prepared inflightTransactions text: \n" + strBuf);
            this.inflightTransactions.setCurrent(strBuf == null ? "" : strBuf.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return this.inflightTransactions.getStatistic();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:activated")
    public void transactionActivatedEvent() {
        this._logger.fine("=== transaction-service active ++");
        this.activeCount.increment();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:deactivated")
    public void transactionDeactivatedEvent() {
        this._logger.fine("=== transaction-service active --");
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:committed")
    public void transactionCommittedEvent() {
        this._logger.fine("=== transaction-service committed ++");
        this.committedCount.increment();
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:rolledback")
    public void transactionRolledbackEvent() {
        this._logger.fine("=== transaction-service rolledback ++");
        this.rolledbackCount.increment();
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:freeze")
    public void freezeEvent(@ProbeParam(value="isFrozen") boolean b) {
        this.isFrozen = b;
    }
}

