/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.rack.RackApplication;
import com.sun.grizzly.jruby.rack.RackResponse;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class DefaultRackApplication
implements RackApplication {
    private final IRubyObject application;
    private final Ruby runtime;
    private final Logger logger;
    private final RubyString rack_version;
    private final RubyString rack_multithread;
    private final RubyString rack_multiprocess;
    private final RubyString rack_run_once;
    private final RubyHash base;
    private final RubyString rack_input;
    private final RubyString rack_errors;
    private final RubyString rack_url_scheme;
    private final RubyString req_method;
    private final RubyString script_name;
    private final RubyString request_uri;
    private final RubyString path_info;
    private final RubyString query_string;
    private final RubyString path_translated;
    private final RubyString server_name;
    private final RubyString remote_host;
    private final RubyString remote_addr;
    private final RubyString remote_user;
    private final RubyString server_port;
    private final RubyString content_type;
    private final RubyString content_length;
    private final RackGrizzlyAdapter adapter;

    public DefaultRackApplication(IRubyObject application, RackGrizzlyAdapter adapter) {
        this.application = application;
        this.runtime = application.getRuntime();
        this.logger = adapter.getLogger();
        this.adapter = adapter;
        this.base = RubyHash.newHash((Ruby)this.runtime);
        this.rack_version = this.runtime.newString("rack.version");
        this.rack_multithread = this.runtime.newString("rack.multithread");
        this.rack_multiprocess = this.runtime.newString("rack.multiprocess");
        this.rack_run_once = this.runtime.newString("rack.run_once");
        this.rack_input = this.runtime.newString("rack.input");
        this.rack_errors = this.runtime.newString("rack.errors");
        this.rack_url_scheme = this.runtime.newString("rack.url_scheme");
        this.base.put((Object)this.rack_version, (Object)this.runtime.evalScriptlet("Rack::VERSION"));
        this.base.put((Object)this.rack_multithread, (Object)this.runtime.getTrue());
        this.base.put((Object)this.rack_multiprocess, (Object)this.runtime.getFalse());
        this.base.put((Object)this.rack_run_once, (Object)this.runtime.getFalse());
        this.base.put((Object)this.rack_errors, (Object)this.runtime.evalScriptlet("JRuby::Rack::GrizzlyLog.new"));
        this.req_method = this.runtime.newString("REQUEST_METHOD");
        this.script_name = this.runtime.newString("SCRIPT_NAME");
        this.request_uri = this.runtime.newString("REQUEST_URI");
        this.path_info = this.runtime.newString("PATH_INFO");
        this.query_string = this.runtime.newString("QUERY_STRING");
        this.path_translated = this.runtime.newString("PATH_TRANSLATED");
        this.server_name = this.runtime.newString("SERVER_NAME");
        this.remote_host = this.runtime.newString("REMOTE_HOST");
        this.remote_addr = this.runtime.newString("REMOTE_ADDR");
        this.remote_user = this.runtime.newString("REMOTE_USER");
        this.server_port = this.runtime.newString("SERVER_PORT");
        this.content_type = this.runtime.newString("CONTENT_TYPE");
        this.content_length = this.runtime.newString("CONTENT_LENGTH");
    }

    public RackResponse call(GrizzlyRequest grizzlyRequest) {
        Ruby runtime = this.application.getRuntime();
        RubyHash rackEnv = (RubyHash)this.base.dup();
        Request request = grizzlyRequest.getRequest();
        this.addReqInfo(grizzlyRequest, rackEnv);
        this.populateFromMimeHeaders(rackEnv, request.getMimeHeaders());
        this.populateFromMap(rackEnv, request.getAttributes());
        try {
            rackEnv.put((Object)this.rack_input, (Object)RubyIO.newIO((Ruby)runtime, (Channel)Channels.newChannel((InputStream)grizzlyRequest.getInputStream())));
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        rackEnv.put((Object)this.rack_url_scheme, (Object)this.newStringFromMessageBytes(request.scheme()));
        IRubyObject response = this.application.callMethod(runtime.getCurrentContext(), "call", (IRubyObject)rackEnv);
        Object obj = JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)response, RackResponse.class);
        return (RackResponse)obj;
    }

    private void addReqInfo(GrizzlyRequest grequest, RubyHash hash) {
        RubyString reqUri;
        Request request = grequest.getRequest();
        if (this.adapter.config.contextRoot().length() > 1) {
            byte[] bytes = request.requestURI().getByteChunk().getBuffer();
            byte[] contextpath = this.adapter.config.contextRoot().getBytes();
            boolean hasContextRoot = true;
            int offset = request.requestURI().getByteChunk().getOffset();
            for (int i = 0; i < contextpath.length; ++i) {
                if (bytes[offset] != contextpath[i]) {
                    hasContextRoot = false;
                    break;
                }
                if (offset >= bytes.length) continue;
                ++offset;
            }
            if (hasContextRoot) {
                int lenoffset = offset > request.requestURI().getByteChunk().getOffset() ? offset - request.requestURI().getByteChunk().getOffset() : offset;
                reqUri = RubyString.newStringShared((Ruby)this.runtime, (byte[])bytes, (int)offset, (int)(request.requestURI().getByteChunk().getLength() - lenoffset));
            } else {
                reqUri = this.newStringFromMessageBytes(request.requestURI());
            }
            hash.put((Object)this.request_uri, (Object)reqUri);
        } else {
            reqUri = this.newStringFromMessageBytes(request.requestURI());
        }
        hash.put((Object)this.path_info, (Object)reqUri);
        hash.put((Object)this.path_translated, (Object)reqUri);
        hash.put((Object)this.req_method, (Object)this.newStringFromMessageBytes(request.method()));
        hash.put((Object)this.query_string, (Object)this.newStringFromMessageBytes(request.queryString()));
        request.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, null);
        hash.put((Object)this.server_name, (Object)this.newStringFromMessageBytes(request.serverName()));
        request.action(ActionCode.ACTION_REQ_HOST_ATTRIBUTE, null);
        hash.put((Object)this.remote_host, (Object)this.newStringFromMessageBytes(request.remoteHost()));
        request.action(ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE, null);
        hash.put((Object)this.remote_addr, (Object)this.newStringFromMessageBytes(request.remoteAddr()));
        request.action(ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE, null);
        hash.put((Object)this.server_port, (Object)this.runtime.newString(Integer.toString(request.getLocalPort())));
        hash.put((Object)this.remote_user, (Object)this.newStringFromMessageBytes(request.getRemoteUser()));
        hash.put((Object)this.script_name, (Object)this.runtime.newString(""));
        if (request.getContentLength() > 0) {
            hash.put((Object)this.content_length, (Object)this.runtime.newString(Integer.toString(request.getContentLength())));
        }
        hash.put((Object)this.content_type, (Object)this.newStringFromMessageBytes(request.contentType()));
    }

    private void populateFromMap(RubyHash env, Map source) {
        Iterator i$ = source.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = i$.next();
            env.put((Object)this.newStringFromMessageBytes((MessageBytes)entry.getKey()), (Object)this.newStringFromMessageBytes((MessageBytes)entry.getValue()));
        }
    }

    private void populateFromMimeHeaders(RubyHash env, MimeHeaders source) {
        for (int i = 0; i < source.size(); ++i) {
            MessageBytes key = source.getName(i);
            if (key.startsWithIgnoreCase("content-type", 0) || key.startsWithIgnoreCase("content-length", 0)) continue;
            MessageBytes mb = MessageBytes.newInstance();
            byte[] httpKey = new byte[]{72, 84, 84, 80, 95};
            try {
                mb.getByteChunk().append(httpKey, 0, httpKey.length);
                byte[] bytes = key.getByteChunk().getBuffer();
                for (int k = 0; k < key.getByteChunk().getLength(); ++k) {
                    bytes[key.getByteChunk().getOffset() + k] = (byte)Character.toUpperCase(bytes[key.getByteChunk().getOffset() + k]);
                    if (bytes[key.getByteChunk().getOffset() + k] != 45) continue;
                    bytes[key.getByteChunk().getOffset() + k] = 95;
                }
                mb.getByteChunk().append(bytes, key.getByteChunk().getOffset(), key.getByteChunk().getLength());
            }
            catch (IOException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
            MessageBytes value = source.getValue(i);
            env.put((Object)this.newStringFromMessageBytes(mb), (Object)this.newStringFromMessageBytes(value));
        }
    }

    private RubyString newStringFromMessageBytes(MessageBytes messageBytes) {
        if (messageBytes == null) {
            return null;
        }
        ByteChunk chunk = messageBytes.getByteChunk();
        byte[] bytes = chunk.getBuffer();
        if (bytes == null) {
            return RubyString.newEmptyString((Ruby)this.runtime);
        }
        return RubyString.newStringShared((Ruby)this.runtime, (byte[])bytes, (int)chunk.getStart(), (int)chunk.getLength());
    }

    public void destroy() {
        if (this.runtime != null) {
            JavaEmbedUtils.terminate((Ruby)this.runtime);
        }
    }

    public Ruby getRuntime() {
        return this.runtime;
    }
}

