/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.PersistenceDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceArchivist
extends ExtensionsArchivist {
    protected static final String JAR_EXT = ".jar";
    protected static final char SEPERATOR_CHAR = '/';
    protected static final String LIB_DIR = "lib";
    protected final Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");

    @Override
    public DeploymentDescriptorFile getStandardDDFile(RootDeploymentDescriptor descriptor) {
        return new PersistenceDeploymentDescriptorFile();
    }

    @Override
    public DeploymentDescriptorFile getConfigurationDDFile(RootDeploymentDescriptor descriptor) {
        return null;
    }

    @Override
    public XModuleType getModuleType() {
        return XModuleType.Persistence;
    }

    @Override
    public abstract boolean supportsModuleType(XModuleType var1);

    @Override
    public Object open(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        String puRoot = this.getPuRoot(archive);
        this.readPersistenceDeploymentDescriptor(main, archive, puRoot, descriptor);
        return null;
    }

    protected PersistenceUnitsDescriptor readPersistenceDeploymentDescriptor(Archivist main, ReadableArchive subArchive, String puRoot, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        String subArchiveURI = subArchive.getURI().getSchemeSpecificPart();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PURoot = [{0}] subArchive = {1}", new Object[]{puRoot, subArchiveURI});
        }
        if (descriptor.getExtensionsDescriptors(PersistenceUnitsDescriptor.class, puRoot) != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PU has been already read for = {0}", subArchiveURI);
            }
            return null;
        }
        PersistenceUnitsDescriptor persistenceUnitsDescriptor = (PersistenceUnitsDescriptor)PersistenceUnitsDescriptor.class.cast(super.open(main, subArchive, descriptor));
        if (persistenceUnitsDescriptor != null) {
            persistenceUnitsDescriptor.setParent(descriptor);
            persistenceUnitsDescriptor.setPuRoot(puRoot);
            descriptor.addExtensionDescriptor(PersistenceUnitsDescriptor.class, persistenceUnitsDescriptor, puRoot);
        }
        return persistenceUnitsDescriptor;
    }

    @Override
    public <T extends RootDeploymentDescriptor> T getDefaultDescriptor() {
        return null;
    }

    protected Map<String, ReadableArchive> getProbablePersistenceRoots(ReadableArchive parentArchive, SubArchivePURootScanner subArchivePURootScanner) {
        HashMap<String, ReadableArchive> probablePersitenceArchives = new HashMap<String, ReadableArchive>();
        ReadableArchive archiveToScan = subArchivePURootScanner.getSubArchiveToScan(parentArchive);
        if (archiveToScan != null) {
            Enumeration entries = archiveToScan.entries();
            String puRootPrefix = subArchivePURootScanner.getPurRootPrefix();
            while (entries.hasMoreElements()) {
                ReadableArchive puRootArchive;
                String entry = (String)entries.nextElement();
                if (!subArchivePURootScanner.isProbablePuRootJar(entry) || (puRootArchive = this.getSubArchive(archiveToScan, entry, false)) == null) continue;
                String puRoot = puRootPrefix + entry;
                probablePersitenceArchives.put(puRoot, puRootArchive);
            }
        }
        return probablePersitenceArchives;
    }

    private ReadableArchive getSubArchive(ReadableArchive parentArchive, String path, boolean expectAbscenceOfSubArchive) {
        ReadableArchive returnedArchive;
        block2: {
            returnedArchive = null;
            try {
                returnedArchive = parentArchive.getSubArchive(path);
            }
            catch (IOException ioe) {
                if (expectAbscenceOfSubArchive) break block2;
                this.logger.log(Level.SEVERE, ioe.getMessage(), ioe);
            }
        }
        return returnedArchive;
    }

    protected String getPuRoot(ReadableArchive archive) {
        assert (false);
        return null;
    }

    protected abstract class SubArchivePURootScanner {
        protected SubArchivePURootScanner() {
        }

        abstract String getPathOfSubArchiveToScan();

        ReadableArchive getSubArchiveToScan(ReadableArchive parentArchive) {
            String pathOfSubArchiveToScan = this.getPathOfSubArchiveToScan();
            return pathOfSubArchiveToScan.isEmpty() ? parentArchive : PersistenceArchivist.this.getSubArchive(parentArchive, pathOfSubArchiveToScan, true);
        }

        String getPurRootPrefix() {
            String pathOfSubArchiveToScan = this.getPathOfSubArchiveToScan();
            return pathOfSubArchiveToScan.isEmpty() ? pathOfSubArchiveToScan : pathOfSubArchiveToScan + '/';
        }

        boolean isProbablePuRootJar(String jarName) {
            return this.isJarEntry(jarName) && this.checkIsInRootOfArchive(jarName, this.getPathOfSubArchiveToScan());
        }

        private boolean checkIsInRootOfArchive(String path, String parentArchivePath) {
            boolean inRootOfArchive = true;
            if (path.indexOf(47) != -1) {
                inRootOfArchive = false;
                if (PersistenceArchivist.this.logger.isLoggable(Level.FINE)) {
                    PersistenceArchivist.this.logger.logp(Level.FINE, "PersistenceArchivist", "readPersistenceDeploymentDescriptors", "skipping {0} as it exists inside a directory in {1}.", new Object[]{path, parentArchivePath});
                }
            }
            return inRootOfArchive;
        }

        private boolean isJarEntry(String path) {
            return path.endsWith(PersistenceArchivist.JAR_EXT);
        }
    }
}

