/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Server;
import org.glassfish.ejb.embedded.EmbeddedEjbContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerImpl
extends EJBContainer {
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private final Server server;
    private final EmbeddedEjbContainer ejbContainer;
    private final EmbeddedDeployer deployer;
    private Set<String> deployedApps = new HashSet<String>();
    private boolean open = true;

    EJBContainerImpl(Server server, EmbeddedEjbContainer ejbContainer, EmbeddedDeployer deployer) {
        this.server = server;
        this.ejbContainer = ejbContainer;
        this.deployer = deployer;
    }

    void deploy(Map<?, ?> properties, Set<File> modules) throws EJBException {
        for (File f : modules) {
            DeployCommandParameters dp = new DeployCommandParameters(f);
            dp.name = f.getName();
            try {
                String appName = this.deployer.deploy(f, dp);
                this.deployedApps.add(appName);
            }
            catch (Exception e) {
                _logger.warning("Cannot deploy file: " + f.getName() + " : " + e.getMessage());
            }
        }
    }

    @Override
    public Context getContext() {
        _logger.info("IN getContext()");
        try {
            return new InitialContext();
        }
        catch (Exception e) {
            throw new EJBException(_logger.getResourceBundle().getString("ejb.embedded.cannot_create_context"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        _logger.info("IN close()");
        try {
            for (String appName : this.deployedApps) {
                this.deployer.undeploy(appName);
            }
            this.deployedApps.clear();
        }
        catch (Exception e) {
            System.err.println("Cannot undeploy deployed modules: " + e.getMessage());
        }
        try {
            try {
                this.server.stop();
            }
            catch (LifecycleException e) {
                System.err.println("Cannot stop embedded container " + e.getMessage());
                Object var4_6 = null;
                this.open = false;
            }
            Object var4_5 = null;
            this.open = false;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.open = false;
            throw throwable;
        }
    }

    boolean isOpen() {
        return this.open;
    }
}

