/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;

public class EchoFilter
implements ProtocolFilter {
    public boolean execute(Context ctx) throws IOException {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer buffer = workerThread.getByteBuffer();
        buffer.flip();
        if (buffer.hasRemaining()) {
            SelectableChannel channel = ctx.getSelectionKey().channel();
            try {
                if (ctx.getProtocol() == Controller.Protocol.TCP) {
                    OutputWriter.flushChannel((SelectableChannel)channel, (ByteBuffer)buffer);
                } else if (ctx.getProtocol() == Controller.Protocol.UDP) {
                    DatagramChannel datagramChannel = (DatagramChannel)channel;
                    SocketAddress address = (SocketAddress)ctx.getAttribute("socketAddress");
                    OutputWriter.flushChannel((DatagramChannel)datagramChannel, (SocketAddress)address, (ByteBuffer)buffer);
                }
            }
            catch (IOException ex) {
                byte[] data = new byte[buffer.remaining()];
                int position = buffer.position();
                buffer.get(data);
                buffer.position(position);
                Controller.logger().log(Level.WARNING, "Exception. Echo \"" + new String(data) + "\"");
                throw ex;
            }
        }
        buffer.clear();
        return false;
    }

    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }
}

