/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagerImpl
extends StateManager {
    private boolean isDevelopmentMode = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development);
    private Map<String, Class<?>> classMap = new ConcurrentHashMap(32);

    public Object saveView(FacesContext context) {
        Object[] result;
        if (context == null) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        String viewId = context.getViewRoot().getViewId();
        StateManagementStrategy strategy = null;
        ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId);
        if (vdl != null) {
            strategy = vdl.getStateManagementStrategy(context, viewId);
        }
        if (null != strategy) {
            result = strategy.saveView(context);
        } else {
            Util.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
            ArrayList<TreeNode> treeList = new ArrayList<TreeNode>(32);
            Object state = viewRoot.processSaveState(context);
            StateManagerImpl.captureChild(treeList, 0, (UIComponent)viewRoot);
            Object[] tree = treeList.toArray();
            result = new Object[]{tree, state};
        }
        return result;
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        RenderKit rk = context.getRenderKit();
        ResponseStateManager rsm = rk.getResponseStateManager();
        rsm.writeState(context, state);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot result = null;
        StateManagementStrategy strategy = null;
        ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId);
        if (vdl != null) {
            strategy = vdl.getStateManagementStrategy(context, viewId);
        }
        if (null != strategy) {
            result = strategy.restoreView(context, viewId, renderKitId);
        } else {
            ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
            Object[] state = (Object[])rsm.getState(context, viewId);
            if (state != null) {
                UIViewRoot viewRoot = this.restoreTree(renderKitId, (Object[])((Object[])state[0]).clone());
                viewRoot.processRestoreState(context, state[1]);
                result = viewRoot;
            }
        }
        return result;
    }

    private static void captureChild(List<TreeNode> tree, int parent, UIComponent c) {
        if (!c.isTransient()) {
            TreeNode n = new TreeNode(parent, c);
            int pos = tree.size();
            tree.add(n);
            StateManagerImpl.captureRest(tree, pos, c);
        }
    }

    private static void captureFacet(List<TreeNode> tree, int parent, String name, UIComponent c) {
        if (!c.isTransient()) {
            FacetNode n = new FacetNode(parent, name, c);
            int pos = tree.size();
            tree.add(n);
            StateManagerImpl.captureRest(tree, pos, c);
        }
    }

    private static void captureRest(List<TreeNode> tree, int pos, UIComponent c) {
        int sz = c.getChildCount();
        if (sz > 0) {
            List child = c.getChildren();
            for (int i = 0; i < sz; ++i) {
                StateManagerImpl.captureChild(tree, pos, (UIComponent)child.get(i));
            }
        }
        if ((sz = c.getFacetCount()) > 0) {
            for (Map.Entry entry : c.getFacets().entrySet()) {
                StateManagerImpl.captureFacet(tree, pos, (String)entry.getKey(), (UIComponent)entry.getValue());
            }
        }
    }

    private UIComponent newInstance(TreeNode n) throws FacesException {
        try {
            Class t;
            Class clazz = t = this.classMap != null ? this.classMap.get(n.componentType) : null;
            if (t == null) {
                t = Util.loadClass(n.componentType, n);
                if (t != null && this.classMap != null) {
                    this.classMap.put(n.componentType, t);
                } else if (!this.isDevelopmentMode) {
                    throw new NullPointerException();
                }
            }
            assert (t != null);
            UIComponent c = (UIComponent)t.newInstance();
            c.setId(n.id);
            return c;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private UIViewRoot restoreTree(String renderKitId, Object[] tree) throws FacesException {
        for (int i = 0; i < tree.length; ++i) {
            UIComponent c;
            if (tree[i] instanceof FacetNode) {
                FacetNode fn = (FacetNode)tree[i];
                c = this.newInstance(fn);
                tree[i] = c;
                if (i == fn.parent) continue;
                ((UIComponent)tree[fn.parent]).getFacets().put(fn.facetName, c);
                continue;
            }
            TreeNode tn = (TreeNode)tree[i];
            c = this.newInstance(tn);
            tree[i] = c;
            if (i != tn.parent) {
                ((UIComponent)tree[tn.parent]).getChildren().add(c);
                continue;
            }
            assert (c instanceof UIViewRoot);
            UIViewRoot viewRoot = (UIViewRoot)c;
            FacesContext.getCurrentInstance().setViewRoot(viewRoot);
            viewRoot.setRenderKitId(renderKitId);
        }
        return (UIViewRoot)tree[0];
    }

    private static final class FacetNode
    extends TreeNode {
        public String facetName;
        private static final long serialVersionUID = -3777170310958005106L;

        public FacetNode() {
        }

        public FacetNode(int parent, String name, UIComponent c) {
            super(parent, c);
            this.facetName = name;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.facetName = in.readUTF();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeUTF(this.facetName);
        }
    }

    private static class TreeNode
    implements Externalizable {
        private static final String NULL_ID = "";
        public String componentType;
        public String id;
        public int parent;
        private static final long serialVersionUID = -835775352718473281L;

        public TreeNode() {
        }

        public TreeNode(int parent, UIComponent c) {
            this.parent = parent;
            this.id = c.getId();
            this.componentType = c.getClass().getName();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.parent);
            out.writeUTF(this.componentType);
            if (this.id != null) {
                out.writeUTF(this.id);
            } else {
                out.writeUTF(NULL_ID);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.parent = in.readInt();
            this.componentType = in.readUTF();
            this.id = in.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }
    }
}

