/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

public class ResourceInfo {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String COMPRESSED_CONTENT_DIRECTORY = "jsf-compressed";
    String name;
    String libraryName;
    String localePrefix;
    private VersionInfo version;
    private ResourceHelper helper;
    private LibraryInfo library;
    private String path;
    private String compressedPath;
    private boolean compressable;
    private boolean supportsEL;

    public ResourceInfo(LibraryInfo library, String name, VersionInfo version, boolean compressable, boolean supportsEL) {
        this.name = name;
        this.version = version;
        this.helper = library.getHelper();
        this.library = library;
        this.libraryName = library.getName();
        this.localePrefix = library.getLocalePrefix();
        this.compressable = compressable;
        this.supportsEL = supportsEL;
        this.initPath();
    }

    ResourceInfo(String name, VersionInfo version, String localePrefix, ResourceHelper helper, boolean compressable, boolean supportsEL) {
        this.name = name;
        this.version = version;
        this.localePrefix = localePrefix;
        this.helper = helper;
        this.compressable = compressable;
        this.supportsEL = supportsEL;
        this.initPath();
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public LibraryInfo getLibraryInfo() {
        return this.library;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String getPath() {
        return this.path;
    }

    public String getCompressedPath() {
        return this.compressedPath;
    }

    public boolean isCompressable() {
        return this.compressable;
    }

    public boolean supportsEL() {
        return this.supportsEL;
    }

    public String toString() {
        return "ResourceInfo{name='" + this.name + '\'' + ", version='" + (this.version != null ? this.version : "NONE") + '\'' + ", libraryName='" + this.libraryName + '\'' + ", libraryVersion='" + (this.library != null ? this.library.getVersion() : "NONE") + '\'' + ", localePrefix='" + (this.localePrefix != null ? this.localePrefix : "NONE") + '\'' + ", path='" + this.path + '\'' + ", compressable='" + this.compressable + '\'' + ", compressedPath=" + this.compressedPath + '}';
    }

    private void initPath() {
        StringBuilder sb = new StringBuilder(32);
        if (this.library != null) {
            sb.append(this.library.getPath());
        } else {
            sb.append(this.helper.getBaseResourcePath());
        }
        if (this.library == null && this.localePrefix != null) {
            sb.append('/').append(this.localePrefix);
        }
        sb.append('/').append(this.name);
        if (this.version != null) {
            sb.append('/').append(this.version.getVersion());
            String extension = this.version.getExtension();
            if (extension != null) {
                sb.append('.').append(extension);
            }
        }
        this.path = sb.toString();
        if (this.compressable && !this.supportsEL) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            File servletTmpDir = (File)ctx.getExternalContext().getApplicationMap().get("javax.servlet.context.tempdir");
            if (servletTmpDir == null || !servletTmpDir.isDirectory()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "File ({0}) referenced by javax.servlet.context.tempdir attribute is null, or was is not a directory.  Compression for {1} will be unavailable.", new Object[]{servletTmpDir == null ? "null" : servletTmpDir.toString(), this.path});
                }
                this.compressable = false;
            } else {
                String tPath = this.path.charAt(0) == '/' ? this.path : '/' + this.path;
                File newDir = new File(servletTmpDir, COMPRESSED_CONTENT_DIRECTORY + tPath);
                try {
                    if (!newDir.exists()) {
                        if (newDir.mkdirs()) {
                            this.compressedPath = newDir.getCanonicalPath();
                        } else {
                            this.compressable = false;
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_create_compression_directory", newDir.getCanonicalPath());
                            }
                        }
                    } else {
                        this.compressedPath = newDir.getCanonicalPath();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                    this.compressable = false;
                }
            }
        }
    }
}

