/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.StateManagementStrategyImpl;
import com.sun.faces.application.view.ViewHandlingStrategy;
import com.sun.faces.application.view.ViewMetadataImpl;
import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.FaceletFactory;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.compiler.SAXCompiler;
import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.composite.CompositeComponentBeanInfo;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.facelets.tag.ui.UIDebug;
import com.sun.faces.scripting.GroovyHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.awt.event.ActionEvent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionListener;
import javax.faces.event.MethodExpressionActionListener;
import javax.faces.event.MethodExpressionValueChangeListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.RenderKit;
import javax.faces.validator.MethodExpressionValidator;
import javax.faces.validator.Validator;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.ActionSource2AttachedObjectTarget;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.EditableValueHolderAttachedObjectHandler;
import javax.faces.view.EditableValueHolderAttachedObjectTarget;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ValueHolderAttachedObjectHandler;
import javax.faces.view.ValueHolderAttachedObjectTarget;
import javax.faces.view.ViewMetadata;
import javax.faces.view.facelets.FaceletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletViewHandlingStrategy
extends ViewHandlingStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private FaceletFactory faceletFactory;
    private String[] extensionsArray;
    private String[] prefixesArray;
    public static final String IS_BUILDING_METADATA = FaceletViewHandlingStrategy.class.getName() + ".IS_BUILDING_METADATA";
    private StateManagementStrategyImpl stateManagementStrategy;
    private boolean partialStateSaving;
    private Set<String> fullStateViewIds;
    private boolean groovyAvailable;

    public FaceletViewHandlingStrategy() {
        this.initialize();
    }

    public static boolean isBuildingMetadata(FacesContext context) {
        boolean result = context.getAttributes().containsKey(IS_BUILDING_METADATA);
        return result;
    }

    public StateManagementStrategy getStateManagementStrategy(FacesContext context, String viewId) {
        return context.getAttributes().containsKey("partialStateSaving") ? this.stateManagementStrategy : null;
    }

    public BeanInfo getComponentMetadata(FacesContext context, Resource ccResource) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        FaceletFactory factory = (FaceletFactory)RequestStateManager.get(context, "com.sun.faces.FACELET_FACTORY");
        VariableMapper orig = ctx.getVariableMapper();
        UIComponent tmp = context.getApplication().createComponent("javax.faces.NamingContainer");
        UIPanel facetComponent = (UIPanel)context.getApplication().createComponent("javax.faces.Panel");
        facetComponent.setRendererType("javax.faces.Group");
        tmp.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", facetComponent);
        tmp.getAttributes().put("javax.faces.application.Resource.ComponentResource", ccResource);
        try {
            Facelet f = factory.getFacelet(ccResource.getURL());
            VariableMapperWrapper wrapper = new VariableMapperWrapper(orig){

                public ValueExpression resolveVariable(String variable) {
                    return super.resolveVariable(variable);
                }
            };
            ctx.setVariableMapper((VariableMapper)wrapper);
            context.getAttributes().put(IS_BUILDING_METADATA, Boolean.TRUE);
            f.apply(context, (UIComponent)facetComponent);
        }
        catch (Exception e) {
            if (e instanceof FacesException) {
                throw (FacesException)((Object)e);
            }
            throw new FacesException((Throwable)e);
        }
        finally {
            context.getAttributes().remove(IS_BUILDING_METADATA);
            ctx.setVariableMapper(orig);
        }
        CompositeComponentBeanInfo result = (CompositeComponentBeanInfo)tmp.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        return result;
    }

    public ViewMetadata getViewMetadata(FacesContext context, String viewId) {
        return new ViewMetadataImpl(viewId);
    }

    public Resource getScriptComponentResource(FacesContext context, Resource componentResource) {
        if (!this.groovyAvailable) {
            return null;
        }
        Resource result = null;
        String resourceName = componentResource.getResourceName();
        if (resourceName.endsWith(".xhtml")) {
            resourceName = resourceName.substring(0, resourceName.length() - 6) + ".groovy";
            ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
            result = resourceHandler.createResource(resourceName, componentResource.getLibraryName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext ctx, UIViewRoot viewToRender) throws IOException {
        if (!viewToRender.isRendered()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Rendering View: " + viewToRender.getViewId());
        }
        WriteBehindStateWriter stateWriter = null;
        try {
            ResponseWriter origWriter;
            if (!Util.isViewPopulated(ctx, viewToRender)) {
                this.buildView(ctx, viewToRender);
            }
            if ((origWriter = ctx.getResponseWriter()) == null) {
                origWriter = this.createResponseWriter(ctx);
            }
            stateWriter = new WriteBehindStateWriter((Writer)origWriter, ctx, this.responseBufferSize);
            ResponseWriter writer = origWriter.cloneWithWriter((Writer)stateWriter);
            ctx.setResponseWriter(writer);
            writer.startDocument();
            viewToRender.encodeAll(ctx);
            writer.endDocument();
            writer.close();
            boolean writtenState = stateWriter.stateWritten();
            if (writtenState) {
                stateWriter.flushToWriter();
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handleFaceletNotFound(ctx, viewToRender.getViewId(), fnfe.getMessage());
        }
        catch (Exception e) {
            this.handleRenderException(ctx, e);
        }
        finally {
            if (stateWriter != null) {
                stateWriter.release();
            }
        }
    }

    @Override
    public UIViewRoot restoreView(FacesContext ctx, String viewId) {
        this.updateStateSavingType(ctx, viewId);
        if (UIDebug.debugRequest(ctx)) {
            ctx.getApplication().createComponent("javax.faces.ViewRoot");
        }
        return super.restoreView(ctx, viewId);
    }

    public void retargetAttachedObjects(FacesContext context, UIComponent topLevelComponent, List<AttachedObjectHandler> handlers) {
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        BeanInfo componentBeanInfo = (BeanInfo)topLevelComponent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (null == componentBeanInfo) {
            return;
        }
        BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
        List targetList = (List)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
        List targetComponents = null;
        block0: for (AttachedObjectHandler curHandler : handlers) {
            String forAttributeValue = curHandler.getFor();
            for (AttachedObjectTarget curTarget : targetList) {
                String curTargetName = curTarget.getName();
                targetComponents = curTarget.getTargets(topLevelComponent);
                if (curHandler instanceof ActionSource2AttachedObjectHandler && curTarget instanceof ActionSource2AttachedObjectTarget) {
                    if (!forAttributeValue.equals(curTargetName)) continue;
                    for (UIComponent curTargetComponent : targetComponents) {
                        this.retargetHandler(context, curHandler, curTargetComponent);
                    }
                    continue block0;
                }
                if (curHandler instanceof EditableValueHolderAttachedObjectHandler && curTarget instanceof EditableValueHolderAttachedObjectTarget) {
                    if (!forAttributeValue.equals(curTargetName)) continue;
                    for (UIComponent curTargetComponent : targetComponents) {
                        this.retargetHandler(context, curHandler, curTargetComponent);
                    }
                    continue block0;
                }
                if (curHandler instanceof ValueHolderAttachedObjectHandler && curTarget instanceof ValueHolderAttachedObjectTarget) {
                    if (!forAttributeValue.equals(curTargetName)) continue;
                    for (UIComponent curTargetComponent : targetComponents) {
                        this.retargetHandler(context, curHandler, curTargetComponent);
                    }
                    continue block0;
                }
                if (!(curHandler instanceof BehaviorHolderAttachedObjectHandler) || !(curTarget instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectHandler behaviorHandler = (BehaviorHolderAttachedObjectHandler)curHandler;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)curTarget;
                String eventName = behaviorHandler.getEventName();
                if ((null == eventName || !eventName.equals(curTargetName)) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                for (UIComponent curTargetComponent : targetComponents) {
                    this.retargetHandler(context, curHandler, curTargetComponent);
                }
            }
        }
    }

    public void retargetMethodExpressions(FacesContext context, UIComponent topLevelComponent) {
        BeanInfo componentBeanInfo = (BeanInfo)topLevelComponent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (null == componentBeanInfo) {
            return;
        }
        PropertyDescriptor[] attributes = componentBeanInfo.getPropertyDescriptors();
        ExpressionFactory expressionFactory = null;
        ValueExpression valueExpression = null;
        MethodExpression toApply = null;
        Class expectedReturnType = null;
        Class[] expectedParameters = null;
        for (PropertyDescriptor cur : attributes) {
            String methodSignature;
            valueExpression = (ValueExpression)cur.getValue("type");
            if (null != valueExpression || null == (valueExpression = (ValueExpression)cur.getValue("method-signature")) || null == (methodSignature = (String)valueExpression.getValue(context.getELContext()))) continue;
            String targets = null;
            valueExpression = (ValueExpression)cur.getValue("targets");
            if (null != valueExpression) {
                targets = (String)valueExpression.getValue(context.getELContext());
            }
            if (targets == null) {
                targets = cur.getName();
            }
            if (null == targets || 0 == targets.length()) {
                LOGGER.severe("Unable to retarget MethodExpression: " + methodSignature);
                continue;
            }
            String[] targetIds = targets.split(" ");
            String attrName = cur.getName();
            Object attrValue = topLevelComponent.getValueExpression(attrName);
            if (null == attrValue && null == (attrValue = cur.getValue("default"))) {
                boolean required;
                ValueExpression req = (ValueExpression)cur.getValue("required");
                boolean bl = required = req != null ? Boolean.valueOf(req.getValue(context.getELContext()).toString()) : false;
                if (!required) continue;
                Object location = topLevelComponent.getAttributes().get("javax.faces.component.VIEW_LOCATION_KEY");
                if (location == null) {
                    location = "";
                }
                throw new FacesException(location.toString() + ": Unable to find attribute with name \"" + attrName + "\" in top level component in consuming page, " + " or with default value in composite component.  " + "Page author or composite component author error.");
            }
            if (null == expressionFactory) {
                expressionFactory = context.getApplication().getExpressionFactory();
            }
            for (String curTarget : targetIds) {
                int j;
                String strValue;
                boolean isAction = false;
                boolean isActionListener = false;
                boolean isValidator = false;
                boolean isValueChangeListener = false;
                isAction = attrName.equals("action");
                if (isAction || (isActionListener = attrName.equals("actionListener")) || (isValidator = attrName.equals("validator")) || (isValueChangeListener = attrName.equals("valueChangeListener"))) {
                    UIComponent target;
                    if (!isAction && attrValue instanceof ValueExpression) {
                        valueExpression = attrValue;
                    }
                    if (null == (target = topLevelComponent.findComponent(curTarget))) {
                        throw new FacesException(valueExpression.toString() + " : Unable to re-target MethodExpression as inner component referenced by target id '" + curTarget + "' cannot be found.");
                    }
                    if (isAction) {
                        expectedReturnType = Object.class;
                        expectedParameters = new Class[]{};
                        String expr = attrValue instanceof ValueExpression ? attrValue.getExpressionString() : attrValue.toString();
                        toApply = expressionFactory.createMethodExpression(context.getELContext(), expr, expectedReturnType, expectedParameters);
                        ((ActionSource2)target).setActionExpression((MethodExpression)new ContextualCompositeMethodExpression(toApply));
                        continue;
                    }
                    if (isActionListener) {
                        expectedReturnType = Void.TYPE;
                        expectedParameters = new Class[]{ActionEvent.class};
                        toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                        MethodExpression noArg = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, new Class[0]);
                        ((ActionSource2)target).addActionListener((ActionListener)new MethodExpressionActionListener((MethodExpression)new ContextualCompositeMethodExpression(toApply), (MethodExpression)new ContextualCompositeMethodExpression(noArg)));
                        continue;
                    }
                    if (isValidator) {
                        expectedReturnType = Void.TYPE;
                        expectedParameters = new Class[]{FacesContext.class, UIComponent.class, Object.class};
                        toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                        ((EditableValueHolder)target).addValidator((Validator)new MethodExpressionValidator((MethodExpression)new ContextualCompositeMethodExpression(toApply)));
                        continue;
                    }
                    if (!isValueChangeListener) continue;
                    expectedReturnType = Void.TYPE;
                    expectedParameters = new Class[]{ValueChangeEvent.class};
                    toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                    MethodExpression noArg = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, new Class[0]);
                    ((EditableValueHolder)target).addValueChangeListener((ValueChangeListener)new MethodExpressionValueChangeListener((MethodExpression)new ContextualCompositeMethodExpression(toApply), (MethodExpression)new ContextualCompositeMethodExpression(noArg)));
                    continue;
                }
                valueExpression = attrValue;
                assert (null != methodSignature);
                int i = (methodSignature = methodSignature.trim()).indexOf(" ");
                if (-1 != i) {
                    strValue = methodSignature.substring(0, i);
                    try {
                        expectedReturnType = Util.getTypeFromString(strValue);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new FacesException(cur.getValue("method-signature") + " : Unable to load type '" + strValue + '\'');
                    }
                } else {
                    LOGGER.severe("Unable to determine expected return type for " + methodSignature);
                    continue;
                }
                i = methodSignature.indexOf("(");
                if (-1 != i && -1 != (j = methodSignature.indexOf(")", i + 1))) {
                    strValue = methodSignature.substring(i + 1, j);
                    if (0 < strValue.length()) {
                        String[] params = strValue.split(",");
                        expectedParameters = new Class[params.length];
                        boolean exceptionThrown = false;
                        for (i = 0; i < params.length; ++i) {
                            try {
                                expectedParameters[i] = Util.getTypeFromString(params[i]);
                                continue;
                            }
                            catch (ClassNotFoundException cnfe) {
                                LOGGER.log(Level.SEVERE, "Unable to determine expected return type for " + methodSignature, cnfe);
                                exceptionThrown = true;
                                break;
                            }
                        }
                        if (exceptionThrown) {
                            continue;
                        }
                    } else {
                        expectedParameters = new Class[]{};
                    }
                }
                assert (null != expectedReturnType);
                assert (null != expectedParameters);
                toApply = expressionFactory.createMethodExpression(context.getELContext(), valueExpression.getExpressionString(), expectedReturnType, expectedParameters);
                topLevelComponent.getAttributes().put(attrName, new ContextualCompositeMethodExpression(toApply));
            }
            topLevelComponent.setValueExpression(cur.getName(), null);
        }
    }

    @Override
    public UIViewRoot createView(FacesContext ctx, String viewId) {
        if (UIDebug.debugRequest(ctx)) {
            UIViewRoot root = (UIViewRoot)ctx.getApplication().createComponent("javax.faces.ViewRoot");
            root.setViewId(viewId);
            return root;
        }
        return super.createView(ctx, viewId);
    }

    @Override
    public boolean handlesViewId(String viewId) {
        if (viewId != null) {
            int i;
            if (this.extensionsArray == null && this.prefixesArray == null) {
                return viewId.endsWith(".xhtml");
            }
            if (this.extensionsArray != null) {
                for (i = 0; i < this.extensionsArray.length; ++i) {
                    String extension = this.extensionsArray[i];
                    if (!viewId.endsWith(extension)) continue;
                    return true;
                }
            }
            if (this.prefixesArray != null) {
                for (i = 0; i < this.prefixesArray.length; ++i) {
                    String prefix = this.prefixesArray[i];
                    if (!viewId.startsWith(prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void buildView(FacesContext ctx, UIViewRoot view) throws IOException {
        if (Util.isViewPopulated(ctx, view)) {
            return;
        }
        this.updateStateSavingType(ctx, view.getViewId());
        view.setViewId(view.getViewId());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building View: " + view.getViewId());
        }
        if (this.faceletFactory == null) {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(ctx.getExternalContext());
            this.faceletFactory = associate.getFaceletFactory();
            assert (this.faceletFactory != null);
        }
        RequestStateManager.set(ctx, "com.sun.faces.FACELET_FACTORY", this.faceletFactory);
        Facelet f = this.faceletFactory.getFacelet(view.getViewId());
        f.apply(ctx, (UIComponent)view);
        this.doPostBuildActions(view);
        Util.setViewPopulated(ctx, view);
    }

    protected void initialize() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Initializing FaceletViewHandlingStrategy");
        }
        this.initializeMappings();
        WebConfiguration config = WebConfiguration.getInstance();
        this.partialStateSaving = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving);
        if (this.partialStateSaving) {
            String[] viewIds = config.getOptionValue(WebConfiguration.WebContextInitParameter.FullStateSavingViewIds, ",");
            this.fullStateViewIds = new HashSet<String>(viewIds.length, 1.0f);
            this.fullStateViewIds.addAll(Arrays.asList(viewIds));
            this.stateManagementStrategy = new StateManagementStrategyImpl(this);
        }
        this.groovyAvailable = GroovyHelper.isGroovyAvailable(FacesContext.getCurrentInstance());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Initialization Successful");
        }
    }

    protected void initializeMappings() {
        String viewMappings = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.FaceletsViewMappings);
        if (viewMappings != null && viewMappings.length() > 0) {
            String[] mappingsArray = Util.split(viewMappings, ";");
            ArrayList<String> extensionsList = new ArrayList<String>(mappingsArray.length);
            ArrayList<String> prefixesList = new ArrayList<String>(mappingsArray.length);
            for (int i = 0; i < mappingsArray.length; ++i) {
                String mapping = mappingsArray[i].trim();
                int mappingLength = mapping.length();
                if (mappingLength <= 1) continue;
                if (mapping.charAt(0) == '*') {
                    extensionsList.add(mapping.substring(1));
                    continue;
                }
                if (mapping.charAt(mappingLength - 1) != '*') continue;
                prefixesList.add(mapping.substring(0, mappingLength - 1));
            }
            this.extensionsArray = new String[extensionsList.size()];
            extensionsList.toArray(this.extensionsArray);
            this.prefixesArray = new String[prefixesList.size()];
            prefixesList.toArray(this.prefixesArray);
        }
    }

    protected Compiler createCompiler() {
        return new SAXCompiler();
    }

    protected ResponseWriter createResponseWriter(FacesContext context) throws IOException {
        ExternalContext extContext = context.getExternalContext();
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            String id = context.getViewRoot().getRenderKitId();
            throw new IllegalStateException("No render kit was available for id \"" + id + "\"");
        }
        if (this.responseBufferSizeSet) {
            extContext.setResponseBufferSize(this.responseBufferSize);
        }
        String contentType = (String)context.getAttributes().get("facelets.ContentType");
        String encoding = (String)context.getAttributes().get("facelets.Encoding");
        ResponseWriter writer = renderKit.createResponseWriter((Writer)NullWriter.Instance, contentType, encoding);
        contentType = this.getResponseContentType(context, writer.getContentType());
        encoding = this.getResponseEncoding(context, writer.getCharacterEncoding());
        extContext.setResponseContentType(contentType);
        extContext.setResponseCharacterEncoding(encoding);
        writer = writer.cloneWithWriter(extContext.getResponseOutputWriter());
        return writer;
    }

    protected void handleRenderException(FacesContext context, Exception e) throws IOException {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            UIViewRoot root = context.getViewRoot();
            StringBuffer sb = new StringBuffer(64);
            sb.append("Error Rendering View");
            if (root != null) {
                sb.append('[');
                sb.append(root.getViewId());
                sb.append(']');
            }
            LOGGER.log(Level.SEVERE, sb.toString(), e);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new FacesException(e.getMessage(), (Throwable)e);
    }

    protected void handleFaceletNotFound(FacesContext context, String viewId, String message) throws IOException {
        context.getExternalContext().responseSendError(404, message != null ? viewId + ": " + message : viewId);
        context.responseComplete();
    }

    protected String getResponseEncoding(FacesContext context, String orig) {
        String encoding = orig;
        Map ctxAttributes = context.getAttributes();
        Map sessionMap = context.getExternalContext().getSessionMap();
        if (ctxAttributes.containsKey("facelets.Encoding")) {
            encoding = (String)ctxAttributes.get("facelets.Encoding");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Facelet specified alternate encoding {0}", encoding);
            }
            sessionMap.put("javax.faces.request.charset", encoding);
        }
        if (encoding == null) {
            encoding = context.getExternalContext().getRequestCharacterEncoding();
        }
        if (encoding == null) {
            encoding = (String)sessionMap.get("javax.faces.request.charset");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Session specified alternate encoding {0}", encoding);
            }
        }
        if (encoding == null) {
            encoding = "UTF-8";
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("ResponseWriter created had a null CharacterEncoding, defaulting to UTF-8");
            }
        }
        return encoding;
    }

    protected String getResponseContentType(FacesContext context, String orig) {
        String contentType = orig;
        Map m = context.getAttributes();
        if (m.containsKey("facelets.ContentType")) {
            contentType = (String)m.get("facelets.ContentType");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Facelet specified alternate contentType '" + contentType + "'");
            }
        }
        if (contentType == null) {
            contentType = "text/html";
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("ResponseWriter created had a null ContentType, defaulting to text/html");
            }
        }
        return contentType;
    }

    private void updateStateSavingType(FacesContext ctx, String viewId) {
        if (!ctx.getAttributes().containsKey("partialStateSaving")) {
            ctx.getAttributes().put("partialStateSaving", this.usePartialSaving(viewId));
        }
    }

    private boolean usePartialSaving(String viewId) {
        return this.partialStateSaving && !this.fullStateViewIds.contains(viewId);
    }

    private void doPostBuildActions(UIViewRoot root) {
        if (this.usePartialSaving(root.getViewId())) {
            root.markInitialState();
            this.stateManagementStrategy.notifyTrackChanges(root);
        }
    }

    private void retargetHandler(FacesContext context, AttachedObjectHandler handler, UIComponent targetComponent) {
        if (UIComponent.isCompositeComponent((UIComponent)targetComponent)) {
            List<AttachedObjectHandler> nHandlers = CompositeComponentTagHandler.getAttachedObjectHandlers(targetComponent);
            nHandlers.add(handler);
            this.retargetAttachedObjects(context, targetComponent, nHandlers);
        } else {
            handler.applyAttachedObject(context, targetComponent);
        }
    }

    protected static final class NullWriter
    extends Writer {
        static final NullWriter Instance = new NullWriter();

        protected NullWriter() {
        }

        public void write(char[] buffer) {
        }

        public void write(char[] buffer, int off, int len) {
        }

        public void write(String str) {
        }

        public void write(int c) {
        }

        public void write(String str, int off, int len) {
        }

        public void close() {
        }

        public void flush() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContextualCompositeMethodExpression
    extends MethodExpression {
        private MethodExpression delegate;

        public ContextualCompositeMethodExpression(MethodExpression delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MethodInfo getMethodInfo(ELContext elContext) {
            FacesContext ctx = (FacesContext)elContext.getContext(FacesContext.class);
            boolean pushed = this.pushCompositeComponent(ctx);
            try {
                MethodInfo methodInfo = this.delegate.getMethodInfo(elContext);
                return methodInfo;
            }
            finally {
                if (pushed) {
                    this.popCompositeComponent(ctx);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(ELContext elContext, Object[] objects) {
            FacesContext ctx = (FacesContext)elContext.getContext(FacesContext.class);
            boolean pushed = this.pushCompositeComponent(ctx);
            try {
                Object object = this.delegate.invoke(elContext, objects);
                return object;
            }
            finally {
                if (pushed) {
                    this.popCompositeComponent(ctx);
                }
            }
        }

        public String getExpressionString() {
            return this.delegate.getExpressionString();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isLiteralText() {
            return this.delegate.isLiteralText();
        }

        private boolean pushCompositeComponent(FacesContext ctx) {
            UIComponent ccp = UIComponent.getCompositeComponentParent((UIComponent)UIComponent.getCurrentCompositeComponent((FacesContext)ctx));
            Stack<UIComponent> stack = this.getStack(ctx, true);
            if (ccp != null) {
                stack.push(ccp);
                return true;
            }
            return false;
        }

        private void popCompositeComponent(FacesContext ctx) {
            Stack<UIComponent> stack = this.getStack(ctx, false);
            if (stack == null) {
                return;
            }
            if (!stack.isEmpty()) {
                stack.pop();
            }
        }

        private Stack<UIComponent> getStack(FacesContext ctx, boolean create) {
            Stack stack = (Stack)RequestStateManager.get(ctx, "com.sun.faces.COMPCOMP_STACK");
            if (stack == null && create) {
                stack = new Stack();
                RequestStateManager.set(ctx, "com.sun.faces.COMPCOMP_STACK", stack);
            }
            return stack;
        }
    }
}

