/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.UEncoder;
import com.sun.grizzly.util.http.FastHttpDateFormat;
import com.sun.grizzly.util.http.ServerCookie;
import com.sun.grizzly.util.net.URL;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.apache.catalina.connector.CoyoteWriter;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response
implements HttpResponse,
HttpServletResponse {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(Response.class.getName());
    private static boolean enforceScope = false;
    public static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected static final String info = "org.apache.catalina.connector.Response/1.0";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    private String detailErrorMsg;
    protected SimpleDateFormat format = null;
    protected Context context = null;
    protected Connector connector;
    protected com.sun.grizzly.tcp.Response coyoteResponse;
    protected OutputBuffer outputBuffer;
    protected CoyoteOutputStream outputStream;
    protected CoyoteWriter writer;
    protected boolean appCommitted = false;
    protected boolean included = false;
    private boolean isCharacterEncodingSet = false;
    private boolean isContentTypeSet = false;
    protected boolean error = false;
    protected ArrayList cookies = new ArrayList();
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected UEncoder urlEncoder = new UEncoder();
    protected CharChunk redirectURLCC = new CharChunk();
    protected Request request = null;
    protected ResponseFacade facade = null;

    public Response() {
        this.outputBuffer = new OutputBuffer();
        this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        this.writer = this.createWriter(this.outputBuffer);
        this.urlEncoder.addSafeCharacter('/');
    }

    public Response(boolean chunkingDisabled) {
        this.outputBuffer = new OutputBuffer(chunkingDisabled);
        this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        this.writer = this.createWriter(this.outputBuffer);
        this.urlEncoder.addSafeCharacter('/');
    }

    public static void setEnforceScope(boolean enforce) {
        enforceScope = enforce;
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setCoyoteResponse(com.sun.grizzly.tcp.Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
        this.outputBuffer.setCoyoteResponse(this);
    }

    public com.sun.grizzly.tcp.Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    @Override
    public Context getContext() {
        return this.request.getContext();
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void recycle() {
        if (this.request != null && this.request.isAsyncStarted()) {
            return;
        }
        this.context = null;
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.error = false;
        this.isContentTypeSet = false;
        this.isCharacterEncodingSet = false;
        this.detailErrorMsg = null;
        this.cookies.clear();
        if (enforceScope) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.outputStream != null) {
                this.outputStream.clear();
                this.outputStream = null;
            }
            if (this.writer != null) {
                this.writer.clear();
                this.writer = null;
            }
        } else {
            this.writer.recycle();
        }
    }

    @Override
    public int getContentCount() {
        return this.outputBuffer.getContentWritten();
    }

    @Override
    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    @Override
    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted() || this.isSuspended() || this.getContentLength() > 0 && this.getContentCount() >= this.getContentLength();
    }

    @Override
    public boolean getIncluded() {
        return this.included;
    }

    @Override
    public void setIncluded(boolean included) {
        this.included = included;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public org.apache.catalina.Request getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(org.apache.catalina.Request request) {
        this.request = (Request)request;
    }

    @Override
    public HttpServletResponse getResponse() {
        if (this.facade == null) {
            this.facade = new ResponseFacade(this);
        }
        return this.facade;
    }

    @Override
    public OutputStream getStream() {
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public void setStream(OutputStream stream) {
    }

    @Override
    public void setSuspended(boolean suspended) {
        this.outputBuffer.setSuspended(suspended);
    }

    @Override
    public boolean isSuspended() {
        return this.outputBuffer.isSuspended();
    }

    @Override
    public void setError() {
        this.error = true;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setDetailMessage(String message) {
        this.detailErrorMsg = message;
    }

    @Override
    public String getDetailMessage() {
        return this.detailErrorMsg;
    }

    @Override
    public ServletOutputStream createOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public void finishResponse() throws IOException {
        try {
            this.outputBuffer.close();
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            this.log("Error during finishResponse", t);
        }
    }

    @Override
    public int getContentLength() {
        return this.coyoteResponse.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.coyoteResponse.getContentType();
    }

    @Override
    public PrintWriter getReporter() throws IOException {
        if (this.outputBuffer.isNew()) {
            this.outputBuffer.checkConverter();
            if (this.writer == null) {
                this.writer = this.createWriter(this.outputBuffer);
            }
            return this.writer;
        }
        return null;
    }

    @Override
    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    @Override
    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    @Override
    public String getCharacterEncoding() {
        return this.coyoteResponse.getCharacterEncoding();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getOutputStream.ise"));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public Locale getLocale() {
        return this.coyoteResponse.getLocale();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getWriter.ise"));
        }
        this.setCharacterEncoding(this.getCharacterEncoding());
        this.usingWriter = true;
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = this.createWriter(this.outputBuffer);
        }
        return this.writer;
    }

    @Override
    public boolean isCommitted() {
        return this.coyoteResponse.isCommitted();
    }

    @Override
    public void reset() {
        if (this.included) {
            return;
        }
        this.coyoteResponse.reset();
        this.outputBuffer.reset();
    }

    @Override
    public void resetBuffer() {
        this.resetBuffer(false);
    }

    @Override
    public void resetBuffer(boolean resetWriterStreamFlags) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.resetBuffer.ise"));
        }
        this.outputBuffer.reset();
        if (resetWriterStreamFlags) {
            this.usingOutputStream = false;
            this.usingWriter = false;
            this.isCharacterEncodingSet = false;
        }
    }

    @Override
    public void setBufferSize(int size) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.setBufferSize.ise"));
        }
        this.outputBuffer.setBufferSize(size);
    }

    @Override
    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.coyoteResponse.setContentLength(length);
    }

    @Override
    public void setContentType(String type) {
        int index;
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter && type != null && (index = type.indexOf(";")) != -1) {
            type = type.substring(0, index);
        }
        this.coyoteResponse.setContentType(type);
        if (type != null && (index = type.indexOf(";")) != -1) {
            int len = type.length();
            ++index;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 7 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                this.isCharacterEncodingSet = true;
            }
        }
        this.isContentTypeSet = true;
    }

    @Override
    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.coyoteResponse.setCharacterEncoding(charset);
        this.isCharacterEncodingSet = true;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setLocale(locale);
        if (this.usingWriter) {
            return;
        }
        if (this.isCharacterEncodingSet) {
            return;
        }
        CharsetMapper cm = this.getContext().getCharsetMapper();
        String charset = cm.getCharset(locale);
        if (charset != null) {
            this.coyoteResponse.setCharacterEncoding(charset);
        }
    }

    @Override
    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    @Override
    public String getHeader(String name) {
        return this.coyoteResponse.getMimeHeaders().getHeader(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return Collections.list(this.coyoteResponse.getMimeHeaders().names());
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return Collections.list(this.coyoteResponse.getMimeHeaders().values(name));
    }

    @Override
    public String getMessage() {
        return this.coyoteResponse.getMessage();
    }

    @Override
    public int getStatus() {
        return this.coyoteResponse.getStatus();
    }

    @Override
    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.cookies.add(cookie);
        String cookieValue = this.getCookieString(cookie);
        this.addHeader("Set-Cookie", cookieValue);
    }

    @Override
    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate(value, this.format));
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.addHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.coyoteResponse.containsHeader(name);
    }

    @Override
    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            String sessionVersion = null;
            HashMap sessionVersions = (HashMap)this.request.getAttribute("com.sun.enterprise.http.sessionVersions");
            if (sessionVersions != null) {
                sessionVersion = RequestUtil.makeSessionVersionString(sessionVersions);
            }
            return this.toEncoded(url, this.request.getSessionInternal().getIdInternal(), sessionVersion);
        }
        return url;
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    @Override
    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            String sessionVersion = null;
            HashMap sessionVersions = (HashMap)this.request.getAttribute("com.sun.enterprise.http.sessionVersions");
            if (sessionVersions != null) {
                sessionVersion = RequestUtil.makeSessionVersionString(sessionVersions);
            }
            return this.toEncoded(url, this.request.getSessionInternal().getIdInternal(), sessionVersion);
        }
        return url;
    }

    @Override
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Override
    public void sendAcknowledgement() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.acknowledge();
    }

    @Override
    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        Wrapper wrapper = this.getRequest().getWrapper();
        if (wrapper != null) {
            wrapper.incrementErrorCount();
        }
        this.setError();
        this.coyoteResponse.setStatus(status);
        this.coyoteResponse.setMessage(message);
        this.resetBuffer();
        this.setSuspended(true);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(location, true);
    }

    public void sendRedirect(String location, boolean isTemporary) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.getContext().getAllowRelativeRedirect() ? location : this.toAbsolute(location);
            if (isTemporary) {
                this.setStatus(302);
            } else {
                this.setStatus(301);
            }
            this.setHeader("Location", absolute);
            this.setContentType("text/html");
            this.setLocale(Locale.getDefault());
            String href = RequestUtil.filter(absolute);
            StringBuilder sb = new StringBuilder(150 + href.length());
            sb.append("<html>\r\n");
            sb.append("<head><title>Document moved</title></head>\r\n");
            sb.append("<body><h1>Document moved</h1>\r\n");
            sb.append("This document has moved <a href=\"");
            sb.append(href);
            sb.append("\">here</a>.<p>\r\n");
            sb.append("</body>\r\n");
            sb.append("</html>\r\n");
            try {
                this.getWriter().write(sb.toString());
            }
            catch (IllegalStateException ise1) {
                try {
                    this.getOutputStream().print(sb.toString());
                }
                catch (IllegalStateException ise2) {}
            }
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    @Override
    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate(value, this.format));
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    @Override
    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    @Override
    public void setStatus(int status, String message) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setStatus(status);
        this.coyoteResponse.setMessage(message);
    }

    protected boolean isEncodeable(final String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        final Request hreq = this.request;
        final Session session = hreq.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie() || this.getContext() != null && !this.getContext().isEnableURLRewriting()) {
            return false;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Response.this.doIsEncodeable(hreq, session, location);
                }
            });
        }
        return this.doIsEncodeable(hreq, session, location);
    }

    private boolean doIsEncodeable(Request hreq, Session session, String location) {
        String contextPath;
        int urlPort;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        Context ctx = this.getContext();
        if (ctx != null && (contextPath = ctx.getPath()) != null) {
            String sessionParamName;
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            String string = sessionParamName = ctx.isSessionCookieConfigInitialized() && ctx.getSessionCookieName() != null ? ctx.getSessionCookieName() : "jsessionid";
            if (file.indexOf(";" + sessionParamName + "=" + session.getIdInternal()) >= 0) {
                return false;
            }
        }
        return true;
    }

    protected String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !leadingSlash && location.indexOf("://") == -1) {
            ProxyHandler proxyHandler;
            this.redirectURLCC.recycle();
            String scheme = this.request.getScheme();
            if (this.getConnector() != null && this.getConnector().getAuthPassthroughEnabled() && (proxyHandler = this.getConnector().getProxyHandler()) != null && proxyHandler.getSSLKeysize((HttpServletRequest)this.request) > 0) {
                scheme = "https";
            }
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            try {
                this.redirectURLCC.append(scheme, 0, scheme.length());
                this.redirectURLCC.append("://", 0, 3);
                this.redirectURLCC.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    this.redirectURLCC.append(':');
                    String portS = port + "";
                    this.redirectURLCC.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = relativePath.substring(0, pos);
                    String encodedURI = null;
                    final String frelativePath = relativePath;
                    if (SecurityUtil.isPackageProtectionEnabled()) {
                        try {
                            encodedURI = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return Response.this.urlEncoder.encodeURL(frelativePath);
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            IllegalArgumentException iae = new IllegalArgumentException(location);
                            iae.initCause(pae.getCause());
                            throw iae;
                        }
                    } else {
                        encodedURI = this.urlEncoder.encodeURL(relativePath);
                    }
                    this.redirectURLCC.append(encodedURI, 0, encodedURI.length());
                    this.redirectURLCC.append('/');
                }
                this.redirectURLCC.append(location, 0, location.length());
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(location);
                iae.initCause(e);
                throw iae;
            }
            return this.redirectURLCC.toString();
        }
        return location;
    }

    protected String toEncoded(String url, String sessionId) {
        return this.toEncoded(url, sessionId, null);
    }

    private String toEncoded(String url, String sessionId, String sessionVersion) {
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            String jrouteId;
            StandardContext ctx = (StandardContext)this.getContext();
            String sessionParamName = ctx != null && ctx.isSessionCookieConfigInitialized() && ctx.getSessionCookieName() != null ? ctx.getSessionCookieName() : "jsessionid";
            sb.append(";" + sessionParamName + "=");
            sb.append(sessionId);
            if (ctx != null && ctx.getJvmRoute() != null) {
                sb.append('.').append(ctx.getJvmRoute());
            }
            if ((jrouteId = this.request.getHeader("proxy-jroute")) != null) {
                sb.append(":");
                sb.append(jrouteId);
            }
            if (sessionVersion != null) {
                sb.append(";jsessionidversion=");
                sb.append(sessionVersion);
            }
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    protected CoyoteWriter createWriter(OutputBuffer outbuf) {
        return new CoyoteWriter(outbuf);
    }

    protected String getCookieString(final Cookie cookie) {
        String cookieValue = null;
        final StringBuffer sb = new StringBuffer();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            cookieValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure(), cookie.isHttpOnly());
                    return sb.toString();
                }
            });
        } else {
            ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure(), cookie.isHttpOnly());
            cookieValue = sb.toString();
        }
        return cookieValue;
    }

    public void removeSessionCookies() {
        this.coyoteResponse.removeSessionCookies();
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        if (this.connector != null && this.connector.getContainer() != null) {
            logger = this.connector.getContainer().getLogger();
        }
        String localName = "Response";
        if (logger != null) {
            logger.log(localName + " " + message, t, 2);
        } else {
            log.log(Level.WARNING, localName + " " + message, t);
        }
    }
}

