/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.ConstructorSignature;
import org.jboss.webbeans.introspector.MethodSignature;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBConstructor;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.jlr.AbstractWBType;
import org.jboss.webbeans.introspector.jlr.WBConstructorImpl;
import org.jboss.webbeans.introspector.jlr.WBFieldImpl;
import org.jboss.webbeans.introspector.jlr.WBMethodImpl;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBClassImpl<T>
extends AbstractWBType<T>
implements WBClass<T> {
    private static List<Class<?>> NO_ARGUMENTS = Collections.emptyList();
    private final Set<WBField<?>> fields = new HashSet();
    private final SetMultimap<Class<? extends Annotation>, WBField<?>> annotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBField<?>>>(){

        @Override
        public Set<WBField<?>> get() {
            return new HashSet();
        }
    });
    private final SetMultimap<Class<? extends Annotation>, WBField<?>> metaAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBField<?>>>(){

        @Override
        public Set<WBField<?>> get() {
            return new HashSet();
        }
    });
    private final Set<WBField<?>> declaredFields = new HashSet();
    private final Map<String, WBField<?>> declaredFieldsByName = new HashMap();
    private final SetMultimap<Class<? extends Annotation>, WBField<?>> declaredAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBField<?>>>(){

        @Override
        public Set<WBField<?>> get() {
            return new HashSet();
        }
    });
    private final SetMultimap<Class<? extends Annotation>, WBField<?>> declaredMetaAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBField<?>>>(){

        @Override
        public Set<WBField<?>> get() {
            return new HashSet();
        }
    });
    private final Set<WBMethod<?>> methods;
    private final Map<MethodSignature, WBMethod<?>> declaredMethodsBySignature;
    private final Map<MethodSignature, WBMethod<?>> methodsBySignature;
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?>> annotatedMethods;
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?>> methodsByAnnotatedParameters;
    private final Set<WBMethod<?>> declaredMethods;
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?>> declaredAnnotatedMethods;
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?>> declaredMethodsByAnnotatedParameters;
    private final Set<WBConstructor<T>> constructors;
    private final Map<ConstructorSignature, WBConstructor<?>> declaredConstructorsBySignature;
    private final SetMultimap<Class<? extends Annotation>, WBConstructor<T>> annotatedConstructors;
    private final Map<List<Class<?>>, WBConstructor<T>> constructorsByArgumentMap;
    private final SetMultimap<Class<? extends Annotation>, WBConstructor<?>> constructorsByAnnotatedParameters;
    private String toString;
    private final boolean _nonStaticMemberClass;
    private final boolean _abstract;
    private final boolean _enum;

    public static <T> WBClass<T> of(Class<T> clazz, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(clazz.getAnnotations(), clazz.getDeclaredAnnotations(), classTransformer.getTypeStore());
        return new WBClassImpl<T>(clazz, clazz, annotationStore, classTransformer);
    }

    public static <T> WBClass<T> of(AnnotatedType<T> annotatedType, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(annotatedType.getAnnotations(), annotatedType.getAnnotations(), classTransformer.getTypeStore());
        return new WBClassImpl<T>(annotatedType.getJavaClass(), annotatedType.getBaseType(), annotationStore, classTransformer);
    }

    private WBClassImpl(Class<T> rawType, Type type, AnnotationStore annotationStore, ClassTransformer classTransformer) {
        super(annotationStore, rawType, type, classTransformer);
        Class<T> c;
        this._nonStaticMemberClass = Reflections.isNonStaticInnerClass(rawType);
        this._abstract = Reflections.isAbstract(rawType);
        this._enum = rawType.isEnum();
        for (c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                WBFieldImpl annotatedField = new WBFieldImpl(field, this, classTransformer);
                this.fields.add(annotatedField);
                if (c == rawType) {
                    this.declaredFields.add(annotatedField);
                    this.declaredFieldsByName.put(annotatedField.getName(), annotatedField);
                }
                for (Annotation annotation : annotatedField.getAnnotations()) {
                    this.annotatedFields.put(annotation.annotationType(), annotatedField);
                    if (c == rawType) {
                        this.declaredAnnotatedFields.put(annotation.annotationType(), annotatedField);
                    }
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.metaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                        if (c != rawType) continue;
                        this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                    }
                }
            }
        }
        this.constructors = new HashSet<WBConstructor<T>>();
        this.constructorsByArgumentMap = new HashMap();
        this.annotatedConstructors = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBConstructor<T>>>(){

            @Override
            public Set<WBConstructor<T>> get() {
                return new HashSet();
            }
        });
        this.constructorsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBConstructor<?>>>(){

            @Override
            public Set<WBConstructor<?>> get() {
                return new HashSet();
            }
        });
        this.declaredConstructorsBySignature = new HashMap();
        Constructor<?>[] arr$ = rawType.getDeclaredConstructors();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Constructor<?> constructor;
            Constructor<?> c2 = constructor = arr$[i$];
            WBConstructor<?> annotatedConstructor = WBConstructorImpl.of(c2, this, classTransformer);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            this.constructors.add(annotatedConstructor);
            this.constructorsByArgumentMap.put(Arrays.asList(constructor.getParameterTypes()), annotatedConstructor);
            this.declaredConstructorsBySignature.put(annotatedConstructor.getSignature(), annotatedConstructor);
            for (Annotation annotation : annotatedConstructor.getAnnotations()) {
                if (!this.annotatedConstructors.containsKey(annotation.annotationType())) {
                    this.annotatedConstructors.putAll(annotation.annotationType(), new HashSet());
                }
                this.annotatedConstructors.get(annotation.annotationType()).add(annotatedConstructor);
            }
            for (Class clazz : WBConstructor.MAPPED_PARAMETER_ANNOTATIONS) {
                if (annotatedConstructor.getAnnotatedParameters(clazz).size() <= 0) continue;
                this.constructorsByAnnotatedParameters.put(clazz, annotatedConstructor);
            }
        }
        this.methods = new HashSet();
        this.annotatedMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?>>>(){

            @Override
            public Set<WBMethod<?>> get() {
                return new HashSet();
            }
        });
        this.methodsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?>>>(){

            @Override
            public Set<WBMethod<?>> get() {
                return new HashSet();
            }
        });
        this.declaredMethods = new HashSet();
        this.declaredAnnotatedMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?>>>(){

            @Override
            public Set<WBMethod<?>> get() {
                return new HashSet();
            }
        });
        this.declaredMethodsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?>>>(){

            @Override
            public Set<WBMethod<?>> get() {
                return new HashSet();
            }
        });
        this.declaredMethodsBySignature = new HashMap();
        this.methodsBySignature = new HashMap();
        for (c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                WBMethodImpl annotatedMethod = WBMethodImpl.of(method, this, classTransformer);
                this.methods.add(annotatedMethod);
                this.methodsBySignature.put(annotatedMethod.getSignature(), annotatedMethod);
                if (c == rawType) {
                    this.declaredMethods.add(annotatedMethod);
                    this.declaredMethodsBySignature.put(annotatedMethod.getSignature(), annotatedMethod);
                }
                for (Annotation annotation : annotatedMethod.getAnnotations()) {
                    this.annotatedMethods.put(annotation.annotationType(), annotatedMethod);
                    if (c != rawType) continue;
                    this.declaredAnnotatedMethods.put(annotation.annotationType(), annotatedMethod);
                }
                for (Class clazz : WBMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (annotatedMethod.getAnnotatedParameters(clazz).size() <= 0) continue;
                    this.methodsByAnnotatedParameters.put(clazz, annotatedMethod);
                    if (c != rawType) continue;
                    this.declaredMethodsByAnnotatedParameters.put(clazz, annotatedMethod);
                }
            }
        }
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.getJavaClass();
    }

    @Override
    public Class<T> getDelegate() {
        return this.getJavaClass();
    }

    @Override
    public Set<WBField<?>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<WBField<?>> getDeclaredFields() {
        return Collections.unmodifiableSet(this.declaredFields);
    }

    @Override
    public <F> WBField<F> getDeclaredField(String fieldName, WBClass<F> expectedType) {
        return this.declaredFieldsByName.get(fieldName);
    }

    @Override
    public Set<WBField<?>> getDeclaredAnnotatedFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public Set<WBConstructor<T>> getConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    @Override
    public WBConstructor<T> getDeclaredConstructor(ConstructorSignature signature) {
        return this.declaredConstructorsBySignature.get(signature);
    }

    @Override
    public Set<WBField<?>> getMetaAnnotatedFields(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.metaAnnotatedFields.get(metaAnnotationType));
    }

    @Override
    public Set<WBField<?>> getAnnotatedFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedFields.get(annotationType));
    }

    @Override
    public boolean isNonStaticMemberClass() {
        return this._nonStaticMemberClass;
    }

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public boolean isEnum() {
        return this._enum;
    }

    @Override
    public Set<WBMethod<?>> getAnnotatedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Set<WBMethod<?>> getDeclaredAnnotatedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Set<WBConstructor<T>> getAnnotatedConstructors(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedConstructors.get(annotationType));
    }

    @Override
    public WBConstructor<T> getNoArgsConstructor() {
        return this.constructorsByArgumentMap.get(NO_ARGUMENTS);
    }

    @Override
    public Set<WBMethod<?>> getMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.methodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public Set<WBConstructor<?>> getConstructorsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.constructorsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public Set<WBMethod<?>> getDeclaredMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public WBMethod<?> getMethod(Method methodDescriptor) {
        for (WBMethod<?> annotatedMethod : this.methods) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Set<WBMethod<?>> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public WBMethod<?> getDeclaredMethod(Method method) {
        for (WBMethod<?> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public <M> WBMethod<M> getDeclaredMethod(MethodSignature signature, WBClass<M> expectedReturnType) {
        return this.declaredMethodsBySignature.get(signature);
    }

    @Override
    public <M> WBMethod<M> getMethod(MethodSignature signature) {
        return this.methodsBySignature.get(signature);
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated class " + Names.classToString(this.getDelegate());
        return this.toString;
    }

    @Override
    public <U> WBClass<? extends U> asSubclass(WBClass<U> clazz) {
        return this;
    }

    @Override
    public T cast(Object object) {
        return (T)object;
    }
}

