/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata.cache;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.metadata.cache.BindingTypeModel;
import org.jboss.webbeans.metadata.cache.ScopeModel;
import org.jboss.webbeans.metadata.cache.StereotypeModel;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAnnotationStore
implements Service {
    private ConcurrentCache<Class<? extends Annotation>, StereotypeModel<?>> stereotypes = new ConcurrentCache();
    private ConcurrentCache<Class<? extends Annotation>, ScopeModel<?>> scopes = new ConcurrentCache();
    private ConcurrentCache<Class<? extends Annotation>, BindingTypeModel<?>> bindingTypes = new ConcurrentCache();
    private final ClassTransformer classTransformer;

    public MetaAnnotationStore(ClassTransformer classTransformer) {
        this.classTransformer = classTransformer;
    }

    public <T extends Annotation> StereotypeModel<T> getStereotype(final Class<T> stereotype) {
        return (StereotypeModel)this.stereotypes.putIfAbsent(stereotype, new Callable<StereotypeModel<T>>(){

            @Override
            public StereotypeModel<T> call() throws Exception {
                return new StereotypeModel(stereotype, MetaAnnotationStore.this.classTransformer);
            }
        });
    }

    public <T extends Annotation> ScopeModel<T> getScopeModel(final Class<T> scopeType) {
        return (ScopeModel)this.scopes.putIfAbsent(scopeType, new Callable<ScopeModel<T>>(){

            @Override
            public ScopeModel<T> call() throws Exception {
                return new ScopeModel(scopeType, MetaAnnotationStore.this.classTransformer);
            }
        });
    }

    public <T extends Annotation> BindingTypeModel<T> getBindingTypeModel(final Class<T> bindingType) {
        return (BindingTypeModel)this.bindingTypes.putIfAbsent(bindingType, new Callable<BindingTypeModel<T>>(){

            @Override
            public BindingTypeModel<T> call() throws Exception {
                return new BindingTypeModel(bindingType, MetaAnnotationStore.this.classTransformer);
            }
        });
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Metadata cache\n");
        buffer.append("Registered binding type models: " + this.bindingTypes.size() + "\n");
        buffer.append("Registered scope type models: " + this.scopes.size() + "\n");
        buffer.append("Registered stereotype models: " + this.stereotypes.size() + "\n");
        return buffer.toString();
    }
}

