/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata.cache;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ScopeType;
import javax.enterprise.inject.BindingType;
import javax.enterprise.inject.Named;
import javax.enterprise.inject.deployment.DeploymentType;
import javax.enterprise.inject.stereotype.Stereotype;
import javax.interceptor.InterceptorBindingType;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.metadata.cache.AnnotationModel;
import org.jboss.webbeans.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeModel<T extends Annotation>
extends AnnotationModel<T> {
    private Annotation defaultDeploymentType;
    private Annotation defaultScopeType;
    private boolean beanNameDefaulted;
    private Set<Annotation> interceptorBindings;

    public StereotypeModel(Class<T> sterotype, ClassTransformer transformer) {
        super(sterotype, transformer);
        this.initDefaultDeploymentType();
        this.initDefaultScopeType();
        this.initBeanNameDefaulted();
        this.initInterceptorBindings();
        this.checkBindings();
    }

    private void checkBindings() {
        Set<Annotation> bindings = this.getAnnotatedAnnotation().getMetaAnnotations(BindingType.class);
        if (bindings.size() > 0) {
            throw new DefinitionException("Cannot declare binding types on a stereotype " + this.getAnnotatedAnnotation());
        }
    }

    private void initInterceptorBindings() {
        this.interceptorBindings = this.getAnnotatedAnnotation().getMetaAnnotations(InterceptorBindingType.class);
    }

    private void initBeanNameDefaulted() {
        if (this.getAnnotatedAnnotation().isAnnotationPresent(Named.class)) {
            if (!"".equals(this.getAnnotatedAnnotation().getAnnotation(Named.class).value())) {
                throw new DefinitionException("Cannot specify a value for a @Named stereotype " + this.getAnnotatedAnnotation());
            }
            this.beanNameDefaulted = true;
        }
    }

    private void initDefaultScopeType() {
        Set<Annotation> scopeTypes = this.getAnnotatedAnnotation().getMetaAnnotations(ScopeType.class);
        if (scopeTypes.size() > 1) {
            throw new DefinitionException("At most one scope type may be specified for " + this.getAnnotatedAnnotation());
        }
        if (scopeTypes.size() == 1) {
            this.defaultScopeType = scopeTypes.iterator().next();
        }
    }

    private void initDefaultDeploymentType() {
        Set<Annotation> deploymentTypes = this.getAnnotatedAnnotation().getMetaAnnotations(DeploymentType.class);
        if (deploymentTypes.size() > 1) {
            throw new DefinitionException("At most one deployment type may be specified on " + this.getAnnotatedAnnotation());
        }
        if (deploymentTypes.size() == 1) {
            this.defaultDeploymentType = deploymentTypes.iterator().next();
        }
    }

    public Annotation getDefaultDeploymentType() {
        return this.defaultDeploymentType;
    }

    public Annotation getDefaultScopeType() {
        return this.defaultScopeType;
    }

    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    @Override
    protected Class<? extends Annotation> getMetaAnnotation() {
        return Stereotype.class;
    }
}

