/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http")
@Scoped(value=PerLookup.class)
@I18n(value="create.http")
public class CreateHttp
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttp.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="request-timeout-seconds", defaultValue="30", optional=true)
    String requestTimeoutSeconds;
    @Param(name="timeout-seconds", defaultValue="30", optional=true)
    String timeoutSeconds;
    @Param(name="max-connection", defaultValue="256", optional=true)
    String maxConnections;
    @Param(name="default-virtual-server")
    String defaultVirtualServer;
    @Param(name="dns-lookup-enabled", defaultValue="false", optional=true)
    String dnsLookupEnabled;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        Protocols protocols = config.getNetworkConfig().getProtocols();
        Protocol protocol = null;
        for (Protocol p : protocols.getProtocol()) {
            if (p.getName().equalsIgnoreCase(this.protocolName) && p.getHttp() != null) {
                report.setMessage(localStrings.getLocalString("create.http.fail.duplicate", "An http element for {0} already exists. Cannot add duplicate http", new Object[]{this.protocolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            protocol = p;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws TransactionFailure {
                    Http http = (Http)param.createChild(Http.class);
                    FileCache cache = (FileCache)http.createChild(FileCache.class);
                    cache.setEnabled("false");
                    http.setFileCache(cache);
                    http.setDefaultVirtualServer(CreateHttp.this.defaultVirtualServer);
                    http.setDnsLookupEnabled(CreateHttp.this.dnsLookupEnabled);
                    http.setMaxConnections(CreateHttp.this.maxConnections);
                    http.setRequestTimeoutSeconds(CreateHttp.this.requestTimeoutSeconds);
                    param.setHttp(http);
                    return http;
                }
            }, protocol);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.http.fail", "Failed to create http for {0} ", new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

