/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.AttributeChangeNotification;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Units;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
class ConfigBeanJMXSupport {
    private final Class<? extends ConfigBeanProxy> mIntf;
    private final List<AttributeMethodInfo> mAttrInfos = new ArrayList<AttributeMethodInfo>();
    private final List<ElementMethodInfo> mElementInfos = new ArrayList<ElementMethodInfo>();
    private final List<DuckTypedInfo> mDuckTypedInfos = new ArrayList<DuckTypedInfo>();
    private final NameHint mNameHint;
    private final MBeanInfo mMBeanInfo;
    private final String mKey;
    private static final MBeanNotificationInfo ATTRIBUTE_CHANGE_NOTIF_INFO = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "attribute change");
    private static final Set<Class<?>> REMOTABLE = SetUtil.newSet((Object[])new Class[]{Void.class, Boolean.class, Character.class, String.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, BigInteger.class, Date.class, ObjectName.class, CompositeType.class, CompositeDataSupport.class});
    private static final Map<String, String> INTERFACE_MAPPINGS = MapUtil.newMap((String)com.sun.enterprise.config.serverbeans.Domain.class.getPackage().getName(), (Object)Domain.class.getPackage().getName());
    private static final Set<String> IGNORE_ANNOTATION_METHODS = SetUtil.newUnmodifiableStringSet((String[])new String[]{"toString", "hashCode", "annotationType"});
    public static final String ANONYMOUS_SUB_ELEMENT = "*";
    private static final Map<String, String> UNITS_SUFFIXES = MapUtil.newMap((String[])new String[]{"Millis", "milliseconds", "Milliseconds", "milliseconds", "Seconds", "seconds", "Hours", "hours", "Days", "days", "Bytes", "bytes", "Kilobytes", "kilobytes", "Megabytes", "megabytes"});
    private static final Map<Class<?>, long[]> MIN_MAX = ConfigBeanJMXSupport.makeMIN_MAX();
    private static final String DEFAULT_NAME_HINT = "name";

    private static String nameFromKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.startsWith("@")) {
            return key.substring(1);
        }
        if (key.startsWith("<")) {
            return key.substring(1, key.length() - 1);
        }
        throw new IllegalArgumentException(key);
    }

    ConfigBeanJMXSupport(ConfigBean configBean) {
        this(configBean.getProxyType(), ConfigBeanJMXSupport.nameFromKey(configBean.model.key));
    }

    ConfigBeanJMXSupport(Class<? extends ConfigBeanProxy> intf, String key) {
        this.mIntf = intf;
        this.mKey = key;
        this.findStuff(intf, this.mAttrInfos, this.mElementInfos, this.mDuckTypedInfos);
        this.sanityCheckConfigured();
        this.mMBeanInfo = this._getMBeanInfo();
        this.sanityCheckMBeanInfo();
        this.mNameHint = this.findNameHint();
    }

    public Class<? extends ConfigBeanProxy> getIntf() {
        return this.mIntf;
    }

    private static Class<?> findDuck(Class<?> intf) {
        Class<?>[] candidates = intf.getClasses();
        Class<?> duck = null;
        for (Class<?> c : candidates) {
            if (!c.getName().endsWith("$Duck")) continue;
            ConfigBeanJMXSupport.debug("ConfigBeanJMXSupport: found Duck class: " + c.getName());
            duck = c;
        }
        return duck;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String DELIM = ", ";
        String NL = StringUtil.NEWLINE();
        buf.append(this.mIntf.getName() + " = ");
        buf.append(NL + "Attributes: {" + NL);
        for (AttributeMethodInfo attributeMethodInfo : this.mAttrInfos) {
            buf.append(attributeMethodInfo.attrName() + "/" + attributeMethodInfo.xmlName() + ", ");
        }
        buf.append(NL + "}" + NL + "Elements: {" + NL);
        for (ElementMethodInfo elementMethodInfo : this.mElementInfos) {
            buf.append(elementMethodInfo.attrName() + "/" + elementMethodInfo.xmlName() + ", ");
        }
        Set<String> childTypes = this.childTypes().keySet();
        buf.append(NL + "}" + NL + "Child types: {" + NL);
        for (String type : childTypes) {
            buf.append(type + ", ");
        }
        buf.append(NL + "}" + NL + "DuckTyped: {" + NL);
        for (DuckTypedInfo info : this.mDuckTypedInfos) {
            buf.append(info + NL);
        }
        buf.append(NL + "}" + NL);
        return buf.toString();
    }

    private boolean isPerfectMatch(String[] types, Class<?>[] sig) {
        if (types == null && (sig == null || sig.length == 0)) {
            return true;
        }
        boolean mismatch = false;
        for (int i = 0; i < sig.length; ++i) {
            if (!sig[i].getName().equals(types[i])) continue;
            mismatch = true;
            break;
        }
        return !mismatch;
    }

    public DuckTypedInfo findDuckTyped(String name, String[] types) {
        DuckTypedInfo info = null;
        int numTypes = types == null ? 0 : types.length;
        for (DuckTypedInfo candidate : this.mDuckTypedInfos) {
            Class<?>[] sig = candidate.signature();
            if (!candidate.name().equals(name) || numTypes != sig.length) continue;
            if (this.isPerfectMatch(types, sig)) {
                info = candidate;
                break;
            }
            if (info != null) continue;
            info = candidate;
        }
        return info;
    }

    public String getTypeString() {
        return this.getTypeString(this.mIntf);
    }

    public String getTypeString(Class<? extends ConfigBeanProxy> intf) {
        String type = null;
        Configured configuredAnnotation = intf.getAnnotation(Configured.class);
        if (configuredAnnotation != null && configuredAnnotation.name().length() != 0) {
            type = configuredAnnotation.name();
            if (type == null || type.length() == 0) {
                throw new IllegalArgumentException("ConfigBeanJMXSupport.getTypeString(): Malformed @Configured annotation on " + intf.getName());
            }
        } else {
            Package pkg = intf.getPackage();
            String simple = intf.getName().substring(pkg.getName().length() + 1, intf.getName().length());
            type = Util.typeFromName((String)simple);
            if (type == null || type.length() == 0) {
                throw new IllegalArgumentException("ConfigBeanJMXSupport.getTypeString(): Malformed type generated from " + intf.getName());
            }
        }
        return type;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    private MBeanInfo _getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attrsList = new ArrayList<MBeanAttributeInfo>();
        for (AttributeMethodInfo info : this.mAttrInfos) {
            attrsList.add(this.attributeToMBeanAttributeInfo(info));
        }
        for (ElementMethodInfo e : this.mElementInfos) {
            MBeanAttributeInfo attrInfo = this.elementToMBeanAttributeInfo(e.method());
            if (attrInfo == null) continue;
            attrsList.add(attrInfo);
        }
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attrsList.size()];
        attrsList.toArray(attrs);
        String classname = this.mIntf.getName();
        String description = "ConfigBean " + this.mIntf.getName();
        MBeanConstructorInfo[] constructors = null;
        MBeanOperationInfo[] operations = this.toMBeanOperationInfos();
        DescriptorSupport descriptor = this.descriptor();
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{ATTRIBUTE_CHANGE_NOTIF_INFO};
        MBeanInfo info = new MBeanInfo(classname, description, attrs, constructors, operations, notifications, descriptor);
        return info;
    }

    private boolean hasNameAttribute() {
        for (MBeanAttributeInfo attrInfo : this.getMBeanInfo().getAttributes()) {
            if (!"Name".equals(attrInfo.getName())) continue;
            return true;
        }
        return false;
    }

    private void sanityCheckMBeanInfo() {
        if (this.isSingleton() && this.hasNameAttribute()) {
            ImplUtil.getLogger().fine("ConfigBeanJMXSupport (AMX): @Configured interface " + this.mIntf.getName() + " has getName() which is not a key value.  Remove getName() or use @Attribute(key=true)");
        }
    }

    public boolean isSingleton() {
        if (this.mKey != null) {
            return false;
        }
        for (AttributeMethodInfo attributeMethodInfo : this.mAttrInfos) {
            if (!attributeMethodInfo.key()) continue;
            return false;
        }
        for (ElementMethodInfo elementMethodInfo : this.mElementInfos) {
            if (!elementMethodInfo.key()) continue;
            return false;
        }
        return true;
    }

    boolean isLeaf() {
        return this.mElementInfos.size() == 0;
    }

    private static boolean isRemoteableType(Class<?> clazz) {
        if (clazz.isPrimitive() || REMOTABLE.contains(clazz) || CompositeData.class.isAssignableFrom(clazz) || OpenType.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.isArray()) {
            return ConfigBeanJMXSupport.isRemoteableType(clazz.getComponentType());
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        return ConfigBeanProxy.class.isAssignableFrom(clazz);
    }

    private static boolean isRemoteableDuckTyped(Method m, DuckTyped duckTyped) {
        Class<?>[] sig;
        boolean isRemotable = true;
        Class<?> returnType = m.getReturnType();
        if (!ConfigBeanJMXSupport.isRemoteableType(returnType)) {
            return false;
        }
        for (Class<?> c : sig = m.getParameterTypes()) {
            if (!ConfigBeanJMXSupport.isRemoteableType(c)) {
                return false;
            }
            if (c != Class.class) continue;
            return false;
        }
        return true;
    }

    private static Class<?> remoteType(Class<?> clazz) {
        if (ConfigBeanProxy.class.isAssignableFrom(clazz)) {
            return ObjectName.class;
        }
        return clazz;
    }

    private void findStuff(Class<? extends ConfigBeanProxy> intf, List<AttributeMethodInfo> attrs, List<ElementMethodInfo> elements, List<DuckTypedInfo> duckTyped) {
        for (Method m : intf.getMethods()) {
            AttributeMethodInfo a = AttributeMethodInfo.get(m);
            if (a != null) {
                attrs.add(a);
                if (a.returnType() == String.class) continue;
                ImplUtil.getLogger().info("Illegal non-string type for " + intf.getName() + "." + m.getName() + "(): " + a.returnType().getName());
                continue;
            }
            ElementMethodInfo e = ElementMethodInfo.get(m);
            if (e != null) {
                elements.add(e);
                continue;
            }
            DuckTyped dt = m.getAnnotation(DuckTyped.class);
            if (dt == null || !ConfigBeanJMXSupport.isRemoteableDuckTyped(m, dt)) continue;
            duckTyped.add(new DuckTypedInfo(m, dt));
        }
    }

    public List<String> sanityCheckConfigured() {
        ArrayList<String> problems = new ArrayList<String>();
        for (AttributeMethodInfo info : this.mAttrInfos) {
            Class<?> dataType = info.inferDataType();
            if (dataType != Boolean.class && dataType != Boolean.TYPE || !info.notNull() || info.hasDefaultValue()) continue;
            problems.add("Missing defaultValue for Boolean @Configured " + this.mIntf.getName() + ".get" + info.attrName() + "()");
        }
        if (problems.size() != 0) {
            System.out.println(CollectionUtil.toString(problems, (String)"\n"));
        }
        return problems;
    }

    public static String xmlName(MBeanAttributeInfo info, String defaultValue) {
        String value = (String)info.getDescriptor().getFieldValue("amx.configbean.xmlName");
        return value == null ? defaultValue : value;
    }

    public static boolean isKey(MBeanAttributeInfo info) {
        return (Boolean)info.getDescriptor().getFieldValue("amx.configbean.key");
    }

    public static String defaultValue(MBeanAttributeInfo info) {
        return (String)info.getDescriptor().getFieldValue("amx.configbean.defaultValue");
    }

    public Map<String, String> getToXMLNameMapping() {
        HashMap<String, String> m = new HashMap<String, String>();
        MBeanInfo info = this.getMBeanInfo();
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            m.put(attrInfo.getName(), ConfigBeanJMXSupport.xmlName(attrInfo, attrInfo.getName()));
        }
        return m;
    }

    public Map<String, String> getFromXMLNameMapping() {
        HashMap<String, String> m = new HashMap<String, String>();
        MBeanInfo info = this.getMBeanInfo();
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            m.put(ConfigBeanJMXSupport.xmlName(attrInfo, attrInfo.getName()), attrInfo.getName());
        }
        return m;
    }

    public static boolean isAttribute(MBeanAttributeInfo info) {
        String value = (String)info.getDescriptor().getFieldValue("amx.configbean.kind");
        return value == null || Attribute.class.getName().equals(value);
    }

    public static boolean isElement(MBeanAttributeInfo info) {
        String value = (String)info.getDescriptor().getFieldValue("amx.configbean.kind");
        return Element.class.getName().equals(value);
    }

    public static DescriptorSupport descriptor(AttributeMethodInfo info) {
        DescriptorSupport d = new DescriptorSupport();
        Attribute a = info.attribute();
        d.setField("amx.configbean.kind", Attribute.class.getName());
        if (!a.defaultValue().equals("\u0000")) {
            d.setField("amx.configbean.defaultValue", a.defaultValue());
        }
        d.setField("amx.configbean.key", a.key());
        d.setField("amx.configbean.required", a.required());
        d.setField("amx.configbean.reference", a.reference());
        d.setField("amx.configbean.variableExpansion", a.variableExpansion());
        d.setField("amx.configbean.dataType", info.inferDataType().getName());
        return d;
    }

    public static DescriptorSupport descriptor(Element e) {
        DescriptorSupport d = new DescriptorSupport();
        d.setField("amx.configbean.kind", Element.class.getName());
        d.setField("amx.configbean.key", e.key());
        d.setField("amx.configbean.required", e.required());
        d.setField("amx.configbean.reference", e.reference());
        d.setField("amx.configbean.variableExpansion", e.variableExpansion());
        return d;
    }

    public static DescriptorSupport descriptor(DuckTyped dt) {
        DescriptorSupport d = new DescriptorSupport();
        d.setField("amx.configbean.kind", DuckTyped.class.getName());
        return d;
    }

    private DescriptorSupport descriptor() {
        DescriptorSupport d = new DescriptorSupport();
        String amxInterfaceName = AMXConfigProxy.class.getName();
        String intfPackage = this.mIntf.getPackage().getName();
        if (INTERFACE_MAPPINGS.get(intfPackage) != null) {
            amxInterfaceName = INTERFACE_MAPPINGS.get(intfPackage) + "." + this.mIntf.getName();
        }
        d.setField("interfaceName", amxInterfaceName);
        d.setField("amx.genericInterfaceName", AMXConfigProxy.class.getName());
        d.setField("immutableInfo", true);
        d.setField("amx.group", "config");
        d.setField("amx.supportsAdoption", false);
        d.setField("amx.isSingleton", this.isSingleton());
        String[] subTypes = (String[])CollectionUtil.toArray(this.childTypes().keySet(), String.class);
        d.setField("amx.subTypes", subTypes);
        return d;
    }

    public final Set<String> requiredAttributeNames() {
        HashSet<String> s = new HashSet<String>();
        for (AttributeMethodInfo attributeMethodInfo : this.mAttrInfos) {
            if (!attributeMethodInfo.required()) continue;
            s.add(attributeMethodInfo.attrName());
        }
        for (ElementMethodInfo elementMethodInfo : this.mElementInfos) {
            if (!elementMethodInfo.required()) continue;
            s.add(elementMethodInfo.attrName());
        }
        return s;
    }

    public MBeanOperationInfo duckTypedToMBeanOperationInfo(DuckTypedInfo info) {
        DescriptorSupport descriptor = ConfigBeanJMXSupport.descriptor(info.duckTyped());
        String name = info.name();
        Class<?> type = ConfigBeanJMXSupport.remoteType(info.returnType());
        String description = "@DuckTyped " + name + " of " + this.mIntf.getName();
        int impact = 3;
        ArrayList<MBeanParameterInfo> paramInfos = new ArrayList<MBeanParameterInfo>();
        int i = 0;
        for (Class<?> paramClass : info.signature()) {
            String paramName = "p" + i;
            String paramType = ConfigBeanJMXSupport.remoteType(paramClass).getName();
            String paramDescription = "parameter " + i;
            Descriptor paramDescriptor = null;
            MBeanParameterInfo paramInfo = new MBeanParameterInfo(paramName, paramType, paramDescription, paramDescriptor);
            paramInfos.add(paramInfo);
            ++i;
        }
        MBeanParameterInfo[] paramInfosArray = (MBeanParameterInfo[])CollectionUtil.toArray(paramInfos, MBeanParameterInfo.class);
        MBeanOperationInfo opInfo = new MBeanOperationInfo(name, description, paramInfosArray, type.getName(), 3, descriptor);
        return opInfo;
    }

    public MBeanOperationInfo[] toMBeanOperationInfos() {
        ArrayList<MBeanOperationInfo> opInfos = new ArrayList<MBeanOperationInfo>();
        for (DuckTypedInfo info : this.mDuckTypedInfos) {
            MBeanOperationInfo opInfo = this.duckTypedToMBeanOperationInfo(info);
            if (opInfo == null) continue;
            opInfos.add(opInfo);
        }
        return (MBeanOperationInfo[])CollectionUtil.toArray(opInfos, MBeanOperationInfo.class);
    }

    private void addAnnotationsToDescriptor(Descriptor d, AttributeMethodInfo info) {
        Annotation[] annotations;
        for (Annotation a : annotations = info.annotations()) {
            Method[] values;
            String prefix = "amx.configbean.annotation.@" + a.annotationType().getName() + ":";
            for (Method m : values = a.getClass().getDeclaredMethods()) {
                String fieldName = m.getName();
                if (IGNORE_ANNOTATION_METHODS.contains(fieldName) || m.getParameterTypes().length != 0) continue;
                try {
                    Object fieldValue;
                    Object actualValue = fieldValue = m.invoke((Object)a, new Object[0]);
                    if (actualValue != null) {
                        actualValue = SmartStringifier.toString((Object)actualValue);
                    }
                    d.setField(prefix + fieldName, actualValue);
                }
                catch (Exception e) {
                    ImplUtil.getLogger().log(Level.INFO, "Can't get field value for " + a, e);
                }
            }
        }
    }

    public MBeanAttributeInfo attributeToMBeanAttributeInfo(AttributeMethodInfo info) {
        DescriptorSupport descriptor = ConfigBeanJMXSupport.descriptor(info);
        String name = info.attrName();
        String xmlName = info.xmlName();
        descriptor.setField("amx.configbean.xmlName", xmlName);
        if (info.pattern() != null) {
            descriptor.setField("amx.configbean.pattern", info.pattern());
        }
        if (info.units() != null) {
            descriptor.setField("amx.configbean.units", info.units());
        }
        if (info.min() != null) {
            descriptor.setField("amx.configbean.min", info.min());
        }
        if (info.max() != null) {
            descriptor.setField("amx.configbean.max", info.max());
        }
        this.addAnnotationsToDescriptor(descriptor, info);
        descriptor.setField("amx.configbean.notNull", "" + info.notNull());
        Class type = info.returnType();
        Attribute a = info.attribute();
        if (a == null || a.dataType() == String.class || type == String.class) {
            // empty if block
        }
        String description = "@Attribute " + name;
        boolean isReadable = true;
        boolean isWriteable = true;
        boolean isIs = false;
        MBeanAttributeInfo attrInfo = new MBeanAttributeInfo(name, type.getName(), description, true, true, false, descriptor);
        return attrInfo;
    }

    public static Class[] getTypesImplementing(Class<?> clazz) {
        DomDocument domDoc = new DomDocument(InjectedValues.getInstance().getHabitat());
        try {
            List models = domDoc.getAllModelsImplementing(clazz);
            Class[] interfaces = new Class[models == null ? 0 : models.size()];
            if (models != null) {
                int i = 0;
                for (ConfigModel model : models) {
                    Class<?> intf;
                    String classname = model.targetTypeName;
                    ClassLoader classLoader = (ClassLoader)model.classLoaderHolder.get();
                    interfaces[i] = intf = classLoader.loadClass(classname);
                    ++i;
                }
            }
            return interfaces;
        }
        catch (Exception e) {
            ImplUtil.getLogger().log(Level.INFO, "Can't getTypesImplementing for " + clazz, e);
            throw new RuntimeException(e);
        }
    }

    private static boolean isIntegral(String s) {
        if (s.equals("0") || s.equals("1")) {
            return true;
        }
        try {
            Long.parseLong(s);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Map<Class<?>, long[]> makeMIN_MAX() {
        HashMap m = new HashMap();
        long[] mm = new long[]{-128L, 127L};
        m.put(Byte.TYPE, mm);
        m.put(Byte.class, mm);
        mm = new long[]{-32768L, 32767L};
        m.put(Short.TYPE, mm);
        m.put(Short.class, mm);
        mm = new long[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        m.put(Integer.TYPE, mm);
        m.put(Integer.class, mm);
        mm = new long[]{Long.MIN_VALUE, Long.MAX_VALUE};
        m.put(Long.TYPE, mm);
        m.put(Long.class, mm);
        return m;
    }

    private static long[] minMaxFromDataType(Class<?> dataType) {
        return MIN_MAX.get(dataType);
    }

    public Set<Class<? extends ConfigBeanProxy>> childInterfaces() {
        Set<Class<? extends ConfigBeanProxy>> intfs = this.childInterfaces(this.mElementInfos);
        return intfs;
    }

    private static Class<?> internalReturnType(Method method) {
        Class returnType;
        block3: {
            returnType = method.getReturnType();
            try {
                ParameterizedType pt;
                Type[] argTypes;
                Type genericReturnType;
                if (!Collection.class.isAssignableFrom(returnType) || !((genericReturnType = method.getGenericReturnType()) instanceof ParameterizedType) || (argTypes = (pt = (ParameterizedType)genericReturnType).getActualTypeArguments()).length != 1) break block3;
                Type argType = argTypes[0];
                if (argType instanceof Class) {
                    returnType = (Class)argType;
                    break block3;
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                System.out.println("AMX ConfigBeanAMXSupport: can't get generic return type for method " + method.getDeclaringClass().getName() + "." + method.getName() + "(): " + e.getClass().getName() + " = " + e.getMessage());
            }
        }
        return returnType;
    }

    public ElementMethodInfo getElementMethodInfo(Class<? extends ConfigBeanProxy> intf) {
        ElementMethodInfo match = null;
        for (ElementMethodInfo info : this.mElementInfos) {
            if (ConfigBeanJMXSupport.internalReturnType(info.method()) != intf) continue;
            match = info;
            break;
        }
        if (match == null) {
            for (ElementMethodInfo info : this.mElementInfos) {
                if (!ConfigBeanJMXSupport.internalReturnType(info.method()).isAssignableFrom(intf)) continue;
                match = info;
                break;
            }
        }
        return match;
    }

    public Map<String, Class<? extends ConfigBeanProxy>> childTypes() {
        HashMap<String, Class<? extends ConfigBeanProxy>> types = new HashMap<String, Class<? extends ConfigBeanProxy>>();
        for (Class<? extends ConfigBeanProxy> intf : this.childInterfaces()) {
            types.put(this.getTypeString(intf), intf);
        }
        return types;
    }

    public Class<? extends ConfigBeanProxy> getConfigBeanProxyClassFor(String type, boolean recursive) {
        return this.childTypes().get(type);
    }

    public Set<Class<? extends ConfigBeanProxy>> childInterfaces(List<ElementMethodInfo> infos) {
        HashSet<Class<? extends ConfigBeanProxy>> classes = new HashSet<Class<? extends ConfigBeanProxy>>();
        for (ElementMethodInfo info : infos) {
            Type argType;
            ParameterizedType pt;
            Type[] argTypes;
            Type genericReturnType;
            if (info.anonymous()) {
                List<Class<? extends ConfigBeanProxy>> types = info.anonymousTypes();
                if (types == null) continue;
                classes.addAll(types);
                continue;
            }
            Class methodReturnType = info.returnType();
            Class<ConfigBeanProxy> intf = null;
            if (info.intf() != null) {
                intf = info.intf();
            } else if (Collection.class.isAssignableFrom(methodReturnType) && (genericReturnType = info.method().getGenericReturnType()) instanceof ParameterizedType && (argTypes = (pt = (ParameterizedType)genericReturnType).getActualTypeArguments()).length == 1 && (!((argType = argTypes[0]) instanceof Class) || (Class)argType != String.class)) {
                intf = ((Class)argType).asSubclass(ConfigBeanProxy.class);
            }
            if (intf == null) continue;
            classes.add((Class<? extends ConfigBeanProxy>)intf);
        }
        return classes;
    }

    public MBeanAttributeInfo elementToMBeanAttributeInfo(Method m) {
        ParameterizedType pt;
        Type[] argTypes;
        Type genericReturnType;
        ElementMethodInfo info = ElementMethodInfo.get(m);
        if (info == null || info.anonymous()) {
            return null;
        }
        String name = info.attrName();
        String xmlName = info.xmlName();
        Class methodReturnType = info.returnType();
        Class returnType = null;
        if (info.intf() != null) {
            returnType = ObjectName.class;
        } else if (Collection.class.isAssignableFrom(methodReturnType) && (genericReturnType = m.getGenericReturnType()) instanceof ParameterizedType && (argTypes = (pt = (ParameterizedType)genericReturnType).getActualTypeArguments()).length == 1) {
            Type argType = argTypes[0];
            returnType = argType instanceof Class && (Class)argType == String.class ? String[].class : ObjectName[].class;
        }
        MBeanAttributeInfo attrInfo = null;
        if (returnType != null) {
            PropertiesDesc props;
            DescriptorSupport descriptor = ConfigBeanJMXSupport.descriptor(info.element());
            descriptor.setField("amx.configbean.elementClass", returnType.getName());
            descriptor.setField("amx.configbean.xmlName", xmlName);
            ToDo toDo = info.method().getAnnotation(ToDo.class);
            if (toDo != null) {
                descriptor.setField("amx.configbean.toDo", toDo.priority() + ", " + toDo.details());
            }
            if ((props = info.method().getAnnotation(PropertiesDesc.class)) != null) {
                String propType = props.systemProperties() ? "system-property" : "property";
                for (PropertyDesc p : props.props()) {
                    String value = p.defaultValue() + " | " + p.dataType().getName() + " | " + p.description();
                    descriptor.setField("amx.configbean." + propType + "." + p.name(), value);
                }
            }
            String description = "@Element " + name + " of interface " + this.mIntf.getName();
            boolean isReadable = true;
            boolean isWriteable = true;
            boolean isIs = false;
            attrInfo = new MBeanAttributeInfo(name, returnType.getName(), description, true, true, false, descriptor);
        }
        return attrInfo;
    }

    public String getNameHint() {
        return this.mNameHint.mHint;
    }

    public boolean nameHintIsElement() {
        return this.mNameHint.mIsElement;
    }

    public static String toXMLName(String name) {
        return name == null ? name : Dom.convertName((String)name);
    }

    private NameHint findNameHint() {
        if (this.isSingleton()) {
            return NameHint.NONE;
        }
        if (this.mKey != null) {
            return new NameHint(this.mKey);
        }
        for (AttributeMethodInfo info : this.mAttrInfos) {
            if (!info.key()) continue;
            return new NameHint(info.xmlName());
        }
        return NameHint.NAME;
    }

    public Map<String, String> getDefaultValues(boolean useAttributeNames) {
        HashMap<String, String> m = new HashMap<String, String>();
        MBeanInfo info = this.getMBeanInfo();
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            String defaultValue = ConfigBeanJMXSupport.defaultValue(attrInfo);
            if (defaultValue == null) continue;
            String attrName = attrInfo.getName();
            String name = useAttributeNames ? attrName : ConfigBeanJMXSupport.xmlName(attrInfo, attrName);
            m.put(name, defaultValue);
        }
        return m;
    }

    private static void debug(String s) {
        System.out.println("### " + s);
    }

    private static final class NameHint {
        public static final NameHint NAME = new NameHint("name");
        public static final NameHint NONE = new NameHint(null);
        private final String mHint;
        private final boolean mIsElement;

        public NameHint(String hint, boolean isElement) {
            this.mHint = ConfigBeanJMXSupport.toXMLName(hint);
            this.mIsElement = isElement;
        }

        public NameHint(String hint) {
            this(hint, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DuckTypedInfo {
        private final DuckTyped mDuckTyped;
        private final Method mMethod;

        DuckTypedInfo(Method m, DuckTyped duckTyped) {
            this.mMethod = m;
            this.mDuckTyped = duckTyped;
        }

        public DuckTyped duckTyped() {
            return this.mDuckTyped;
        }

        public String name() {
            return this.mMethod.getName();
        }

        public Class<?> duck() {
            return this.mMethod.getDeclaringClass();
        }

        public Method method() {
            return this.mMethod;
        }

        public Class<?> returnType() {
            return this.method().getReturnType();
        }

        public boolean isPseudoAttribute() {
            return this.name().startsWith("get") || this.name().startsWith("is") && this.signature().length == 0;
        }

        public Class<?>[] signature() {
            return this.method().getParameterTypes();
        }

        public String toString() {
            String paramsString = "";
            Class<?>[] paramTypes = this.signature();
            if (paramTypes.length != 0) {
                StringBuilder builder = new StringBuilder();
                String delim = ", ";
                for (Class<?> paramClass : this.method().getParameterTypes()) {
                    builder.append(ClassUtil.stripPackageName((String)paramClass.getName()) + ", ");
                }
                builder.setLength(builder.length() - ", ".length());
                paramsString = builder.toString();
            }
            return ClassUtil.stripPackageName((String)this.mMethod.getReturnType().getName()) + " " + this.duck().getName() + "." + this.mMethod.getName() + "(" + paramsString + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AttributeMethodInfo
    extends MethodInfo {
        private final Attribute mAttribute;

        private AttributeMethodInfo(Method m, Attribute a) {
            super(m, a.value().length() == 0 ? Util.typeFromName((String)JMXUtil.getAttributeName((Method)m)) : a.value());
            this.mAttribute = a;
        }

        public static AttributeMethodInfo get(Method m) {
            Attribute a = m.getAnnotation(Attribute.class);
            return a == null ? null : new AttributeMethodInfo(m, a);
        }

        public Attribute attribute() {
            return this.mAttribute;
        }

        @Override
        public boolean required() {
            return this.mAttribute.required();
        }

        @Override
        public boolean key() {
            return this.mAttribute.key();
        }

        public String pattern() {
            Pattern pat = this.mMethod.getAnnotation(Pattern.class);
            return pat == null ? null : pat.regexp();
        }

        public String units() {
            Units units = this.mMethod.getAnnotation(Units.class);
            return units == null ? this.inferUnits() : units.units();
        }

        public Long min() {
            Min min = this.mMethod.getAnnotation(Min.class);
            if (min != null) {
                return min.value();
            }
            long[] minMax = ConfigBeanJMXSupport.minMaxFromDataType(this.attribute().dataType());
            return minMax == null ? null : Long.valueOf(minMax[0]);
        }

        public Long max() {
            Max max = this.mMethod.getAnnotation(Max.class);
            if (max != null) {
                return max.value();
            }
            long[] minMax = ConfigBeanJMXSupport.minMaxFromDataType(this.attribute().dataType());
            return minMax == null ? null : Long.valueOf(minMax[1]);
        }

        public String inferUnits() {
            if (Number.class.isAssignableFrom(this.inferDataType())) {
                String attrName = this.attrName();
                for (String key : UNITS_SUFFIXES.keySet()) {
                    if (!attrName.endsWith(key)) continue;
                    return (String)UNITS_SUFFIXES.get(key);
                }
                return "count";
            }
            return null;
        }

        public boolean hasDefaultValue() {
            String defaultValue = this.attribute().defaultValue();
            return defaultValue != null && !defaultValue.equals("\u0000");
        }

        public Class<?> inferDataType() {
            Class dataType = this.attribute().dataType();
            if (dataType != String.class) {
                return dataType;
            }
            String defaultValue = this.attribute().defaultValue();
            if (defaultValue.equals("true") || defaultValue.equals("false")) {
                return Boolean.class;
            }
            if (this.max() != null) {
                if (this.max().equals(Long.MAX_VALUE)) {
                    return Long.class;
                }
                return Integer.class;
            }
            if (this.min() != null) {
                return this.min().equals(Long.MIN_VALUE) ? Long.class : Integer.class;
            }
            if (ConfigBeanJMXSupport.isIntegral("" + defaultValue)) {
                return Long.class;
            }
            return dataType;
        }

        public boolean notNull() {
            NotNull n = this.mMethod.getAnnotation(NotNull.class);
            return n != null;
        }

        public Annotation[] annotations() {
            return this.method().getAnnotations();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ElementMethodInfo
    extends MethodInfo {
        private final Element mElement;

        private ElementMethodInfo(Method m, Element e) {
            super(m, e.value().length() == 0 ? Util.typeFromName((String)JMXUtil.getAttributeName((Method)m)) : e.value());
            this.mElement = e;
        }

        public static ElementMethodInfo get(Method m) {
            Element e = m.getAnnotation(Element.class);
            return e == null ? null : new ElementMethodInfo(m, e);
        }

        public Element element() {
            return this.mElement;
        }

        public boolean anonymous() {
            return ConfigBeanJMXSupport.ANONYMOUS_SUB_ELEMENT.equals(this.xmlName());
        }

        public List<Class<? extends ConfigBeanProxy>> anonymousTypes() {
            if (!this.anonymous()) {
                return null;
            }
            Class anon = ConfigBeanJMXSupport.internalReturnType(this.method());
            if (!ConfigBeanProxy.class.isAssignableFrom(anon)) {
                return null;
            }
            Class[] interfaces = ConfigBeanJMXSupport.getTypesImplementing(anon);
            List types = ListUtil.newList();
            for (Class clazz : interfaces) {
                types.add(clazz.asSubclass(ConfigBeanProxy.class));
            }
            return types;
        }

        @Override
        public boolean required() {
            return this.mElement.required();
        }

        @Override
        public boolean key() {
            return this.mElement.key();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MethodInfo {
        protected final Method mMethod;
        protected final String mAttrName;
        protected final String mXMLName;

        MethodInfo(Method m, String xmlName) {
            this.mMethod = m;
            this.mAttrName = JMXUtil.getAttributeName((Method)m);
            this.mXMLName = xmlName;
        }

        public Method method() {
            return this.mMethod;
        }

        public String attrName() {
            return this.mAttrName;
        }

        public String xmlName() {
            return this.mXMLName;
        }

        public Class<?> returnType() {
            return this.mMethod.getReturnType();
        }

        public abstract boolean required();

        public abstract boolean key();

        public Class<? extends ConfigBeanProxy> intf() {
            Class<?> returnType = this.returnType();
            if (ConfigBeanProxy.class.isAssignableFrom(returnType)) {
                return returnType.asSubclass(ConfigBeanProxy.class);
            }
            return null;
        }
    }
}

