/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.CompletionHandler;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.B2CConverter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.Cookies;
import com.sun.grizzly.util.http.FastHttpDateFormat;
import com.sun.grizzly.util.http.Parameters;
import com.sun.grizzly.util.http.ServerCookie;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.AsyncContextImpl;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteReader;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.connector.SessionTracker;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.fileupload.Multipart;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.StringParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
implements HttpRequest,
HttpServletRequest {
    protected static final String info = "org.apache.catalina.connector.Request/1.0";
    private static boolean enforceScope = false;
    private static final long DEFAULT_ASYNC_TIMEOUT_MILLIS = 30000L;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(Request.class.getName());
    private static ThreadLocal staticDateFormats = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat[] f = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
            return f;
        }
    };
    protected SimpleDateFormat[] formats;
    private static ThreadLocal reentrancyStatus = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new byte[]{0};
        }
    };
    protected ArrayList<Cookie> cookies = new ArrayList();
    protected static final Locale defaultLocale = Locale.getDefault();
    protected HashMap attributes = new HashMap();
    protected ArrayList locales = new ArrayList();
    private HashMap notes = new HashMap();
    protected String authType = null;
    protected Object dispatcherTypeAttr = null;
    protected InputBuffer inputBuffer = new InputBuffer();
    protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
    protected CoyoteReader reader = new CoyoteReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean requestParametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected Subject subject = null;
    protected static final int CACHED_POST_LEN = 8192;
    protected byte[] postData = null;
    protected ParameterMap parameterMap = new ParameterMap();
    protected Session session = null;
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected String requestedSessionCookiePath;
    protected String requestedSessionVersion = null;
    protected boolean requestedSessionURL = false;
    protected Socket socket = null;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localName = null;
    protected String localAddr = null;
    protected boolean checkRestrictedResources = true;
    private boolean unsuccessfulSessionFind = false;
    protected boolean checkUnsuccessfulSessionFind = true;
    private int dispatchDepth = 0;
    private static int maxDispatchDepth = 20;
    private String jrouteId;
    private SessionTracker sessionTracker = new SessionTracker();
    private boolean isDefaultContext = false;
    private String requestURI = null;
    protected com.sun.grizzly.tcp.Request coyoteRequest;
    protected RequestFacade facade = null;
    protected RequestFacade defaultContextMaskingFacade = null;
    protected org.apache.catalina.Response response = null;
    protected Connector connector;
    protected MappingData mappingData = new MappingData();
    protected Wrapper wrapper = null;
    protected FilterChain filterChain = null;
    private boolean isAsyncSupported = true;
    private boolean asyncStarted;
    private AsyncContextImpl asyncContext;
    private LinkedList<AsyncListenerHolder> asyncListenerHolders;
    private long asyncTimeoutMillis = 30000L;
    private boolean isAsyncComplete;
    private boolean isOkToReinitializeAsync;
    private Multipart multipart;
    protected Context context = null;
    protected ServletContext servletContext = null;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    protected B2CConverter URIConverter = null;

    public Request() {
        this.formats = (SimpleDateFormat[])staticDateFormats.get();
        this.formats[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[1].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[2].setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setCoyoteRequest(com.sun.grizzly.tcp.Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
        this.inputBuffer.setRequest(coyoteRequest);
    }

    public com.sun.grizzly.tcp.Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    public static void setEnforceScope(boolean enforce) {
        enforceScope = enforce;
    }

    @Override
    public void recycle() {
        if (this.isAsyncStarted()) {
            return;
        }
        this.context = null;
        this.servletContext = null;
        this.contextPath = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.wrapper = null;
        this.dispatcherTypeAttr = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.requestURI = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.requestParametersParsed = false;
        this.cookiesParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.multipart = null;
        this.attributes.clear();
        this.notes.clear();
        this.cookies.clear();
        this.unsuccessfulSessionFind = false;
        if (this.session != null) {
            this.session.endAccess();
        }
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionCookiePath = null;
        this.requestedSessionVersion = null;
        this.requestedSessionURL = false;
        this.sessionTracker.reset();
        this.dispatchDepth = 0;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        this.mappingData.recycle();
        if (enforceScope) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.defaultContextMaskingFacade != null) {
                this.defaultContextMaskingFacade.clear();
                this.defaultContextMaskingFacade = null;
            }
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
        this.asyncContext = null;
        if (this.asyncListenerHolders != null) {
            this.asyncListenerHolders.clear();
            this.asyncListenerHolders = null;
        }
        this.isAsyncSupported = true;
        this.asyncStarted = false;
        this.isAsyncComplete = false;
        this.isOkToReinitializeAsync = false;
        this.asyncTimeoutMillis = 30000L;
    }

    @Override
    public String getAuthorization() {
        return this.coyoteRequest.getHeader("authorization");
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
        if (context != null) {
            this.servletContext = context.getServletContext();
        }
        this.initSessionTracker();
    }

    public void setDefaultContext(boolean isDefaultContext) {
        this.isDefaultContext = isDefaultContext;
    }

    @Override
    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    @Override
    public Host getHost() {
        return (Host)this.mappingData.host;
    }

    @Override
    public void setHost(Host host) {
        this.mappingData.host = host;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public MappingData getMappingData() {
        return this.mappingData;
    }

    public void setMappingData(MappingData mappingData) {
        this.mappingData = mappingData;
    }

    public void updatePaths(MappingData md) {
        this.pathInfo = md.pathInfo.toString();
        this.servletPath = md.wrapperPath.toString();
        this.contextPath = md.contextPath.toString();
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.getRequest(false);
    }

    @Override
    public HttpServletRequest getRequest(boolean maskDefaultContextMapping) {
        if (!maskDefaultContextMapping || !this.isDefaultContext) {
            if (this.facade == null) {
                this.facade = new RequestFacade(this);
            }
            return this.facade;
        }
        if (this.defaultContextMaskingFacade == null) {
            this.defaultContextMaskingFacade = new RequestFacade(this, true);
        }
        return this.defaultContextMaskingFacade;
    }

    @Override
    public org.apache.catalina.Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(org.apache.catalina.Response response) {
        this.response = response;
        this.sessionTracker.setResponse((Response)response);
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void setSocket(Socket socket) {
        this.socket = socket;
        this.remoteHost = null;
        this.remoteAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
    }

    @Override
    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    @Override
    public void setStream(InputStream stream) {
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public ServletInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    @Override
    public void finishRequest() throws IOException {
    }

    @Override
    public Object getNote(String name) {
        return this.notes.get(name);
    }

    @Override
    public Iterator getNoteNames() {
        return this.notes.keySet().iterator();
    }

    @Override
    public void removeNote(String name) {
        this.notes.remove(name);
    }

    @Override
    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    @Override
    public void setContentLength(int length) {
    }

    @Override
    public void setContentType(String type) {
    }

    @Override
    public void setProtocol(String protocol) {
    }

    @Override
    public void setRemoteAddr(String remoteAddr) {
    }

    public void setRemoteHost(String remoteHost) {
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public void setServerName(String name) {
        this.coyoteRequest.serverName().setString(name);
    }

    @Override
    public void setServerPort(int port) {
        this.coyoteRequest.setServerPort(port);
    }

    @Override
    public void setCheckRestrictedResources(boolean check) {
        this.checkRestrictedResources = check;
    }

    @Override
    public boolean getCheckRestrictedResources() {
        return this.checkRestrictedResources;
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherTypeAttr == null ? DispatcherType.REQUEST : this.dispatcherTypeAttr;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            return this.requestDispatcherPath == null ? this.getRequestPathMB().toString() : this.requestDispatcherPath.toString();
        }
        if (name.equals("org.apache.catalina.CONSTRAINT_URI")) {
            return this.getRequestPathMB() != null ? this.getRequestPathMB().toString() : null;
        }
        Object attr = this.attributes.get(name);
        if (attr != null) {
            return attr;
        }
        attr = this.coyoteRequest.getAttribute(name);
        if (attr != null) {
            return attr;
        }
        if ("org.apache.coyote.request.X509Certificate".equals(name)) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            attr = this.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put(name, attr);
            }
        } else if (Request.isSSLAttribute(name)) {
            this.populateSSLAttributes();
            attr = this.attributes.get(name);
        }
        return attr;
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name);
    }

    public Enumeration getAttributeNames() {
        if (this.isSecure()) {
            this.populateSSLAttributes();
        }
        return new Enumerator(this.attributes.keySet(), true);
    }

    @Override
    public String getCharacterEncoding() {
        return this.coyoteRequest.getCharacterEncoding();
    }

    @Override
    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getInputStream.ise"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    @Override
    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return (Locale)this.locales.get(0);
        }
        return defaultLocale;
    }

    @Override
    public Enumeration<Locale> getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return new Enumerator<Locale>(this.locales);
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator<Locale>(results);
    }

    @Override
    public String getParameter(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameter(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameterValues(name);
    }

    @Override
    public String getProtocol() {
        return this.coyoteRequest.protocol().toString();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getReader.ise"));
        }
        this.usingReader = true;
        try {
            this.inputBuffer.checkConverter();
        }
        catch (UnsupportedCharsetException uce) {
            UnsupportedEncodingException uee = new UnsupportedEncodingException(uce.getMessage());
            uee.initCause(uce);
            throw uee;
        }
        if (this.reader == null) {
            this.reader = new CoyoteReader(this.inputBuffer);
        }
        return this.reader;
    }

    @Override
    public String getRealPath(String path) {
        if (this.servletContext == null) {
            return null;
        }
        try {
            return this.servletContext.getRealPath(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            if (this.connector.getAuthPassthroughEnabled() && this.connector.getProxyHandler() != null) {
                this.remoteAddr = this.connector.getProxyHandler().getRemoteAddress(this.getRequest());
                if (this.remoteAddr == null) {
                    log.warning(sm.getString("coyoteRequest.nullRemoteAddressFromProxy"));
                }
                return this.remoteAddr;
            }
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteAddr = inet.getHostAddress();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE, this.coyoteRequest);
                this.remoteAddr = this.coyoteRequest.remoteAddr().toString();
            }
        }
        return this.remoteAddr;
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else if (this.connector.getAuthPassthroughEnabled() && this.connector.getProxyHandler() != null) {
                String addr = this.connector.getProxyHandler().getRemoteAddress(this.getRequest());
                if (addr != null) {
                    try {
                        this.remoteHost = InetAddress.getByName(addr).getHostName();
                    }
                    catch (UnknownHostException e) {
                        log.log(Level.WARNING, sm.getString("coyoteRequest.unknownHost", addr), e);
                    }
                } else {
                    log.warning(sm.getString("coyoteRequest.nullRemoteAddressFromProxy"));
                }
            } else if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteHost = inet.getHostName();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ATTRIBUTE, this.coyoteRequest);
                this.remoteHost = this.coyoteRequest.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    @Override
    public int getRemotePort() {
        if (this.remotePort == -1) {
            if (this.socket != null) {
                this.remotePort = this.socket.getPort();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE, this.coyoteRequest);
                this.remotePort = this.coyoteRequest.getRemotePort();
            }
        }
        return this.remotePort;
    }

    @Override
    public String getLocalName() {
        if (this.localName == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localName = inet.getHostName();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, this.coyoteRequest);
                this.localName = this.coyoteRequest.localName().toString();
            }
        }
        return this.localName;
    }

    @Override
    public String getLocalAddr() {
        if (this.localAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localAddr = inet.getHostAddress();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE, this.coyoteRequest);
                this.localAddr = this.coyoteRequest.localAddr().toString();
            }
        }
        return this.localAddr;
    }

    @Override
    public int getLocalPort() {
        if (this.localPort == -1) {
            if (this.socket != null) {
                this.localPort = this.socket.getLocalPort();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE, this.coyoteRequest);
                this.localPort = this.coyoteRequest.getLocalPort();
            }
        }
        return this.localPort;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.servletContext == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.servletContext.getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? requestPath.substring(0, pos + 1) + path : requestPath + path;
        return this.servletContext.getRequestDispatcher(relative);
    }

    @Override
    public String getScheme() {
        ProxyHandler proxyHandler;
        if (this.getConnector() != null && this.getConnector().getAuthPassthroughEnabled() && (proxyHandler = this.getConnector().getProxyHandler()) != null && proxyHandler.getSSLKeysize(this.getRequest()) > 0) {
            return "https";
        }
        return this.coyoteRequest.scheme().toString();
    }

    @Override
    public String getServerName() {
        return this.coyoteRequest.serverName().toString();
    }

    @Override
    public int getServerPort() {
        if (this.isSecure()) {
            String host = this.getHeader("host");
            if (host != null && host.indexOf(58) == -1) {
                return 443;
            }
            return this.coyoteRequest.getServerPort();
        }
        return this.coyoteRequest.getServerPort();
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void removeAttribute(String name) {
        Object value = null;
        boolean found = this.attributes.containsKey(name);
        if (!found) {
            return;
        }
        value = this.attributes.get(name);
        this.attributes.remove(name);
        List<EventListener> listeners = this.context.getApplicationEventListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.servletContext, this.getRequest(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)eventListener;
            try {
                listener.attributeRemoved(event);
            }
            catch (Throwable t) {
                this.log(sm.getString("coyoteRequest.attributeEvent"), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        List<EventListener> listeners;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("coyoteRequest.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherTypeAttr = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        boolean replaced = false;
        Object oldValue = this.attributes.put(name, value);
        if (oldValue != null) {
            replaced = true;
        }
        if (name.startsWith("grizzly.")) {
            this.coyoteRequest.setAttribute(name, value);
        }
        if ((listeners = this.context.getApplicationEventListeners()).isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        event = replaced ? new ServletRequestAttributeEvent(this.servletContext, this.getRequest(), name, oldValue) : new ServletRequestAttributeEvent(this.servletContext, this.getRequest(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)eventListener;
            try {
                if (replaced) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
            }
            catch (Throwable t) {
                this.log(sm.getString("coyoteRequest.attributeEvent"), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    @Override
    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.requestParametersParsed || this.usingReader) {
            String contextName = this.getContext() != null ? this.getContext().getName() : "UNKNOWN";
            log.warning(sm.getString("coyoteRequest.setCharacterEncoding.ise", (Object)enc, contextName));
            return;
        }
        byte[] buffer = new byte[]{97};
        final byte[] finalBuffer = buffer;
        final String finalEnc = enc;
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnsupportedEncodingException {
                        return new String(finalBuffer, finalEnc);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (UnsupportedEncodingException)pae.getCause();
            }
        } else {
            new String(buffer, enc);
        }
        this.coyoteRequest.setCharacterEncoding(enc);
    }

    public static void setMaxDispatchDepth(int depth) {
        maxDispatchDepth = depth;
    }

    public static int getMaxDispatchDepth() {
        return maxDispatchDepth;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.getUserPrincipal() != null) {
            throw new ServletException("Attempt to re-login while the user identity already exists");
        }
        if (this.context == null) {
            return false;
        }
        AuthenticatorBase authBase = (AuthenticatorBase)this.context.getAuthenticator();
        byte[] alreadyCalled = (byte[])reentrancyStatus.get();
        if (alreadyCalled[0] == 1) {
            if (authBase != null) {
                try {
                    return authBase.authenticate(this, (HttpResponse)this.getResponse(), this.context.getLoginConfig());
                }
                catch (Exception ex) {
                    throw new ServletException("Exception thrown while attempting to authenticate " + ex);
                }
            }
        } else {
            alreadyCalled[0] = 1;
            try {
                if (authBase != null) {
                    Realm realm = this.context.getRealm();
                    if (realm == null) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = realm.invokeAuthenticateDelegate(this, (HttpResponse)this.getResponse(), this.context, authBase);
                    return bl;
                }
            }
            finally {
                alreadyCalled[0] = 0;
            }
        }
        return false;
    }

    @Override
    public void login(String username, String password) throws ServletException {
        if (this.getUserPrincipal() != null) {
            log.severe("Attempt to re-login while the user identity already exists");
            throw new ServletException("Attempt to re-login while the user identity already exists");
        }
        if (this.context == null) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        String authMethod = loginConfig != null ? loginConfig.getAuthMethod() : "";
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return;
        }
        try {
            if (!"BASIC".equals(authMethod) && !"FORM".equals(authMethod)) {
                throw new ServletException("Invalid LoginConfig, Auth Method Required is BASIC or FORM, but found  " + authMethod);
            }
            Principal webPrincipal = realm.authenticate(username, password);
            if (webPrincipal != null) {
                this.setUserPrincipal(webPrincipal);
            }
        }
        catch (Exception ex) {
            throw new ServletException("Exception thrown while attempting to authenticate for user: " + username + " " + ex);
        }
        this.setAuthType("LOGIN");
    }

    @Override
    public void logout() throws ServletException {
        if (this.context == null) {
            return;
        }
        RealmInitializer realm = (RealmInitializer)this.context.getRealm();
        if (realm == null) {
            return;
        }
        realm.logout();
        this.setUserPrincipal(null);
        this.setAuthType(null);
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        this.cookies.add(cookie);
    }

    @Override
    public void addHeader(String name, String value) {
    }

    @Override
    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    @Override
    public void addParameter(String name, String[] values) {
        this.coyoteRequest.getParameters().addParameterValues(name, values);
    }

    @Override
    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies.clear();
    }

    @Override
    public void clearHeaders() {
    }

    @Override
    public void clearLocales() {
        this.locales.clear();
    }

    @Override
    public void clearParameters() {
    }

    @Override
    public void setAuthType(String type) {
        this.authType = type;
    }

    @Override
    public void setMethod(String method) {
        this.coyoteRequest.method().setString(method);
    }

    @Override
    public void setQueryString(String query) {
        this.coyoteRequest.queryString().setString(query);
    }

    @Override
    public void setPathInfo(String pathInfo) {
        this.mappingData.pathInfo.setString(pathInfo);
        this.pathInfo = pathInfo;
    }

    @Override
    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    @Override
    public void setRequestedSessionCookiePath(String cookiePath) {
        this.requestedSessionCookiePath = cookiePath;
    }

    @Override
    public void setRequestedSessionId(String id) {
        int index;
        this.requestedSessionId = id;
        if (id != null && CoyoteAdapter.JVM_ROUTE != null && (index = id.indexOf(".")) > 0) {
            this.requestedSessionId = id.substring(0, index);
        }
    }

    @Override
    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    @Override
    public void setRequestURI(String uri) {
        this.coyoteRequest.requestURI().setString(uri);
    }

    @Override
    public String getDecodedRequestURI() {
        return this.getDecodedRequestURI(false);
    }

    public String getDecodedRequestURI(boolean maskDefaultContextMapping) {
        if (maskDefaultContextMapping || !this.isDefaultContext) {
            return this.coyoteRequest.decodedURI().toString();
        }
        return this.getContextPath() + this.coyoteRequest.decodedURI().toString();
    }

    @Override
    public void setServletPath(String servletPath) {
        this.mappingData.wrapperPath.setString(servletPath);
        this.servletPath = servletPath;
    }

    @Override
    public void setUserPrincipal(Principal principal) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            HttpSession session = this.getSession(false);
            if (this.subject != null && !this.subject.getPrincipals().contains(principal)) {
                this.subject.getPrincipals().add(principal);
            } else if (session != null && session.getAttribute("javax.security.auth.subject") == null) {
                this.subject = new Subject();
                this.subject.getPrincipals().add(principal);
            }
            if (session != null) {
                session.setAttribute("javax.security.auth.subject", this.subject);
            }
        }
        this.userPrincipal = principal;
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    @Override
    public String getContextPath() {
        return this.getContextPath(false);
    }

    public String getContextPath(boolean maskDefaultContextMapping) {
        if (this.isDefaultContext && maskDefaultContextMapping) {
            return "";
        }
        return this.contextPath;
    }

    @Override
    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        if (this.cookies.size() == 0) {
            return null;
        }
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies.clear();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.cookies.add(cookies[i]);
            }
        }
    }

    @Override
    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    @Override
    public String getHeader(String name) {
        return this.coyoteRequest.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return this.coyoteRequest.getMimeHeaders().values(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return this.coyoteRequest.getMimeHeaders().names();
    }

    @Override
    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    @Override
    public String getMethod() {
        return this.coyoteRequest.method().toString();
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getPathTranslated() {
        if (this.servletContext == null) {
            return null;
        }
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.servletContext.getRealPath(this.getPathInfo());
    }

    @Override
    public String getQueryString() {
        String queryString = this.coyoteRequest.queryString().toString();
        if (queryString == null || queryString.equals("")) {
            return null;
        }
        return queryString;
    }

    @Override
    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    @Override
    public MessageBytes getRequestPathMB() {
        return this.mappingData.requestPath;
    }

    @Override
    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    @Override
    public String getRequestURI() {
        return this.getRequestURI(false);
    }

    public String getRequestURI(boolean maskDefaultContextMapping) {
        if (maskDefaultContextMapping) {
            return this.coyoteRequest.requestURI().toString();
        }
        if (this.requestURI == null) {
            this.requestURI = this.isDefaultContext ? this.getContextPath() + this.coyoteRequest.requestURI().toString() : this.coyoteRequest.requestURI().toString();
        }
        return this.requestURI;
    }

    @Override
    public StringBuffer getRequestURL() {
        return this.getRequestURL(false);
    }

    public StringBuffer getRequestURL(boolean maskDefaultContextMapping) {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI(maskDefaultContextMapping));
        return url;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public HttpSession getSession() {
        Session session = this.doGetSession(true);
        if (session != null) {
            return session.getSession();
        }
        return null;
    }

    @Override
    public HttpSession getSession(boolean create) {
        Session session = this.doGetSession(create);
        if (session != null) {
            return session.getSession();
        }
        return null;
    }

    public void setSession(Session newSess) {
        this.session = newSess;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        if (this.session != null && this.requestedSessionId.equals(this.session.getIdInternal())) {
            return this.session.isValid();
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session localSession = null;
        try {
            localSession = manager.isSessionVersioningSupported() ? manager.findSession(this.requestedSessionId, this.requestedSessionVersion) : manager.findSession(this.requestedSessionId);
        }
        catch (IOException e) {
            localSession = null;
        }
        return localSession != null && localSession.isValid();
    }

    @Override
    public boolean isUserInRole(String role) {
        String realRole;
        Principal userPrincipal = this.getUserPrincipal();
        if (userPrincipal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        if (this.wrapper != null && (realRole = this.wrapper.findSecurityReference(role)) != null && realm.hasRole(this, (HttpResponse)this.response, userPrincipal, realRole)) {
            return true;
        }
        return realm.hasRole(this, (HttpResponse)this.response, userPrincipal, role);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Session getSessionInternal() {
        return this.doGetSession(true);
    }

    @Override
    public Session getSessionInternal(boolean create) {
        return this.doGetSession(create);
    }

    @Override
    public String generateSessionId() {
        return null;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session doGetSession(boolean create) {
        String ssoId;
        SingleSignOn sso;
        StandardHost reqHost;
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
            this.requestedSessionVersion = null;
        }
        if (this.session != null) {
            return this.session;
        }
        Manager manager = null;
        if (this.context != null) {
            manager = this.context.getManager();
        }
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            if (!this.checkUnsuccessfulSessionFind || !this.unsuccessfulSessionFind) {
                try {
                    if (manager.isSessionVersioningSupported()) {
                        this.session = manager.findSession(this.requestedSessionId, this.requestedSessionVersion);
                        this.incrementSessionVersion((StandardSession)this.session, this.context);
                    } else {
                        this.session = manager.findSession(this.requestedSessionId);
                    }
                    if (this.session == null) {
                        this.unsuccessfulSessionFind = true;
                    }
                }
                catch (IOException e) {
                    this.session = null;
                }
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session;
            }
        }
        if (!create) {
            return null;
        }
        if (this.context != null && this.response != null && this.context.getCookies() && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.sessionCreateCommitted"));
        }
        if (this.requestedSessionId != null && this.context.getReuseSessionID()) {
            this.session = manager.createSession(this.requestedSessionId);
            if (manager instanceof PersistentManagerBase) {
                ((PersistentManagerBase)manager).removeFromInvalidatedSessions(this.requestedSessionId);
            }
        } else if (this.sessionTracker.getActiveSessions() > 0) {
            SessionTracker e = this.sessionTracker;
            synchronized (e) {
                if (this.sessionTracker.getActiveSessions() > 0) {
                    String id = this.sessionTracker.getSessionId();
                    this.session = manager.createSession(id);
                    if (manager instanceof PersistentManagerBase) {
                        ((PersistentManagerBase)manager).removeFromInvalidatedSessions(id);
                    }
                }
            }
        } else {
            String id = this.generateSessionId();
            this.session = id != null ? manager.createSession(id) : manager.createSession();
        }
        if ((reqHost = (StandardHost)this.getHost()) != null && (sso = reqHost.getSingleSignOn()) != null && (ssoId = (String)this.getNote("org.apache.catalina.request.SSOID")) != null) {
            sso.associate(ssoId, this.session);
            this.removeNote("org.apache.catalina.request.SSOID");
        }
        this.sessionTracker.track(this.session);
        if (this.session != null && this.getContext() != null) {
            String jvmRoute;
            if (manager.isSessionVersioningSupported()) {
                this.incrementSessionVersion((StandardSession)this.session, this.context);
            }
            if (this.getContext().getCookies() && (jvmRoute = ((StandardContext)this.getContext()).getJvmRoute()) == null) {
                String id = this.session.getIdInternal();
                Cookie cookie = new Cookie(this.getContext().getSessionCookieName(), id);
                this.configureSessionCookie(cookie);
                ((HttpServletResponse)((Object)this.response)).addCookie(cookie);
            }
        }
        if (this.session != null) {
            this.session.access();
            return this.session;
        }
        return null;
    }

    protected void configureSessionCookie(Cookie cookie) {
        Context context = this.getContext();
        cookie.setMaxAge(-1);
        String contextPath = null;
        if (this.isDefaultContext) {
            cookie.setPath("/");
        } else {
            if (context != null) {
                contextPath = context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
        }
        if (this.isSecure()) {
            cookie.setSecure(true);
        }
        if (context != null && context.isSessionCookieConfigInitialized()) {
            SessionCookieConfig sessionCookieConfig = context.getSessionCookieConfig();
            if (sessionCookieConfig.getDomain() != null) {
                cookie.setDomain(sessionCookieConfig.getDomain());
            }
            if (sessionCookieConfig.getPath() != null) {
                cookie.setPath(sessionCookieConfig.getPath());
            }
            if (sessionCookieConfig.getComment() != null) {
                cookie.setVersion(1);
                cookie.setComment(sessionCookieConfig.getComment());
            }
            cookie.setSecure(sessionCookieConfig.isSecure());
            cookie.setHttpOnly(sessionCookieConfig.isHttpOnly());
            cookie.setMaxAge(sessionCookieConfig.getMaxAge());
        }
        if (this.requestedSessionCookiePath != null) {
            cookie.setPath(this.requestedSessionCookiePath);
        }
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        this.cookies.clear();
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = this.makeCookie(scookie);
                cookie.setPath(scookie.getPath().toString());
                cookie.setVersion(scookie.getVersion());
                String domain = scookie.getDomain().toString();
                if (domain != null) {
                    cookie.setDomain(scookie.getDomain().toString());
                }
                this.cookies.add(cookie);
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    protected Cookie makeCookie(ServerCookie scookie) {
        return this.makeCookie(scookie, false);
    }

    protected Cookie makeCookie(ServerCookie scookie, boolean decode) {
        String name = scookie.getName().toString();
        String value = scookie.getValue().toString();
        if (decode) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name = URLDecoder.decode(name);
                value = URLDecoder.decode(value);
            }
        }
        return new Cookie(name, value);
    }

    protected void parseRequestParameters() {
        int semicolon;
        Parameters parameters = this.coyoteRequest.getParameters();
        String enc = this.getCharacterEncoding();
        this.requestParametersParsed = true;
        if (enc != null) {
            parameters.setEncoding(enc);
            parameters.setQueryStringEncoding(enc);
        } else {
            parameters.setEncoding("ISO-8859-1");
            parameters.setQueryStringEncoding("ISO-8859-1");
        }
        parameters.handleQueryParameters();
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            return;
        }
        int len = this.getContentLength();
        if (len > 0) {
            int maxPostSize = ((org.apache.catalina.connector.Connector)this.connector).getMaxPostSize();
            if (maxPostSize > 0 && len > maxPostSize) {
                this.log(sm.getString("coyoteRequest.postTooLarge"));
                throw new IllegalStateException("Post too large");
            }
            try {
                byte[] formData = this.getPostBody();
                if (formData != null) {
                    parameters.processParameters(formData, 0, len);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    protected byte[] getPostBody() throws IOException {
        int len = this.getContentLength();
        byte[] formData = null;
        if (len < 8192) {
            if (this.postData == null) {
                this.postData = new byte[8192];
            }
            formData = this.postData;
        } else {
            formData = new byte[len];
        }
        int actualLen = this.readPostBody(formData, len);
        if (actualLen == len) {
            return formData;
        }
        return null;
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.getStream().read(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Enumeration<String> values = this.getHeaders("accept-language");
        while (values.hasMoreElements()) {
            String value = values.nextElement();
            this.parseLocalesHeader(value);
        }
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuffer sb = new StringBuffer();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    quality = Double.parseDouble(entry.substring(semi + 3));
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            if (!Request.isAlpha(language) || !Request.isAlpha(country) || !Request.isAlpha(variant)) continue;
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        for (Double key : locales.keySet()) {
            ArrayList list = (ArrayList)locales.get(key);
            for (Locale locale : list) {
                this.addLocale(locale);
            }
        }
    }

    protected static final boolean isAlpha(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    protected void parseSessionId(String sessionParam) {
        ByteChunk uriBB = this.coyoteRequest.decodedURI().getByteChunk();
        int semicolon = uriBB.indexOf(sessionParam, 0, sessionParam.length(), 0);
        if (semicolon > 0) {
            int start = uriBB.getStart();
            int end = uriBB.getEnd();
            int sessionIdStart = start + semicolon + sessionParam.length();
            int semicolon2 = uriBB.indexOf(';', sessionIdStart);
            String sessionId = null;
            sessionId = semicolon2 >= 0 ? new String(uriBB.getBuffer(), sessionIdStart, semicolon2 - semicolon - sessionParam.length()) : new String(uriBB.getBuffer(), sessionIdStart, end - sessionIdStart);
            int jrouteIndex = sessionId.lastIndexOf(58);
            if (jrouteIndex > 0) {
                this.setRequestedSessionId(sessionId.substring(0, jrouteIndex));
                if (jrouteIndex < sessionId.length() - 1) {
                    this.setJrouteId(sessionId.substring(jrouteIndex + 1));
                }
            } else {
                this.setRequestedSessionId(sessionId);
            }
            this.setRequestedSessionURL(true);
            if (!this.coyoteRequest.requestURI().getByteChunk().isNull()) {
                this.parseSessionIdFromRequestURI(sessionParam);
            }
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
    }

    protected String parseSessionVersion() {
        String sessionVersionString = null;
        ByteChunk uriBB = this.coyoteRequest.decodedURI().getByteChunk();
        int semicolon = uriBB.indexOf(";jsessionidversion=", 0, ";jsessionidversion=".length(), 0);
        if (semicolon > 0) {
            int start = uriBB.getStart();
            int end = uriBB.getEnd();
            int sessionVersionStart = start + semicolon + ";jsessionidversion=".length();
            int semicolon2 = uriBB.indexOf(';', sessionVersionStart);
            sessionVersionString = semicolon2 >= 0 ? new String(uriBB.getBuffer(), sessionVersionStart, semicolon2 - semicolon - ";jsessionidversion=".length()) : new String(uriBB.getBuffer(), sessionVersionStart, end - sessionVersionStart);
            if (!this.coyoteRequest.requestURI().getByteChunk().isNull()) {
                this.removeSessionVersionFromRequestURI();
            }
        }
        return sessionVersionString;
    }

    protected void parseSessionIdFromRequestURI(String sessionParam) {
        ByteChunk uriBC = this.coyoteRequest.requestURI().getByteChunk();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        int semicolon = uriBC.indexOf(sessionParam, 0, sessionParam.length(), 0);
        if (semicolon > 0) {
            int sessionIdStart = start + semicolon;
            int semicolon2 = uriBC.indexOf(';', semicolon + sessionParam.length());
            uriBC.setEnd(start + semicolon);
            byte[] buf = uriBC.getBuffer();
            if (semicolon2 >= 0) {
                for (int i = 0; i < end - start - semicolon2; ++i) {
                    buf[start + semicolon + i] = buf[start + i + semicolon2];
                }
                uriBC.setBytes(buf, start, semicolon + (end - start - semicolon2));
            }
        }
    }

    protected void removeSessionVersionFromRequestURI() {
        ByteChunk uriBC = this.coyoteRequest.requestURI().getByteChunk();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        int semicolon = uriBC.indexOf(";jsessionidversion=", 0, ";jsessionidversion=".length(), 0);
        if (semicolon > 0) {
            int sessionVersionStart = start + semicolon;
            int semicolon2 = uriBC.indexOf(';', semicolon + ";jsessionidversion=".length());
            uriBC.setEnd(start + semicolon);
            byte[] buf = uriBC.getBuffer();
            if (semicolon2 >= 0) {
                for (int i = 0; i < end - start - semicolon2; ++i) {
                    buf[start + semicolon + i] = buf[start + i + semicolon2];
                }
                uriBC.setBytes(buf, start, semicolon + (end - start - semicolon2));
            }
        }
    }

    void parseSessionVersionString(String sessionVersionString) {
        if (sessionVersionString == null || !this.isSessionVersionSupported()) {
            return;
        }
        HashMap<String, String> sessionVersions = RequestUtil.parseSessionVersions(sessionVersionString);
        if (sessionVersions != null) {
            this.attributes.put("com.sun.enterprise.http.sessionVersions", sessionVersions);
            if (this.context != null) {
                String path = this.context.getPath();
                if ("".equals(path)) {
                    path = "/";
                }
                this.requestedSessionVersion = sessionVersions.get(path);
            }
        }
    }

    void parseJrouteCookie() {
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (!scookie.getName().equals("JROUTE")) continue;
            this.setJrouteId(scookie.getValue().toString());
            break;
        }
    }

    void setJrouteId(String jrouteId) {
        this.jrouteId = jrouteId;
    }

    @Override
    public String getJrouteId() {
        return this.jrouteId;
    }

    protected void parseSessionCookiesId() {
        Context context = (Context)this.getMappingData().context;
        if (context != null && !context.getCookies()) {
            return;
        }
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        String sessionCookieName = "JSESSIONID";
        if (context != null) {
            sessionCookieName = context.getSessionCookieName();
        }
        for (int i = 0; i < count; ++i) {
            String sessionVersionString;
            ServerCookie scookie = serverCookies.getCookie(i);
            if (!scookie.getName().equals(sessionCookieName)) continue;
            if (!this.isRequestedSessionIdFromCookie()) {
                B2CConverter.convertASCII(scookie.getValue());
                this.setRequestedSessionId(scookie.getValue().toString());
                sessionVersionString = this.getSessionVersionFromCookie();
                this.parseSessionVersionString(sessionVersionString);
                this.setRequestedSessionCookie(true);
                this.setRequestedSessionURL(false);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Requested cookie session id is " + this.getRequest().getRequestedSessionId());
                continue;
            }
            if (this.isRequestedSessionIdValid()) continue;
            B2CConverter.convertASCII(scookie.getValue());
            this.setRequestedSessionId(scookie.getValue().toString());
            sessionVersionString = this.getSessionVersionFromCookie();
            this.parseSessionVersionString(sessionVersionString);
        }
    }

    private String getSessionVersionFromCookie() {
        if (!this.isSessionVersionSupported()) {
            return null;
        }
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (!scookie.getName().equals("JSESSIONIDVERSION")) continue;
            return scookie.getValue().toString();
        }
        return null;
    }

    protected void convertURI(MessageBytes uri) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        int length = bc.getLength();
        cc.allocate(length, -1);
        String enc = this.connector.getURIEncoding();
        if (enc != null && !enc.isEmpty() && !"ISO-8859-1".equalsIgnoreCase(enc)) {
            B2CConverter conv = this.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    this.setURIConverter(conv);
                }
            }
            catch (IOException e) {
                log.severe("Invalid URI encoding; using HTTP default");
                this.connector.setURIEncoding(null);
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc, cc.getBuffer().length - cc.getEnd());
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    log.severe("Invalid URI character encoding; trying ascii");
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, length);
    }

    @Override
    public DispatcherType getDispatcherType() {
        DispatcherType dispatcher = (DispatcherType)((Object)this.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE"));
        if (dispatcher == null) {
            dispatcher = DispatcherType.REQUEST;
        }
        return dispatcher;
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        return this.startAsync(this.getRequest(), this.getResponse().getResponse(), true);
    }

    @Override
    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if ((servletRequest instanceof RequestFacade || servletRequest instanceof ApplicationHttpRequest) && (servletResponse instanceof ResponseFacade || servletResponse instanceof ApplicationHttpResponse)) {
            return this.startAsync(servletRequest, servletResponse, true);
        }
        return this.startAsync(servletRequest, servletResponse, false);
    }

    private AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse, boolean isOriginalRequestAndResponse) throws IllegalStateException {
        if (servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null request or response");
        }
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Async not supported for this request");
        }
        if (this.asyncContext != null) {
            if (!this.isOkToReinitializeAsync) {
                throw new IllegalStateException("startAsync already called");
            }
            this.asyncContext.reinitialize(servletRequest, servletResponse, isOriginalRequestAndResponse);
        } else {
            this.asyncContext = new AsyncContextImpl(this, servletRequest, (Response)this.getResponse(), servletResponse, isOriginalRequestAndResponse);
        }
        this.asyncStarted = true;
        this.isOkToReinitializeAsync = false;
        CompletionHandler<Request> requestCompletionHandler = new CompletionHandler<Request>(){

            @Override
            public void resumed(Request attachment) {
                attachment.notifyAsyncListeners(AsyncEventType.COMPLETE);
            }

            @Override
            public void cancelled(Request attachment) {
                attachment.asyncTimeout();
            }
        };
        Response res = (Response)this.coyoteRequest.getResponse().getNote(1);
        this.coyoteRequest.getResponse().suspend(this.asyncTimeoutMillis, this, requestCompletionHandler, new RequestAttachment<Request>((Long)this.asyncTimeoutMillis, this, requestCompletionHandler, res));
        return this.asyncContext;
    }

    @Override
    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted = asyncStarted;
    }

    @Override
    public void disableAsyncSupport() {
        this.isAsyncSupported = false;
    }

    void setOkToReinitializeAsync(boolean okToReInit) {
        this.isOkToReinitializeAsync = okToReInit;
    }

    @Override
    public boolean isAsyncSupported() {
        return this.isAsyncSupported;
    }

    @Override
    public AsyncContext getAsyncContext() {
        if (!this.isAsyncStarted()) {
            throw new IllegalStateException("Request not in async mode");
        }
        return this.asyncContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsyncListener(AsyncListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Missing listener");
        }
        Request request = this;
        synchronized (request) {
            if (this.asyncListenerHolders == null) {
                this.asyncListenerHolders = new LinkedList();
            }
            this.asyncListenerHolders.add(new AsyncListenerHolder(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsyncListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        if (listener == null || request == null || response == null) {
            throw new IllegalArgumentException("Missing listener, request, or response");
        }
        Request request2 = this;
        synchronized (request2) {
            if (this.asyncListenerHolders == null) {
                this.asyncListenerHolders = new LinkedList();
            }
            this.asyncListenerHolders.add(new AsyncListenerHolder(listener, request, response));
        }
    }

    @Override
    public void setAsyncTimeout(long timeout) {
        if (this.isAsyncStarted()) {
            throw new IllegalStateException("Request already in async mode");
        }
        this.asyncTimeoutMillis = timeout;
    }

    @Override
    public long getAsyncTimeout() {
        return this.asyncTimeoutMillis;
    }

    void asyncComplete() {
        this.asyncComplete(true);
    }

    void asyncComplete(boolean checkIsAsyncStarted) {
        if (checkIsAsyncStarted && !this.isAsyncStarted()) {
            throw new IllegalStateException("Request not in async mode");
        }
        this.isAsyncComplete = true;
        this.asyncStarted = false;
        this.coyoteRequest.getResponse().resume();
    }

    void asyncTimeout() {
        if (this.asyncListenerHolders == null || this.asyncListenerHolders.isEmpty()) {
            ((HttpServletResponse)((Object)this.response)).setStatus(500);
            StringBuilder sb = new StringBuilder();
            if (this.getServletPath() != null) {
                sb.append(this.getServletPath());
            }
            if (this.getPathInfo() != null) {
                sb.append(this.getPathInfo());
            }
            this.setAttribute("javax.servlet.error.status_code", 500);
            ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.getRequestDispatcher(sb.toString());
            try {
                dispatcher.dispatch(this.getRequest(), this.getResponse().getResponse(), DispatcherType.ERROR);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unable to perform ERROR dispatch", e);
            }
            this.asyncComplete();
        } else {
            this.notifyAsyncListeners(AsyncEventType.TIMEOUT);
            if (!this.isAsyncComplete && this.isAsyncStarted()) {
                this.asyncComplete();
            }
        }
    }

    private void notifyAsyncListeners(AsyncEventType asyncEventType) {
        AsyncListener asyncListener = null;
        ServletRequest asyncEventRequest = null;
        ServletResponse asyncEventResponse = null;
        if (this.asyncListenerHolders != null) {
            for (AsyncListenerHolder asyncListenerHolder : this.asyncListenerHolders) {
                asyncListener = asyncListenerHolder.getAsyncListener();
                asyncEventRequest = asyncListenerHolder.getRequest();
                if (asyncEventRequest == null) {
                    asyncEventRequest = this.asyncContext.getRequest();
                }
                if ((asyncEventResponse = asyncListenerHolder.getResponse()) == null) {
                    asyncEventResponse = this.asyncContext.getResponse();
                }
                try {
                    switch (asyncEventType) {
                        case COMPLETE: {
                            asyncListener.onComplete(new AsyncEvent(asyncEventRequest, asyncEventResponse));
                            break;
                        }
                        case TIMEOUT: {
                            asyncListener.onTimeout(new AsyncEvent(asyncEventRequest, asyncEventResponse));
                        }
                    }
                }
                catch (IOException ioe) {
                    log.log(Level.WARNING, "Error invoking AsyncListener", ioe);
                }
            }
        }
    }

    private Multipart getMultipart() {
        if (this.multipart == null) {
            this.multipart = new Multipart(this, this.wrapper.getMultipartLocation(), this.wrapper.getMultipartMaxFileSize(), this.wrapper.getMultipartMaxRequestSize(), this.wrapper.getMultipartFileSizeThreshold());
        }
        return this.multipart;
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        return this.getMultipart().getParts();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        return this.getMultipart().getPart(name);
    }

    private void log(String message) {
        Logger logger = this.connector.getContainer().getLogger();
        String localName = "Request";
        if (logger != null) {
            logger.log(localName + " " + message);
        } else {
            log.info(localName + " " + message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        if (this.connector != null && this.connector.getContainer() != null) {
            logger = this.connector.getContainer().getLogger();
        }
        String localName = "Request";
        if (logger != null) {
            logger.log(localName + " " + message, t, 2);
        } else {
            log.log(Level.WARNING, localName + " " + message, t);
        }
    }

    private void populateSSLAttributes() {
        this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_ATTRIBUTE, this.coyoteRequest);
        Object attr = this.coyoteRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (attr != null) {
            this.attributes.put("javax.servlet.request.X509Certificate", attr);
        }
        if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.cipher_suite")) != null) {
            this.attributes.put("javax.servlet.request.cipher_suite", attr);
        }
        if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.key_size")) != null) {
            this.attributes.put("javax.servlet.request.key_size", attr);
        }
    }

    private void initSessionTracker() {
        this.notes.put("com.sun.enterprise.http.sessionTracker", this.sessionTracker);
    }

    private void incrementSessionVersion(StandardSession ss, Context context) {
        String path;
        if (ss == null || context == null) {
            return;
        }
        String versionString = Long.toString(ss.incrementVersion());
        HashMap<String, String> sessionVersions = (HashMap<String, String>)this.getAttribute("com.sun.enterprise.http.sessionVersions");
        if (sessionVersions == null) {
            sessionVersions = new HashMap<String, String>();
            this.setAttribute("com.sun.enterprise.http.sessionVersions", sessionVersions);
        }
        if ("".equals(path = context.getPath())) {
            path = "/";
        }
        sessionVersions.put(path, versionString);
    }

    private boolean isSessionVersionSupported() {
        return this.context != null && this.context.getManager() != null && this.context.getManager().isSessionVersioningSupported();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RequestAttachment<A>
    extends Response.ResponseAttachment {
        private Response res;

        public RequestAttachment(Long timeout, A attachment, CompletionHandler<? super A> completionHandler, Response res) {
            super(timeout, attachment, completionHandler, res.getCoyoteResponse());
            this.res = res;
        }

        @Override
        public void resume() {
            this.getCompletionHandler().resumed(this.getAttachment());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "RequestAttachement.resume: " + this.res);
            }
            this.completeProcessing();
        }

        void completeProcessing() {
            block2: {
                try {
                    this.res.finishResponse();
                }
                catch (IOException ex) {
                    if (!log.isLoggable(Level.FINE)) break block2;
                    log.log(Level.FINE, "res.finishResponse()" + this.res);
                }
            }
            this.res.recycle();
            this.res.getRequest().recycle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeout(boolean forceClose) {
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "RequestAttachement.timeout: " + this.res);
                }
                this.getCompletionHandler().cancelled(this.getAttachment());
            }
            finally {
                this.completeProcessing();
            }
        }
    }

    private static class AsyncListenerHolder {
        private AsyncListener listener;
        private ServletRequest request;
        private ServletResponse response;

        public AsyncListenerHolder(AsyncListener listener) {
            this(listener, null, null);
        }

        public AsyncListenerHolder(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.listener = listener;
            this.request = request;
            this.response = response;
        }

        public AsyncListener getAsyncListener() {
            return this.listener;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AsyncEventType {
        COMPLETE,
        TIMEOUT;

    }
}

