/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.admin;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.ConfigParser;
import org.glassfish.scripting.jruby.admin.Messages;
import org.glassfish.scripting.jruby.config.JrubyContainer;
import org.glassfish.scripting.jruby.config.JrubyRuntimePool;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="configure-jruby-container")
@I18n(value="configure-jruby-container.command")
@Scoped(value=PerLookup.class)
public class JRubyContainerCommand
implements AdminCommand {
    @Inject(optional=true)
    JrubyContainer container;
    @Inject
    ConfigParser parser;
    @Inject
    Habitat habitat;
    @Param(name="jruby-home", optional=true)
    String jrubyHome;
    @Param(name="jruby-runtime", optional=true, shortName="runtime")
    String jrubyRuntime;
    @Param(name="jruby-runtime-min", optional=true, shortName="runtime-min")
    String jrubyRuntimeMin;
    @Param(name="jruby-runtime-max", optional=true, shortName="runtime-max")
    String jrubyRuntimeMax;
    @Param(name="show", optional=true, acceptableValues="true,false")
    String show;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.container == null) {
            URL xml = this.getClass().getClassLoader().getResource("/org/glassfish/scripting/jruby/config/jruby-container-config.xml");
            try {
                this.container = (JrubyContainer)this.parser.parseContainerConfig(this.habitat, xml, JrubyContainer.class);
                String home = System.getProperty("com.sun.aas.installRoot") + File.separator + "jruby";
                if (!new File(home).exists()) {
                    home = "";
                }
                try {
                    final String home1 = home;
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JrubyContainer>(){

                        public Object run(JrubyContainer param) throws PropertyVetoException, TransactionFailure {
                            param.setJrubyHome(home1);
                            return null;
                        }
                    }, (ConfigBeanProxy)this.container);
                }
                catch (TransactionFailure e) {
                    report.failure(context.getLogger(), Messages.format("jruby-config.failed", new Object[0]), (Throwable)e);
                }
            }
            catch (IOException e) {
                report.failure(context.logger, "Failed to create <jruby-container> config element", (Throwable)e);
            }
        }
        this.updateJRubyHome(context);
        this.updateJRubyRuntimePool(context);
        if (this.show != null && Boolean.valueOf(this.show).booleanValue()) {
            report.setActionDescription("current.config");
            report.getTopMessagePart().addChild().setMessage("jruby-home=" + this.container.getJrubyHome());
            report.getTopMessagePart().addChild().setMessage("initial-pool-size=" + this.container.getJrubyRuntimePool().getInitialPoolSize());
            report.getTopMessagePart().addChild().setMessage("min-pool-size=" + this.container.getJrubyRuntimePool().getMinPoolSize());
            report.getTopMessagePart().addChild().setMessage("max-pool-size=" + this.container.getJrubyRuntimePool().getMaxPoolSize());
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
    }

    private void updateJRubyHome(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.jrubyHome == null) {
            return;
        }
        if (!new File(this.jrubyHome).exists()) {
            report.failure(context.logger, Messages.format("jruby-home.notexist", this.jrubyHome));
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JrubyContainer>(){

                public Object run(JrubyContainer param) throws PropertyVetoException, TransactionFailure {
                    param.setJrubyHome(JRubyContainerCommand.this.jrubyHome);
                    return null;
                }
            }, (ConfigBeanProxy)this.container);
            report.getTopMessagePart().setMessage(Messages.format("jruby-home.success", this.jrubyHome));
        }
        catch (TransactionFailure e) {
            report.failure(context.getLogger(), Messages.format("jruby-home.failure", new Object[0]), (Throwable)e);
        }
    }

    private void updateJRubyRuntimePool(AdminCommandContext context) {
        if (this.jrubyRuntime == null && this.jrubyRuntimeMin == null && this.jrubyRuntimeMax == null) {
            return;
        }
        ActionReport report = context.getActionReport();
        JrubyRuntimePool pool = this.container.getJrubyRuntimePool();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JrubyRuntimePool>(){

                public Object run(JrubyRuntimePool param) throws PropertyVetoException, TransactionFailure {
                    param.setInitialPoolSize(JRubyContainerCommand.this.jrubyRuntime);
                    param.setMinPoolSize(JRubyContainerCommand.this.jrubyRuntimeMin);
                    param.setMaxPoolSize(JRubyContainerCommand.this.jrubyRuntimeMax);
                    return null;
                }
            }, (ConfigBeanProxy)pool);
            report.getTopMessagePart().setMessage(Messages.format("jruby-runtime-pool.success", pool.getInitialPoolSize(), pool.getMinPoolSize(), pool.getMaxPoolSize()));
        }
        catch (TransactionFailure e) {
            context.logger.log(Level.SEVERE, "jruby-runtime-pool.failure", e);
        }
    }
}

