/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.MBeanTrackerMBean;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.api.amx.AMXMBeanMetadata;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
@AMXMBeanMetadata(singleton=true, globalSingleton=true, leaf=true)
public final class MBeanTracker
implements NotificationListener,
MBeanRegistration,
MBeanTrackerMBean {
    final ConcurrentMap<ObjectName, Set<ObjectName>> mParentChildren = new ConcurrentHashMap<ObjectName, Set<ObjectName>>();
    final ConcurrentMap<ObjectName, ObjectName> mChildParent = new ConcurrentHashMap<ObjectName, ObjectName>();
    private volatile MBeanServer mServer;
    private volatile ObjectName mObjectName;

    private static void debug(Object o) {
        System.out.println("" + o);
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        if (notifIn instanceof MBeanServerNotification) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            String type = notif.getType();
            ObjectName objectName = notif.getMBeanName();
            if (type.equals("JMX.mbean.registered")) {
                this.addChild(objectName);
            } else if (type.equals("JMX.mbean.unregistered")) {
                this.removeChild(objectName);
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        this.mServer = server;
        this.mObjectName = nameIn;
        return nameIn;
    }

    @Override
    public final void postRegister(Boolean registrationSucceeded) {
        if (registrationSucceeded.booleanValue()) {
            try {
                this.mServer.addNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not register with MBeanServerDelegate", e);
            }
        }
        ObjectName pattern = Util.newObjectNamePattern(AMXGlassfish.DEFAULT.amxJMXDomain(), "");
        Set<ObjectName> names = JMXUtil.queryNames(this.mServer, pattern, null);
        for (ObjectName o : names) {
            this.addChild(o);
        }
    }

    @Override
    public final void preDeregister() throws Exception {
        this.mServer.removeNotificationListener(this.mObjectName, this);
    }

    @Override
    public final void postDeregister() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChild(ObjectName child) {
        ObjectName parent = null;
        try {
            parent = (ObjectName)this.mServer.getAttribute(child, "Parent");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parent != null) {
            MBeanTracker mBeanTracker = this;
            synchronized (mBeanTracker) {
                this.mChildParent.put(child, parent);
                HashSet<ObjectName> children = (HashSet<ObjectName>)this.mParentChildren.get(parent);
                if (children == null) {
                    children = new HashSet<ObjectName>();
                    this.mParentChildren.put(parent, children);
                }
                children.add(child);
            }
        }
    }

    private synchronized ObjectName removeChild(ObjectName child) {
        Set children;
        ObjectName parent = (ObjectName)this.mChildParent.remove(child);
        if (parent != null && (children = (Set)this.mParentChildren.get(parent)) != null) {
            children.remove(child);
            if (children.size() == 0) {
                this.mParentChildren.remove(parent);
            }
        }
        return parent;
    }

    @Override
    public ObjectName getParentOf(ObjectName child) {
        return (ObjectName)this.mChildParent.get(child);
    }

    @Override
    public synchronized Set<ObjectName> getChildrenOf(ObjectName parent) {
        Set children = (Set)this.mParentChildren.get(parent);
        if (children == null) {
            return Collections.emptySet();
        }
        return new HashSet<ObjectName>(children);
    }
}

