/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.NoSuchElementException;

public class ArgumentTokenizer {
    protected int currentPosition = 0;
    protected int maxPosition;
    protected String str;
    protected StringBuilder token = new StringBuilder();
    private static final LocalStringsImpl strings = new LocalStringsImpl(ArgumentTokenizer.class);

    public ArgumentTokenizer(String str) {
        this.str = str;
        this.maxPosition = str.length();
    }

    protected void skipWhiteSpace() {
        while (this.currentPosition < this.maxPosition && Character.isWhitespace(this.str.charAt(this.currentPosition))) {
            ++this.currentPosition;
        }
    }

    public boolean hasMoreTokens() {
        this.skipWhiteSpace();
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() throws ArgumentException {
        this.skipWhiteSpace();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException(strings.get("token.noMoreTokens"));
        }
        return this.scanToken();
    }

    protected String scanToken() throws ArgumentException {
        while (this.currentPosition < this.maxPosition) {
            char c;
            if ((c = this.str.charAt(this.currentPosition++)) == '\"' || c == '\'') {
                char quote = c;
                while (this.currentPosition < this.maxPosition) {
                    if ((c = this.str.charAt(this.currentPosition++)) == '\\' && quote == '\"') {
                        if (this.currentPosition >= this.maxPosition) {
                            throw new ArgumentException(strings.get("token.escapeAtEOL"));
                        }
                        if ((c = this.str.charAt(this.currentPosition++)) != '\\' && c != '\"' && c != '\'') {
                            this.token.append('\\');
                        }
                    } else if (c == quote) break;
                    this.token.append(c);
                }
                if (c == quote) continue;
                throw new ArgumentException(strings.get("token.unbalancedQuotes"));
            }
            if (c == '\\') {
                if (this.currentPosition >= this.maxPosition) {
                    throw new ArgumentException(strings.get("token.escapeAtEOL"));
                }
                if ((c = this.str.charAt(this.currentPosition++)) != '\\' && c != '\"' && c != '\'' && !Character.isWhitespace(c)) {
                    this.token.append('\\');
                }
                this.token.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) break;
            this.token.append(c);
        }
        String s = this.token.toString();
        this.token.setLength(0);
        return s;
    }

    public static class ArgumentException
    extends Exception {
        public ArgumentException(String s) {
            super(s);
        }
    }
}

