/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.util.Utility;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.ORB;

@Service
public class EjbNamingReferenceManagerImpl
implements EjbNamingReferenceManager {
    private static final String CORBANAME = "corbaname:";
    private static final String IIOPURL = "iiop://";
    @Inject
    InvocationManager invMgr;
    @Inject
    Habitat habitat;
    private volatile EjbContainerUtil ejbContainerUtil;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object resolveEjbReference(EjbReferenceDescriptor ejbRefDesc, Context context) throws NamingException {
        Object object;
        boolean resolved;
        Object jndiObj;
        block17: {
            jndiObj = null;
            resolved = false;
            if (ejbRefDesc.isLocal()) {
                if (ejbRefDesc.hasLookupName()) {
                    jndiObj = context.lookup(ejbRefDesc.getLookupName());
                    resolved = true;
                }
            } else if (!ejbRefDesc.hasJndiName() && ejbRefDesc.hasLookupName()) {
                jndiObj = context.lookup(ejbRefDesc.getLookupName());
                resolved = true;
            } else if (ejbRefDesc.hasJndiName() && ejbRefDesc.getJndiName().startsWith("java:app/") && !ejbRefDesc.getJndiName().startsWith("java:app/env/")) {
                String remoteJndiName = ejbRefDesc.getJndiName();
                String appName = (String)context.lookup("java:comp/AppName");
                String newPrefix = "java:global/" + appName + "/";
                int javaAppLength = "java:app/".length();
                String globalLookup = newPrefix + remoteJndiName.substring(javaAppLength);
                jndiObj = context.lookup(globalLookup);
                resolved = true;
            } else {
                String remoteJndiName = EJBUtils.getRemoteEjbJndiName(ejbRefDesc);
                ClassLoader origClassLoader = Utility.getClassLoader();
                boolean setCL = false;
                try {
                    try {
                        try {
                            String refInterface = ejbRefDesc.isEJB30ClientView() ? ejbRefDesc.getEjbInterface() : ejbRefDesc.getHomeClassName();
                            origClassLoader.loadClass(refInterface);
                        }
                        catch (ClassNotFoundException e) {
                            ClassLoader referringBundleClassLoader = ejbRefDesc.getReferringBundleDescriptor().getClassLoader();
                            Utility.setContextClassLoader((ClassLoader)referringBundleClassLoader);
                            setCL = true;
                        }
                        if (remoteJndiName.startsWith(CORBANAME)) {
                            GlassFishORBHelper orbHelper = (GlassFishORBHelper)this.habitat.getComponent(GlassFishORBHelper.class);
                            ORB orb = orbHelper.getORB();
                            jndiObj = orb.string_to_object(remoteJndiName);
                        } else {
                            jndiObj = context.lookup(remoteJndiName);
                        }
                    }
                    catch (Exception e) {
                        NamingException ne = new NamingException("Exception resolving Ejb for '" + ejbRefDesc + "' .  Actual (possibly internal) Remote JNDI name used for lookup is '" + remoteJndiName + "'");
                        ne.initCause(e);
                        throw ne;
                    }
                    Object var11_18 = null;
                    if (!setCL) break block17;
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    if (!setCL) throw throwable;
                    Utility.setContextClassLoader((ClassLoader)origClassLoader);
                    throw throwable;
                }
                Utility.setContextClassLoader((ClassLoader)origClassLoader);
            }
        }
        if (resolved) {
            object = jndiObj;
            return object;
        }
        object = EJBUtils.resolveEjbRefObject(ejbRefDesc, jndiObj);
        return object;
    }

    public boolean isEjbReferenceCacheable(EjbReferenceDescriptor ejbRefDesc) {
        return false;
    }

    public Object getEJBContextObject(String contextType) {
        ComponentInvocation currentInv = this.invMgr.getCurrentInvocation();
        if (currentInv == null) {
            throw new IllegalStateException("no current invocation");
        }
        if (currentInv.getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
            throw new IllegalStateException("Illegal invocation type for EJB Context : " + currentInv.getInvocationType());
        }
        EjbInvocation ejbInv = (EjbInvocation)currentInv;
        Object returnObject = ejbInv.context;
        if (contextType.equals("javax.ejb.TimerService")) {
            if (this.ejbContainerUtil == null) {
                this.ejbContainerUtil = (EjbContainerUtil)this.habitat.getByContract(EjbContainerUtil.class);
            }
            if (this.ejbContainerUtil == null) {
                throw new IllegalStateException("EJB Timer Service not available. And EjbContainerUtil is null");
            }
            if (this.ejbContainerUtil.getEJBTimerService() == null) {
                throw new IllegalStateException("EJB Timer Service not available");
            }
            returnObject = new EJBTimerServiceWrapper(this.ejbContainerUtil.getEJBTimerService(), (EJBContextImpl)ejbInv.context);
        }
        return returnObject;
    }
}

