/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.enterprise.admin.monitor.stats.MutableTimeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.TimeStatisticImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.j2ee.statistics.TimeStatistic;

@ManagedObject
@Description(value="Ejb Method Statistics")
public class EjbMethodStatsProvider {
    private CountStatisticImpl executionStat = new CountStatisticImpl("ExecutionTime", "Milliseconds", null);
    private CountStatisticImpl invocationStat = new CountStatisticImpl("TotalNumInvocations", "count", null);
    private CountStatisticImpl errorStat = new CountStatisticImpl("TotalNumErrors", "count", null);
    private CountStatisticImpl successStat = new CountStatisticImpl("TotalNumSuccess", "count", null);
    private MutableTimeStatisticImpl methodStat = null;
    private static ThreadLocal execThreadLocal = new ThreadLocal();
    private Method m = null;
    private boolean registered = false;

    EjbMethodStatsProvider(Method m) {
        this.m = m;
        long now = System.currentTimeMillis();
        this.methodStat = new MutableTimeStatisticImpl((TimeStatistic)new TimeStatisticImpl(0L, 0L, 0L, 0L, "MethodStatistic", "", "", now, now));
    }

    @ManagedAttribute(id="methodstatistic")
    @Description(value="Number of times the operation is called; total time spent during invocation, and so on.")
    public org.glassfish.external.statistics.TimeStatistic getMethodStatistic() {
        return null;
    }

    @ManagedAttribute(id="totalnumerrors")
    @Description(value="Number of times the method execution resulted in an exception")
    public CountStatistic getTotalNumErrors() {
        return this.errorStat;
    }

    @ManagedAttribute(id="totalnumsuccess")
    @Description(value="Number of times the method successfully executed")
    public CountStatistic getTotalNumSuccess() {
        return this.successStat;
    }

    @ManagedAttribute(id="executiontime")
    @Description(value="Time (ms) spent executing method for the last successful/unsuccessful attempt to execute the operation")
    public CountStatistic getTotalExecutionTime() {
        return this.executionStat;
    }

    void registered() {
        this.registered = true;
    }

    void unregistered() {
        this.registered = false;
    }

    boolean isRegistered() {
        return this.registered;
    }

    void methodStart() {
        ArrayList<Long> list = (ArrayList<Long>)execThreadLocal.get();
        if (list == null) {
            list = new ArrayList<Long>(5);
            execThreadLocal.set(list);
        }
        list.add(new Long(System.currentTimeMillis()));
        this.invocationStat.increment();
    }

    void methodEnd(boolean success) {
        ArrayList list = (ArrayList)execThreadLocal.get();
        if (list != null && list.size() > 0) {
            int index = list.size();
            Long startTime = (Long)list.remove(index - 1);
            if (success) {
                this.successStat.increment();
            } else {
                this.errorStat.increment();
            }
            if (startTime != null) {
                long diff = System.currentTimeMillis() - startTime;
                this.executionStat.setCount(diff);
                this.methodStat.incrementCount(diff);
            }
        }
    }
}

