/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context.beanstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.context.spi.Contextual;
import org.jboss.webbeans.ContextualIdStore;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.api.ContexutalInstance;
import org.jboss.webbeans.context.beanstore.BeanStoreNamingScheme;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.collections.EnumerationList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeBackedBeanStore
implements BeanStore {
    private static LogProvider log = Logging.getLogProvider(AbstractAttributeBackedBeanStore.class);

    @Override
    public <T> ContexutalInstance<T> get(Contextual<? extends T> contextual) {
        Integer contextualId = CurrentManager.rootManager().getServices().get(ContextualIdStore.class).getId(contextual);
        String key = this.getNamingScheme().getKeyFromId(contextualId);
        ContexutalInstance instance = (ContexutalInstance)this.getAttribute(key);
        log.trace("Looked for " + key + " and got " + instance);
        return instance;
    }

    public <T> T remove(Contextual<? extends T> contextual) {
        Integer contextualId = CurrentManager.rootManager().getServices().get(ContextualIdStore.class).getId(contextual);
        T instance = this.get(contextual).getInstance();
        String key = this.getNamingScheme().getKeyFromId(contextualId);
        this.removeAttribute(key);
        log.trace("Removed bean under key " + key);
        return instance;
    }

    @Override
    public void clear() {
        for (String attributeName : this.getFilteredAttributeNames()) {
            this.removeAttribute(attributeName);
        }
        log.trace("Bean store cleared");
    }

    public Collection<Contextual<? extends Object>> getContextuals() {
        ArrayList<Contextual<? extends Object>> contextuals = new ArrayList<Contextual<? extends Object>>();
        BeanStoreNamingScheme namingScheme = this.getNamingScheme();
        for (String attributeName : this.getFilteredAttributeNames()) {
            Integer id = namingScheme.getIdFromKey(attributeName);
            Contextual contextual = CurrentManager.rootManager().getServices().get(ContextualIdStore.class).getContextual(id);
            contextuals.add(contextual);
        }
        return contextuals;
    }

    private List<String> getFilteredAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        BeanStoreNamingScheme namingScheme = this.getNamingScheme();
        for (String attributeName : new EnumerationList<String>(this.getAttributeNames())) {
            if (!namingScheme.acceptKey(attributeName)) continue;
            attributeNames.add(attributeName);
        }
        return attributeNames;
    }

    @Override
    public <T> void put(ContexutalInstance<T> beanInstance) {
        Integer contextualId = CurrentManager.rootManager().getServices().get(ContextualIdStore.class).getId(beanInstance.getContextual());
        String key = this.getNamingScheme().getKeyFromId(contextualId);
        this.setAttribute(key, beanInstance);
        log.trace("Added Contextual type " + beanInstance.getContextual() + " under key " + key);
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration<String> getAttributeNames();

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract BeanStoreNamingScheme getNamingScheme();

    public String toString() {
        return "holding " + Names.count(this.getContextuals()) + " instances";
    }
}

