/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.jsf;

import javax.enterprise.inject.AnnotationLiteral;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.conversation.ConversationIdName;
import org.jboss.webbeans.jsf.JsfApiAbstraction;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ServletHelper;
import org.jboss.webbeans.util.Reflections;

public class JsfHelper {
    private static LogProvider log = Logging.getLogProvider(JsfHelper.class);

    public static boolean isPostback(FacesContext facesContext) {
        if (CurrentManager.rootManager().getServices().get(JsfApiAbstraction.class).isApiVersionCompatibleWith(2.0)) {
            return (Boolean)Reflections.invokeAndWrap("isPostback", (Object)facesContext, new Object[0]);
        }
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    public static String getConversationIdFromRequest(FacesContext facesContext) {
        BeanManagerImpl moduleBeanManager = JsfHelper.getModuleBeanManager(facesContext);
        String cidName = moduleBeanManager.getInstanceByType(String.class, new AnnotationLiteral<ConversationIdName>(){});
        String cid = (String)facesContext.getExternalContext().getRequestParameterMap().get(cidName);
        log.trace("Found conversation id " + cid + " in request parameter");
        return cid;
    }

    public static String getConversationId(FacesContext facesContext) {
        String cid = JsfHelper.getConversationIdFromRequest(facesContext);
        log.debug("Resuming conversation with id " + cid);
        return cid;
    }

    public static HttpSession getHttpSession(FacesContext facesContext) {
        Object session = facesContext.getExternalContext().getSession(true);
        if (session instanceof HttpSession) {
            return (HttpSession)session;
        }
        return null;
    }

    public static BeanManagerImpl getModuleBeanManager(FacesContext facesContext) {
        if (facesContext.getExternalContext().getContext() instanceof ServletContext) {
            return ServletHelper.getModuleBeanManager((ServletContext)facesContext.getExternalContext().getContext());
        }
        throw new IllegalStateException("Web Beans doesn not support using JSF in an non-servlet environment");
    }
}

